;LibEntry.ASM  - Entry module for Visual Basic Add-On DLL
;Copyright (c) 1991 Jay Munro
;First Published in PC Magazine June 16, 1992

.286
.Model Medium

;----------------------------------------------------------------------------
;Public Declarations
;----------------------------------------------------------------------------

Public LibEntry                         ;So Windows can find it

Extrn  LibMain:  Proc                   ;declare modules needed
Extrn  LocalInit:Proc


.Data

Dummy  DB    16  Dup (0)                ;Assembler .DLL's need this

.Code

;----------------------------------------------------------------------------
;LibEntry module
;----------------------------------------------------------------------------

LibEntry Proc Far
   Push    DI               ; handle of the module instance
   Push    DS               ; library data segment
   Push    CX               ; heap size
; -- not used for Visual Basic
;   Push    ES               ; command line segment
;   Push    SI               ; command line offset

;---- If CX <> 0 then we have some heap to initialize
   jcxz    CallMain         ; jump if no heap specified

;---- Call Windows LocalInit to initialize local heap
   Xor     AX,AX
   Push    DS
   Push    AX
   Push    CX
   Call    LocalInit
   Or      AX,AX            ; did it do it ok ?
   Jz      Error1           ; quit if it failed

;---- LibMain can be called to do any special initialization

CallMain:
   Call Far Ptr LibMain     ; invoke the startup routine (result in AX)
   Jmp short Exit1          ; LibMain is responsible for stack clean up

Error1:                     ; no heap to initialize, or error
;   Pop     SI               ;    clean up stack
;   Pop     ES
   Pop     CX
   Pop     DS
   Pop     DI

Exit1:
   Ret
LibEntry EndP
End LibEntry            ;show Windows where to start
