;VarSeg.ASM
;Copyright (c) 1992 Jay Munro
;First Published in PC Magazine June 16, 1992 
;----------------------------------------------------------------------------
;Varseg - Returns segment selector of numeric variable, array or type.
;Varptr - Returns address of numeric variable, array or type
;Seg - Return long pointer to numeric variable, array or type.
;SSeg - Returns string segment of a variable length string.
;Sadd - Returns string address of a variable length string.

;syntax
;  Declare Function VarSeg% Lib "LabNotes.DLL" (Variable as any)
;  Declare Function VarPtr% Lib "LabNotes.DLL" (Variable as any)
;  Declare Function Seg& Lib "LabNotes.DLL" (Variable as any)
;  Declare Function SSeg% Lib "LabNotes.DLL" (StringVariable$)
;  Declare Function Sadd% Lib "LabNotes.DLL" (StringVariable$)
;----------------------------------------------------------------------------

;*** Note ***
; Seg is aliased from LSeg in Labnotes.DEF

.286P
.Model Medium
  Public VarSeg,VarPtr, SSeg, Sadd, LSeg
  Include Labnotes.Inc
  Extrn VBDeRefHlStr:Proc
  
.Code

  SSeg Proc Far
     WinProlog
     Lds  AX,[BP+6]
     Push DS
     Push AX
     Call VBDeRefHlStr
     Xchg DX,AX
     WinEpilog
     Ret 4
  SSeg EndP
  
  Sadd Proc Far
     WinProlog
     Lds  AX, [BP+6]
     Push DS
     Push AX
     Call VBDeRefHlStr
     WinEpilog
     Ret 4
  Sadd EndP

  VarPtr Proc Far
     ShortWinProlog
     Mov AX, [BP+6]
     ShortWinEpilog
     Ret 4
  VarPtr EndP
  
  VarSeg Proc Far
     ShortWinProlog
     Mov AX, [BP+8]
     ShortWinEpilog
     Ret 4
  VarSeg EndP

  LSeg Proc Far
     ShortWinProlog
     Mov AX, [BP+6]
     Mov DX, [BP+8]
     ShortWinEpilog
     Ret 4
  LSeg EndP

End
