;PCMark.ASM
;Utility to mark .DLL headers for use with Windows 3.0
;Copyright (c) 1992 Jay Munro
;First Published in PC Magazine June 16, 1992
;----------------------------------------------------------------------------
;  PCMark sets the version byte, and bits for memory and font use in a
;  new style header.  It is the programmers responsibility to make sure
;  the program being marked really is compatible with Windows 3.0
;
;----------------------------------------------------------------------------
DosSeg                  ;standard DOS program

.Model Small
.Data
   Logo         DB      'PCMark  Copyright (c) 1992  Jay Munro',13,10
                DB      'First Published in PC Magazine June 16, 1992$'
   ErrorNumber  DW      0
   FileHandle   DW      0
   NE_Start     DW      0                       ;offset of new header
   CRLF         DB      10,13,'$'
   TooBig       DB      'Too much on command line $'
   BadDll       DB      'Not a Windows DLL file $'

   BeenMarked   DB      'File already is Windows 3 compatible $'
   NoFile       DB      'No file specified $'
   FileError    DB      'File Error $'
   FileNotFound DB      'File Not Found $'
   PathNotFound DB      'Path Not Found $'
   AccessDenied DB      'Access Denied $'
   BadDos       DB      'PCMark needs Version 3.0 DOS or better $'
   Success      DB      'File marked $'

   CmdLineMsg   DB      'Checking File '
   Buffer       DB      100h Dup (?)             ;set aside 256 byte buffer

.Stack          256

.Code

Start:
        Mov     AX,@DATA
        Mov     DS,AX
        Assume  DS:@Data
        Mov     DX, Offset Logo ;print logo first
        Call    PrintMsg

        Mov     AH,30h          ;get dos version number
        Int     21h
        Cmp     AL,3            ;is it 3 or better?
        Mov     DX,Offset BadDos
        Jge     @F
        Jmp     ErrorMsg        ;nope, then we can't use it

@@:
;----- Get PSP address to retrieve command line arguments
        Mov     AH,62h
        Int     21h
        Push    DS              ;point ES at DS
        Pop     ES              ;
        Mov     DS,BX           ;assign PSP segment to DS
        Mov     CL,Byte Ptr DS:[80h]  ;get length of command line (80h = offset)
        Xor     CH,CH           ;clear CH so we can use all of CX
        Mov     SI,81h          ;point SI to the beginning of the command$

FindStart:                      ;move past any leading "white space"
        Mov     AL,[SI]           ;get a character
        Cmp     AL," "          ;is it a blank space?
        Je      @F              ;yes, then get next character
        Cmp     AL,9            ;no, but is it a tab character?
        Jne     CopyCmd         ;no, then go copy the string
@@:
        Inc  SI                 ;point to next byte in COMMAND$
        Loop FindStart

CopyCmd:
        Mov     DX,Offset NoFile
        Or      CX,CX
        Jnz     @F
        Push    ES
        Pop     DS
        Jmp     ErrorMsg        ;no command line, no file
@@:
        Lea     DI, Buffer      ;get address of command line
        Rep     Movsb           ;copy command line args to local buffer
        Mov     AX,0024h        ;put a 0$ at the end
        StoSW                   ;store it
        Push    ES              ;restore DS to DGroup
        Pop     DS
        Mov     DX,Offset CmdLineMsg
        Call    PrintMsg

OpenFile:
        Mov     SI,Offset Buffer ;save address in SI for later use
        Mov     DX,SI           ;and put it in DX for DOS use
        Mov     AX,3D02h        ;open for read/write - compatibility mode
        Int     21h             ;open it.
        Jc      ErrorLily       ;oops an error
        Mov     BX,AX           ;put file handle in BX
        Mov     FileHandle,BX

                                ;now clear buffer
        Mov     CX,50           ;do 50 words
        Xor     AX,AX
        Mov     DI,SI           ;point DI at start of buffer
        Rep     StoSw

        Call    ReadFile
        Jnc     @F
        Jmp     FileErrorExit
@@:
        Cmp     AX,99           ;how about a not enough file?
        Jz      ErrorLily

CheckEXE:
        Cmp     Word Ptr [SI],"MZ"      ;is there an EXE signature?
        Mov     AX,99
        Jnz     @F

ErrorLily:
        Jmp     FileErrorExit           ;no, get out now
@@:

        Mov     DX,[SI+3Ch]             ;get offset of new-style header
                                        ;assuming Stub is < 64K
        Mov     DI,SI                   ;save SI in DI
        Mov     NE_Start,DX             ;save this info

        Call    Seek                    ;Move file pointer
        Jnc     @F
        Jmp     FileErrorExit
@@:
        Call    ReadFile                ;and read in some more
        Jnc     CheckSignature
        Jmp     FileErrorExit

;----- Check Signature
CheckSignature:

        Cmp     Word Ptr [SI],"EN"      ;check for new-style header signature
        Jz      @F
        Mov     DX,Offset BadDLL
        Jmp     ErrorMsg

;----- Check Window Operating System Flag
@@:
        Mov     AL,[SI+36h]             ;get byte flag
        And     AL,02                   ;check Windows byte
        Jnz     @F
        Mov     DX,Offset BadDLL
        Jmp     ErrorMsg

;----- Set Flags that mark a Win3 file
@@:
        Mov     AL,[SI+37h]
        And     AL,11b                  ;has it already been set?
        Jz      @F
        Mov     DX,Offset BeenMarked
        Jmp     ErrorMsg
@@:
        Or      AL,011b                 ;set the Protected mode and
                                        ;   proportional font bits
        Mov     Byte Ptr [SI+37h],AL    ;put it back
        Mov     Word Ptr [SI+3Eh],300h  ;set for V3

;-----  Put back changed data
        Mov     DX,Ne_Start             ;point SI at start of new header
        Call    Seek                    ;and seek to that spot again
                                        ;DS:DX points to buffer
        Mov     CX,40h                  ;just write what we changed
                                        ;BX contains Handle
        Mov     DX,Offset Buffer        ;and point DX at buffer
        Mov     AH,CL                   ;CL contains 40h, same as service
        Int     21h
        Jc      FileErrorExit
        Mov     DX,Offset Success
        Call    PrintMsg
        Jmp     CloseFile

;------ Error reporter
FileErrorExit:
        Mov     ErrorNumber,AX
        Cmp     AX,2h                   ;file not found
        Jnz     @F
        Mov     DX,Offset FileNotFound
        Jmp     ErrorMsg
@@:
        Cmp     AX,3h                   ;Path not found
        Jnz     @F
        Mov     DX,Offset PathNotFound
        Jmp     ErrorMsg
@@:
        Cmp     AX,5h                   ;AccessDenied
        Jnz     @F
        Mov     DX,Offset AccessDenied
        Jmp     ErrorMsg
@@:
        Cmp     AX,99                   ;file too short, not good
        Mov     DX,Offset BadDLL
        Jmp     ErrorMsg

@@:
        Mov     DX,Offset FileError

ErrorMsg:
        Call    PrintMsg
        Cmp     FileHandle,0            ;do we have a handle?
        Jz      Exit

CloseFile:
        Mov     BX,FileHandle
        Mov     AH,3Eh                  ;close file service
        Int     21h                     ;close it

Exit:
        Mov     AL,Byte Ptr ErrorNumber         ;if there was an error, get it
        Mov     AH,4Ch          ;leave peacefully
        Int     21h

PrintMsg:                       ;DS:DX enters pointing toward string to print
        Mov     AH,9h           ;service 9, print a string
        Int     21h             ;print it
        Mov     DX,Offset CRLF
        Int     21h
        RetN

ReadFile:
        Mov     DX,SI           ;point DX at Buffer
        Mov     AH,3Fh          ;read service
        Mov     CX,40h          ;read in 40h bytes
        Int     21h             ;read it
        Jc      @F
        Cmp     AX,CX           ;did we get enough
        Jz      @F
        Mov     AX,99           ;our own code

@@:
        RetN

Seek:
        Xor     CX,CX           ;clear MSW of pointer
        Mov     AX,4200h        ;service 42h, offset from start of file
                                ;BX contains handle
        Int     21h
        RetN


End     Start                   ;show dos where to begin
