// datetime.c RHS 1/15/92

#include<stdio.h>

#if !defined(TRUE)
#define TRUE 1
#endif

#if !defined(FALSE)
#define FALSE 0
#endif

#if defined(SMALL)

void GetDateTime(char *buf)
    {
    char *days[7] = 
        { 
        "Sunday", "Monday", "Tuesday", "Wednesday", 
        "Thursday","Friday", "Saturday" 
        };
    char *months[12] = {
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
        };   

    unsigned char month,day,dow;
    unsigned char hour, minutes, seconds, hundredths;
    unsigned char pm = FALSE;
    unsigned year;

#if defined(__BORLANDC__)
    _AH = 0x2A;
    asm int 0x21;
    dow = _AL;
    year = _CX;
    month = _DH;
    day = _DL;
    _AH = 0x2C;
    asm int 0x21;
    hour = _CH;
    minutes = _CL;
    seconds = _DH;
    hundredths = _DL;
#else
    _asm mov ah,0x2a
    _asm int 21h
    _asm mov dow,al
    _asm mov year,cx
    _asm mov month,dh
    _asm mov day,dl
    _asm mov ah,0x2c
    _asm int 21h
    _asm mov hour,ch
    _asm mov minutes,cl
    _asm mov seconds,dh
    _asm mov hundredths,dl
#endif

    if(hour > 12)
        {
        pm = TRUE;
        hour -= 12;
        }
    if(!hour)
        hour = 12;

    sprintf(buf,"%s, %s %d, %04d, %d:%02d:%02d.%02d%s",
        days[dow],months[month-1],day,year,hour,minutes,seconds,hundredths,
        (pm ? "pm" : "am"));
    }

#elif defined(BIG)

#include<time.h>
void GetDateTime(char *buf)
    {
    time_t t;

    t = time(NULL);
    sprintf(buf,"%s",ctime(&t));
    }
#else
#error You must define SMALL or BIG in the program or on the command-line!
#endif

void main(void)
    {
    char buf[50];

    GetDateTime(buf);
    printf("%s\n",buf);
    }


