/* 
PRINTF.C -- simple output for small Windows programs, 
using MessageBox() or WinExec()/SendMessage()

Copyright (c) 1991 Ziff Communications Co.
    PC Magazine * Andrew Schulman
*/

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <windows.h>
#include "printf.h"

#define BUF_SIZE        1024

static char *str, *app;
static unsigned cap, len;
static int lines;

BOOL open_display(char *appname)
{
    app = appname;
    cap = 128;
    if (! (str = malloc(cap)))
        return FALSE;
    *str = lines = len = 0;
    return TRUE;
}

/* Maximum number of lines that MessageBox will hold */
static int max_lines(void)
{
    TEXTMETRIC tm;
    HWND hWnd = GetActiveWindow();
    HDC hDC = GetWindowDC(hWnd);
    if (hDC == NULL)
        return 0;
    GetTextMetrics(hDC, &tm);
    ReleaseDC(hWnd, hDC);
    return (GetSystemMetrics(SM_CYFULLSCREEN) /
        (tm.tmHeight + tm.tmExternalLeading)) - 5;
}

BOOL show_display(void)
{
    if (lines <= max_lines())
        MessageBox(NULL, str, app, MB_OK);
    else
        notepad(str);
    free(str);
    return TRUE;
}

static BOOL append(char *s2)
{
    char *s3;
    if (((len += strlen(s2)) < cap) && strcat(str, s2))
        return TRUE;
    cap = len + 128;
    if (! (s3 = malloc(cap))) 
        return FALSE;
    strcpy(s3, str);
    strcat(s3, s2);
    free(str);
    str = s3;
    return TRUE;
}

int nlines(char *s2)
{
    int c, n = 0;
    while (c = *s2++)
        if (c == '\n') 
            n++;
    return n;
}

int printf(const char *fmt, ...)
{
    static char s2[BUF_SIZE];
    int len;
    va_list marker;
    va_start(marker, fmt);
    len = vsprintf(s2, fmt, marker);
    lines += nlines(s2);
    va_end(marker);
    append(s2);
    return len;
}

BOOL notepad(char far *s)
{
    HWND notepad;
    HWND edit_ctrl;
    if (WinExec("notepad.exe", SW_SHOWNORMAL) < 32)
        return FALSE;
    notepad = FindWindow(NULL, "Notepad - (untitled)");
    edit_ctrl = GetFocus();
    SendMessage(notepad, WM_SETTEXT, 0, (char far *) app);
    SendMessage(edit_ctrl, WM_SETTEXT, 0, (char far *) s);
    return TRUE;
}

#ifdef TESTING
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    int i;
    open_display("GetSystemMetrics");
    for (i=0; i<37; i++)
    {
        printf("%d\t%d\r\n", i, GetSystemMetrics(i));
        Yield();
    }
    show_display();
}
#endif
