program mdp2;

{Program to accompany article in issue #10 of the Pascal NewsLetter.       }
{Author: Mitch Davis, (3:634/384.6) +61-3-890-2062.                        }

{ From public domain ideas by Ron Lyth, (3:634/384).                       }
{Shows a maximum of 10000 lines from a file specified on the command line. }
{This program works by only allocating as much memory as it needs to store }
{the contents of each line.                                                }

{It is limited by two things (which you can see in the While below):       }
{ 1) It can only handle as much of the file as it has heap memory to hold, }
{ 2) The table of line pointers is limited to about 10000 entries, since   }
{    the table can't be larger than 64k (ie, a little larger than 6*10000) }

{$M 16384,80000,655360}

uses crt;

const MaxLines = 10000;

type LineType = record {this takes 6 bytes per line for the pointer}
                  size:word; {2 bytes here.  The size is needed for FreeMem}
                  data:^string; {pointers are 4 bytes}
                end;

var Line:array [1..MaxLines] of LineType; { This takes 60000 bytes }
    Buffer:string;
    LineCount,Loop:word;
    f:text;

begin
  writeln ('Reading...');
  assign (f,paramstr (1));
  reset (f);
  LineCount := 0;
  while not (eof (f) or (LineCount = MaxLines) or (MaxAvail < 1024)) do begin
    inc (LineCount);
    write (LineCount,#13);
    readln (f,Buffer);
    with Line [LineCount] do begin
      size := succ(length (Buffer)); {allow for the length byte}
      GetMem (data,size);
      data^ := Buffer;
    end;
  end;
  close (f);
  writeln;

  writeln ('Forward:');
  for loop := 1 to LineCount do writeln (loop:3,':',Line [loop].data^);
  writeln;

  writeln ('Backwards:');
  for loop := LineCount downto 1 do writeln (loop:3,':',Line [loop].data^);

  writeln ('Disposing of memory:');
  for loop := 1 to LineCount do with Line [loop] do FreeMem (data,size);
  writeln ('Done!');
end.
