/*
	remote.c -- Remote commands (not finished)

  Poor Man's Packet (PMP)
  Copyright (c) 1991 by Andrew C. Payne    All Rights Reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation without fee for NON-COMMERCIAL AMATEUR RADIO USE ONLY is hereby
  granted, provided that the above copyright notice appear in all copies.
  The author makes no representations about the suitability of this software
  for any purpose.  It is provided "as is" without express or implied warranty.

	Andrew C. Payne
	04/11/90
*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <alloc.h>
#include <mem.h>
#include <string.h>

#include <dos.h>
#include <dir.h>
#include <alloc.h>
#include "pmp.h"

#ifdef REMOTE

/* ----- Command dispatch tables ----- */

static int	doversion(char *s), dotime(char *s), dodir(char *s),
		dobye(char *s), dotype(char *s), dohelp(char *s),
		doinfo(char *s);

struct param_cmd rcmds[] = {
	{ "version",	doversion },
	{ "time",	dotime },
	{ "date",	dotime },
	{ "dir",	dodir },
	{ "bye",	dobye },
	{ "type",	dotype },
	{ "help",	dohelp },
	{ "info",	doinfo },
	{ NULL,		NULL } };

/* ----- Local subroutines ----- */

/* lprintf(format, ....)
	Does a 'printf' across the currently connected link.  Items are
	also echoed to the local screen.
*/
static void lprintf(char *format, ...)
{
	va_list	argptr;
	char	s[256];

	va_start(argptr, format);
	vsprintf(s, format, argptr);
	va_end(argptr);

/* send it across the link and show it on the screen */
	LinkSend(s, strlen(s));
/*	uprintf(BrightAttr, s); */
}

/* ----- Remote command processing ----- */

/* command(s)
	Given the command string (less any prefix), processes
	the command.
*/
void command(char *s)
{
	trim(s);
	if(dispatch(s, rcmds) == FAIL)
		lprintf(">> Invalid command.\n");
}

/* doversion(char *s)
	Shows the current version number.
*/
static int doversion(char *s)
{
	lprintf(">> PMP Version %s (compiled %s)  by N8KEI\n",VERSION,__DATE__);
}

/* dotime(char *s)
	Shows the current date and time.
*/
static int dotime(char *s)
{
	time_t	t;

	time(&t);
	lprintf(">> %s",ctime(&t));
}

/* dodir(char *s)
	Shows the directory of the current disk.
*/
static int dodir(char *s)
{
	struct ffblk	ffblk;
	int	done;
	char	*cwd;
	struct dfree	dtable;
	long	f;
	int	count;

/* show current working directory */
	cwd = getcwd(NULL, 80);
	lprintf(">> Directory of %s\n",cwd);
	free(cwd);

	s = sob(s);
	if(!*s)
		s = "*.*";

/* show files in directory */
	done = findfirst(s, &ffblk, 0);
	count = 0;
	while(!done) {
		lprintf("  %-14s  ",ffblk.ff_name);
		if((++count % 4) == 0)
			lprintf("\n");
		done = findnext(&ffblk);
	}
	if(count % 4)
		lprintf("\n");

/* show free space on drive */
	getdfree(0, &dtable);
	f = (long)dtable.df_avail * (long)dtable.df_bsec * (long)dtable.df_sclus;
	lprintf(">> %ld bytes free on disk.\n",f);
}

/* dobye(s)
	Disconnect.
*/
static int dobye(char *s)
{
	AX25_Close();
}

/* dotype(char *s)
	Types a file.
*/
static int dotype(char *s)
{
	FILE	*outfile;
	char	buf[1024];
	int	len;

/* open the file */
	if((outfile = fopen(s,"r")) == NULL) {
		lprintf(">> Can't access file.\n");
		return FALSE;
	}

/* push the file across the link */
	while(len = fread(buf, 1, 1024, outfile))
		LinkSend(buf, len);

	fclose(outfile);
	lprintf("\n>> EOF\n");
}

/* dohelp(char *s)
	Shows help file.
*/
static int dohelp(char *s)
{
	FILE	*outfile;
	char	buf[1024];
	int	len;

/* open the file */
	if((outfile = fopen("pmp.hlp","r")) == NULL) {
		lprintf(">> Help not available.\n");
		return FALSE;
	}

/* push the file across the link */
	while(len = fread(buf, 1, 1024, outfile))
		LinkSend(buf, len);

	fclose(outfile);
}

/* doinfo(char *s)
	Shows info file.
*/
static int doinfo(char *s)
{
	FILE	*outfile;
	char	buf[1024];
	int	len;

/* open the file */
	if((outfile = fopen("pmp.inf","r")) == NULL) {
		lprintf(">> Information not available.\n");
		return FALSE;
	}

/* push the file across the link */
	while(len = fread(buf, 1, 1024, outfile))
		LinkSend(buf, len);

	fclose(outfile);
}

#endif	/* REMOTE */
