
/*
 *  ECHO.C - Example of a server for the W0RLI MailBox V10.xx
 *
 *  Copyright (C) 1989
 *  H. N. Oredson
 *  21390 Shannon Lane
 *  West Linn, or 97068
 *
 *  This code may be freely used and copied for non-commercial uses.
 *
 *  SP ECHO @ BBS will generate a return message containing
 *  the text and headers from the original message.
 *
 *  The SERVER.MB text required to activate this server is:
 *
 *  s echo echo.exe echo.out H8 echo.in H8
 *
 *  This first exports any messages addressed to ECHO to the file ECHO.OUT.
 *  Next it runs the ECHO server.
 *  Finally it imports the messages created by the ECHO server.
 *  See SERVER.DOC for further details.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>

/*
 *  Some buffer space.
 */

#define ln_buf 512

char buf[ln_buf];

/*
 *  End-of-message mark.
 */

char *mark    = "/EX\n";

/*
 *  File the MailBox will create, and this server will read.
 */

char *infile  = "echo.out";

/*
 *  File this server will create, and the MailBox will read.
 */

char *outfile = "echo.in";



main(argc, argv)
int argc;
char *argv[];
{
  FILE *in, *out;
  char *st, *tail;

/*
 *  Open the input file.
 *  If not possible, exit with return code 1 to signal
 *  the MailBox that the server failed.
 */

  if ((in = fopen(infile, "r")) == NULL) exit(1);

/*
 *  Open the output file.
 *  If not possible, exit with return code 1 to signal
 *  the MailBox that the server failed.
 */

  if ((out = fopen(outfile, "w")) == NULL) exit(1);

  st = fgets(buf, ln_buf, in);
  while (st != NULL)
  {

/*
 *  Read the rfc-822 header placed into the message by the MailBox.
 *  The end of header is marked by a blank line.
 *  Do not place this header into the output file.
 *  Use the "To:" address as the new "From:" address,
 *  and the "From:" address as the new "To:" address.
 *  Preserve the "Subject:"
 *  This process is the entire function of this server.
 */

    while(*buf != '\n')
    {

/*
 *  Find end of keyword.
 *  Terminate string at end of keyword.
 */

      tail = strchr(buf, ' ');
      *tail++ = '\0';

/*
 *  Make the new rfc-822 header.
 */

      if      (!strcmp(buf, "To:"))      fprintf(out, "From: %s", tail);
      else if (!strcmp(buf, "From:"))    fprintf(out, "To: %s", tail);
      else if (!strcmp(buf, "Subject:")) fprintf(out, "Subject: %s", tail);
      st = fgets(buf, ln_buf, in);
    }

/*
 *  Now that the rfc-822 header has been read, and a new one created,
 *  copy the text of the message from the input to the output.
 */

    while ((st != NULL) && stricmp(buf, mark))
    {
      fputs(buf, out);
      st = fgets(buf, ln_buf, in);
    }

/*
 *  Mark the end of this message.
 *  Go on to the next message.
 */

    fputs(mark, out);
    if (st != NULL) st = fgets(buf, ln_buf, in);
  }

/*
 *  All the incoming messages have been processed,
 *  and an outgoing message created for each one.
 */

  fclose(in);
  fclose(out);

/*
 *  Delete the input file.
 *  The MailBox appends messages to this file, this server must delete it.
 */

  unlink(infile);

/*
 *  Exit with return code 0 to signal the MailBox that
 *  the server completed it's processing normally.
 *  The MailBox will then read our output file,
 *  and create messages from it.
 */

  exit(0);
}
