/*--------------------------------------------------------------*/
/*  Copyright 1991      					*/
/*  Keith Ford; All Rights Reserved				*/
/*--------------------------------------------------------------*/

#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <math.h>
#include <malloc.h>
#include <conio.h>                           /* Std console I/O def's   */
#include <string.h>                          /* Std string func defs    */
#include <stdlib.h>                          /* Miscellaneous def's     */
#include "otoolkit.h"                        /* ToolKit General Headers */
#include "otoollib.h"                        /* ToolKit Func Prototypes */


#define VERSION 003

#define MAX_NUM_BULLETS 20
#define KEY_SIZE 32
#define DATUM_SIZE 80
#define LINE_SIZE 80
#define COLOR_SIZE 13
#define MAX(a,b) ((a)>(b)?(a):(b))
#define UP(s_) {int i;for(i=0;*(s_+i);i++)*(s_+i)=(char)toupper(*(s_+i));}

#define MAX_LABELS 4
enum address_type {loop_address, privileged_address, help_address, credit_address};
long label_address[MAX_LABELS]={loop_address, privileged_address, help_address, credit_address};

/* UGH! - Globals */
struct _lu_file lu;
struct _usr u;
FILE *lu_file, *log_file;
struct tm *td;
short num_bulletins_available;
char ba[MAX_NUM_BULLETS];

char temp_datum_[DATUM_SIZE];
char string_[DATUM_SIZE];
char string2_[DATUM_SIZE];
char *opt_ptr_;
char *path_ptr_;
char ctl_file_[DATUM_SIZE];
char prm_file_[DATUM_SIZE];
char prm_bkup_[DATUM_SIZE];
char n_help_text;
char any_new=0;
char help_text_[20][80];
short num_columns;
long foffset2;
long _now;
#define n_credit_text 20
static char *credit_text_[n_credit_text]={
  "OBUL created by Keith Ford, sysop of Micro Magic 1:373/12",
  "with special thanks going to the following.",
  "",
  "Opus Computer Based Information System",
  "Originally conceived, produced, and copyrighted (c) 1986-1990",
  "by Wynn Wagner III, further developed and copyrighted (c) 1986-1990",
  "by Wynn Wagner III, Doug Boone, George Stanislav,",
  "Vince Perriello, Rick Huebner, and Tom Kashuba.",
  "",
  "Utility Programmer's Tool Kit",
  "Version 1.10 - Mar 11, 1990",
  "Prepared by: Tom Kashuba",
  "",
  "OECC - The High Touch Language Compiler",
  "Version 1.00, by George A. Stanislav",
  "",
  "John Emmert of GATEWAY for helping me with Opus.",
  "Scott Williams, for helping with the name: OBUL.",
  "Rush & Tesla, for providing the development music.",
  "Carol & Emily, love you both!"};



struct obul_002_header
{
  short version;
  char lastpath_[DATUM_SIZE];
  char bbs, oec;
  char path_[DATUM_SIZE];
  char columns;
  char order;
  char title_text_[DATUM_SIZE];
  char title_color_[COLOR_SIZE];
  char prompt_color_[COLOR_SIZE];
  char number_of_bulletins;
  char display_privileged;
  char format_[10];
  char lead_character;
  char lead_color_[COLOR_SIZE];
  char choice_color_[COLOR_SIZE];
  char tail_character;
  char tail_color_[COLOR_SIZE];
  char entry_color_[COLOR_SIZE];
  char highlight_character;
  char highlight_color_[COLOR_SIZE];
  char highlight_blink;
} header;

struct obul_002_bullet
{
  char choice_character;
  char entry_text_[DATUM_SIZE];
  char access;			/* Read_Obul_Prm will change to 1 or 0 */
  char file_[DATUM_SIZE];
  char highlight_mode;
} *bullet;

#define BULLET_STRUCT (struct obul_002_bullet *)
#define BULLET_SIZE   (sizeof(struct obul_002_bullet))
#define NEW_BULLET    (BULLET_STRUCT calloc( 1,BULLET_SIZE))

char Translate_Color();



main( argc, argv)
int argc;
char *argv[];

{
  FILE *f;
  short status,i,len;

  log_file=fopen("obul.log","w");
  tzset();
  time(&_now);
  fprintf(log_file,"time = %ld = %s",_now,ctime(&_now));
  fprintf(log_file,"argc=%d\n",argc);
  for(i=0;i<argc;i++)fprintf(log_file,"arg%02d=%s\n",argv[i]);
  opt_ptr_ = argv[1];
  path_ptr_ = argv[2];
  if( argc == 3)
  {
    len = strlen( path_ptr_);
    if( path_ptr_[len-1] != '\\') strcat( path_ptr_,"\\");
    strcpy( ctl_file_, path_ptr_);
    strcpy( prm_file_, path_ptr_);
    strcpy( prm_bkup_, path_ptr_);
  }
  strcat( ctl_file_,"obul.ctl");
  strcat( prm_file_,"obul.prm");
  strcat( prm_bkup_,"obul_prm.bak");
    
  if( (argc >= 2) &&( (opt_ptr_[0]=='-')||(opt_ptr_[0]=='/')) && ((opt_ptr_[1]=='c')||(opt_ptr_[1]=='C')))
  {
    /* compile control file to parameter file */
    status = Read_Obul_Ctl();
    if( status)
    {
      printf("status: %03d in Read_Obul_Ctl()",status);
      switch( status)
      {
        case 1: puts("unable to open obul.ctl"); break;
        case 2: puts("parameter ERROR"); break;
      }
    }
    else
    {
      f = fopen( prm_file_, "rb" );
      if( f )
      {
        fclose( f );
        strcpy( string_, "copy ");
        strcat( string_, prm_file_);
        strcat( string_, " ");
        strcat( string_, prm_bkup_);
        system( string_);
      }
      status = Write_Obul_Prm();
      if( status)
      {
        printf("status: %03d in Write_Obul_Prm()",status);
        puts("unable to open obul.ctl");
      }
    }
  }
  else if( (argc >= 2) && ((opt_ptr_[0]=='-')||(opt_ptr_[0]=='/')) && ((opt_ptr_[1]=='d')||(opt_ptr_[1]=='D')))
  {
    /* decompile parameter file into control file */
    status = Read_Obul_Prm();
    if( status)
    {
      printf("status: %03d in Read_Obul_Prm()",status);
      fclose(log_file);
      exit( 1);
    }
    status = Write_Obul_Ctl();
    if( status)
    {
      printf("status: %03d in Write_Obul_Ctl()",status);
      fclose(log_file);
      exit( 1);
    }
  }
  else if ((argc >= 2) && ((opt_ptr_[0]=='-')||(opt_ptr_[0]=='/')) && ((opt_ptr_[1]=='m')||(opt_ptr_[1]=='M')))
  {
    /* display interface menu */
    printf("\n\nThe menu option has yet to be implemented.\n\n");
  }
  else if ((argc >= 2) && ((opt_ptr_[0]=='-')||(opt_ptr_[0]=='/')) && ((opt_ptr_[1]=='g')||(opt_ptr_[1]=='G')))
  {
    /*generate bulletin file */

    /* user information */
    num_columns = 79;

    /* read compiled paramters */
    status = Read_Obul_Prm();
    if (status)
    {
      printf("status: %03d in Read_Obul_Prm()",status);
      fclose(log_file);
      exit (1);
    }

    /* read LASTUS## file to get time of last login and other info */
    if(( lu_file = fopen( header.lastpath_, "rb" )) == NULL )
    {
      fprintf( stderr, "Can't open [%s]\n", header.lastpath_ );
      fclose(log_file);
      exit( 99 );
    }
    fread( (char*)&lu, sizeof(lu), 1, lu_file );
    u = lu.user;
    fclose (lu_file);

    /* log user info */
    fprintf(log_file, "User: %s", lu.user.name );
    if ( *lu.user.alias ) fprintf(log_file, " [%-.36s]", lu.user.alias );
    fprintf(log_file,"\n");
    fprintf(log_file, "City.....: %-.36s\n", *lu.user.city ? lu.user.city : "(none)" );
    fprintf(log_file, "Privilege: %-6.6s  Keys: %-32.32s\n",
            pv2pn(lu.user.ClassPriv), ky2st(0,lu.user.ClassLock) );
    fprintf(log_file, "Laston in LASTUS00.DAT says: %s\n",lu.laston);
    fprintf(log_file, "Calls...#: %-6d  ", lu.user.times );
    if ( lu.user.ludate > 0L )
    {
       td = localtime( &lu.user.ludate );
       fprintf(log_file, "Last: %02d-%02d-%02d %02d:%02d  ",
               td->tm_year, td->tm_mon+1, td->tm_mday,
               td->tm_hour, td->tm_min                  );
    }
    else
       fprintf(log_file, "Last: .. .. .. .. ..  " );

    if ( lu.user.fudate > 0L )
    {
       td = localtime( &lu.user.fudate );
       fprintf(log_file, "1st: %02d-%02d-%02d %02d:%02d\n",
               td->tm_year, td->tm_mon+1, td->tm_mday,
               td->tm_hour, td->tm_min                  );
    }
    else
       fprintf(log_file, "1st: .. .. .. .. ..\n" );
    fprintf(log_file, "Password.: %-.16s\n", *lu.user.pwd ? lu.user.pwd : "(none)" );
    fprintf(log_file, "MenuLevel: %s\n", mv2mn(lu.user.help) );
    fprintf(log_file, "DsplayRxC: %d x %d\n\n", lu.user.len+2, lu.user.width+2 );

            fprintf(log_file,"\n");
            for (i=0; i < 60; i++)
               fprintf(log_file, "-" );
            fprintf(log_file,"\n");

            fprintf(log_file, "User: %s", u.name );
            if ( *u.alias )
               fprintf(log_file, " [%-.36s]", u.alias );
            fprintf(log_file,"\n");

            fprintf(log_file, "City.....: %-.36s\n", *u.city ? u.city : "(none)" );

            fprintf(log_file, "Privilege: %-6.6s  Keys: %-32.32s\n",
                    pv2pn(u.ClassPriv), ky2st(0,u.ClassLock) );

            fprintf(log_file, "Calls...#: %-6d  ", u.times );


            if ( u.ludate > 0L )
            {
               td = localtime( &u.ludate );
               fprintf(log_file, "Last: %02d-%02d-%02d %02d:%02d  ",
                       td->tm_year, td->tm_mon+1, td->tm_mday,
                       td->tm_hour, td->tm_min                  );
            }
            else
               fprintf(log_file, "Last: .. .. .. .. ..  " );

            if ( u.fudate > 0L )
            {
               td = localtime( &u.fudate );
               fprintf(log_file, "1st: %02d-%02d-%02d %02d:%02d\n",
                       td->tm_year, td->tm_mon+1, td->tm_mday,
                       td->tm_hour, td->tm_min                  );
            }
            else
               fprintf(log_file, "1st: .. .. .. .. ..\n" );

            if ( u.exflag & EXPBYDATE )
            {
               if ( u.xdate != 0L )
               {
                  td = gmtime( &u.xdate );
                  fprintf(log_file, "ExpryDate: %02d-%02d-%02d %02d:%02d:%02d\n",
                          td->tm_year, td->tm_mon+1, td->tm_mday,
                          td->tm_hour, td->tm_min,   td->tm_sec   );
               }
               else
                  fprintf(log_file, "ExpryDate: (none)\n" );
            }

            if ( u.exflag & EXPBYMINS )
            {
               if ( u.dbmin )
               {
                  fprintf(log_file, "Expcrmin: %-5ld  dbmin: %-5ld  Bal: %-5ld\n",
                           u.crmin, u.dbmin, u.crmin-u.dbmin );
               }
               else
                  fprintf(log_file, "ExpryMins: (none)\n" );
            }

            if ( u.exflag & (EXPBYDATE|EXPBYMINS) )
            {
               if ( !(u.exflag & (EXPAXE|EXPDEMOTE)) )
                  fprintf(log_file, "ExpMethod: (none)\n" );
               else
                  fprintf(log_file, "ExpMethod: %s%s\n",
                           (u.exflag & EXPDEMOTE) ? "DEMOTE " : "",
                           (u.exflag & EXPAXE   ) ? "AXE"     : ""  );
            }

            fprintf(log_file, "Password.: %-.16s\n", *u.pwd ? u.pwd : "(none)" );
            fprintf(log_file, "LangSetNo: %d\n", u.language );

            fprintf(log_file, "MdmTel...: %-.16s\n",
                     *u.usrtel ? u.usrtel : "(none)" );

            fprintf(log_file, "MenuLevel: %s\n", mv2mn(u.help) );

            fprintf(log_file, "UpLds....: %ldk  DnLds: %ldk  Up/DnLd%%: %ld\n",
                                u.upld, u.dnld,
                                (u.dnld > 0L) ?
                                (100L * u.upld)/u.dnld : 0L );

            fprintf(log_file, "DsplayRxC: %d x %d\n", u.len+2, u.width+2 );

            fprintf(log_file, "FidoNet-$: $%d.%02dC - $%d.%02dD = $%d.%02d\n",
                                u.credit / 100, u.credit % 100,
                                u.debit  / 100, u.debit  % 100,
                                (u.credit-u.debit) / 100,
                                (u.credit-u.debit) % 100  );

            fprintf(log_file, "SpcAnn#'s:" );
            for (i=0; i < 5; i++)
               fprintf(log_file, " %03d", u.saccnt[i] );
            fprintf(log_file, "   SpclWelc: %-.8s\n",
                    *u.spcoec ? u.spcoec : "(none)" );






    /* determine file accesses */
    fprintf(log_file,"user priv = %d\n", lu.user.ClassPriv);
    num_bulletins_available = 0;
    for (i=0; i<header.number_of_bulletins; i++)
    {
      fprintf(log_file,"bullet[%d] priv = %d\n", i, pl2pv((char)toupper(bullet[i].access)));
      if ((lu.user.ClassPriv >= pl2pv((char)toupper(bullet[i].access))) ||
          (bullet[i].file_[0]=='*'))
      {
        bullet[i].access = 1;
        ba[num_bulletins_available++]=i;
      }
      else
      {
        bullet[i].access = 0;
        if (header.display_privileged) ba[num_bulletins_available++]=i;
      }
    }

    /* generate the bulletin menu files */
    status = Write_Obul_Menu();
    if (status)
    {
      printf("status: %03d in Write_Obul_Menu",status);
      fclose(log_file);
      exit (1);
    }
  }
  else if ((argc >= 2) && ((opt_ptr_[0]=='-')||(opt_ptr_[0]=='/')) && ((opt_ptr_[1]=='?')||(opt_ptr_[1]=='h')||(opt_ptr_[1]=='H')))
  {
    for( i=0; i<n_credit_text; i++ )
    {
      printf("%s\n",credit_text_[i]);
    }
  }
  else 
  {
    /* display usage information */
    printf ("");  /*control-L*/
    puts (" ");
    puts ("OBUL - Opus Bulletin Utilization Language");
    printf("       Version %03d released 20-APR-91\n", VERSION);
    puts ("       Copyright 1991 Keith Ford.  All Rights Reserved.");
    puts (" ");
    puts ("Usage: OBUL [option] [drive:\\path\\]");
    puts ("Options are:");
    puts ("  -?,-h = display more information");
    puts ("  -c = compile OBUL.CTL into OBUL.PRM");
    puts ("  -g = generate .BBS/.OEC from OBUL.PRM and LASTUS##.DAT");
    puts ("  -d = decompile OBUL.PRM to screen (stdout)");
    puts ("  -m = display OBUL menu interface");
    puts ("drive:\\path\\ = drive and path where files are located.");
    puts ("               Default is current directory.  See manual.");
    puts (" ");
  }
  fclose(log_file);
}





/********************************************************************/
int Get_Next_Line (_fp, key_to_match, key_word, datum_string_)
FILE *_fp;
char *key_word, *datum_string_, *key_to_match;
{
  char line[LINE_SIZE];
  short i,j;
  while (!feof(_fp))
  {
    fgets (line, LINE_SIZE, _fp);
    if (isalpha (line[0]))
    {
      /* null out the strings */
      for (i=0; i<KEY_SIZE; i++) key_word[i]=0;
      for (i=0; i<DATUM_SIZE; i++) datum_string_[i]=0;
      for (i=0; i<DATUM_SIZE; i++) temp_datum_[i]=0;

      /* parse input line for key word and datum string */
      for (i=0; isgraph(line[i]); i++) key_word[i]=tolower(line[i]);
      if (strcmp (key_to_match, key_word)) return (4);
      for (; isspace(line[i]); i++);
      for (j=0; isprint(line[i]); j++,i++)
      {
        datum_string_[j] = tolower(line[i]);
        temp_datum_[j] = line[i];
      }

      /* error of 1 if no key word */
      if (!strlen(key_word)) return (1);
      /* error of 2 if no datum string */
      if (!strlen(datum_string_)) return (2);
      /* return successfully */
      return (0);

    } /* if isalpha */
  } /* while !feof */

  /* error of 3 if EOF reached */
  return (3);
} /* Get_Next_Line() */




/********************************************************************/
int Read_Obul_Ctl ()
{
  short status;
  char key[ KEY_SIZE ], datum_[ DATUM_SIZE ];
  char *ptr2char;
  char line[LINE_SIZE];
  short i,j,bullet_num;
  int len;
  long foffset;
  FILE *_f,*_tf;

# define ROC_IO(K) \
  status=Get_Next_Line(_f,K,key,datum_);if(status){printf("ERR%03d: ",status);\
  switch(status){case 1:puts("no key word found");break;\
  case 2:puts("no datum found");break;case 3:puts("EOF reached");break;\
  case 4:printf("key mismatch: |%s|%s|\n",K,key);break;}return(2);}else


  if ((_f = fopen( ctl_file_, "r" ) ) == 0)
  {
    printf( "ERROR opening %s\n", ctl_file_ );
    return( 1 );
  }

  ROC_IO("version")
  {
    header.version = (short) atoi( datum_ );
    if ((header.version != 1) && (header.version != 2))
      printf( "warning:  bad version number\n");
  }

  ROC_IO("lastpath")
  {
    strcpy (header.lastpath_, datum_);
    len = strlen (header.lastpath_);
  }

  ROC_IO("path")
  {
    strcpy (header.path_, datum_);
    len = strlen (header.path_);
    if (header.path_[len-4] == '.') header.path_[len-4] = 0;
  }

  ROC_IO("bbs")
  {
    header.bbs = (char) (datum_[0]=='y');
  }
  ROC_IO("oec")
  {
    header.oec = (char) (datum_[0]=='y');
  }
  if (!header.bbs && !header.oec)
  {
    status=2;
    printf ("ERROR:  no bbs or oec specified\n");
  }

  ROC_IO("columns")
  {
    if (datum_[0]=='a')
      header.columns = 0;
    else
      header.columns = (char) atoi( datum_ );
    if ((header.columns<0) || (header.columns>4))
    {
      status=2;
      printf ("ERROR:  invalid number of columns:  %s\n", datum_);
    }
  }

  ROC_IO("order")
  {
    header.order = (char) (datum_[0]=='a');
  }

  ROC_IO("title_text")
  {
    strcpy (header.title_text_, temp_datum_);
  }

  ROC_IO("title_color")
  {
    strcpy( header.title_color_, datum_ );
  }

  ROC_IO("prompt_color")
  {
    strcpy( header.prompt_color_, datum_ );
  }

  ROC_IO("display_privileged")
  {
    header.display_privileged = (char) (datum_[0]=='y');
  }

  ROC_IO("format")
  {
    strcpy( header.format_, datum_ );
  }
  
  ROC_IO("lead_character")
  {
    if (datum_[1] == 'p') datum_[0]=' ';
    else if (datum_[1] == 'u') datum_[0]=0;
    header.lead_character = datum_[0];
  }
  
  ROC_IO("lead_color")
  {
    strcpy( header.lead_color_, datum_ );
  }
  
  ROC_IO("choice_color")
  {
    strcpy( header.choice_color_, datum_ );
  }
  
  ROC_IO("tail_character")
  {
    if (datum_[1] == 'p') datum_[0]=' ';
    else if (datum_[1] == 'u') datum_[0]=0;
    header.tail_character = datum_[0];
  }
  
  ROC_IO("tail_color")
  {
    strcpy( header.tail_color_, datum_ );
  }
  
  ROC_IO("entry_color")
  {
    strcpy( header.entry_color_, datum_ );
  }
  
  ROC_IO("highlight_character")
  {
    header.highlight_character = datum_[0];
  }
  
  ROC_IO("highlight_color")
  {
    strcpy( header.highlight_color_, datum_ );
  }
  
  ROC_IO("highlight_blink")
  {
    header.highlight_blink = (char) (datum_[0]=='y');
  }

  /* mark where bullets start */
  foffset = ftell( _f );

  /* allow 2 bullets for help and credits */
  header.number_of_bulletins = 2;
  while( !feof( _f ))
  {
    fgets (line, LINE_SIZE, _f);
    UP(line);
    if( !strncmp( line, "# HELP TEXT", 11 ))
    {
      /* mark where help starts */
      foffset2 = ftell( _f );
      break;
    }
    if (!strncmp(line,"CHOICE_C",8))
      ++header.number_of_bulletins;
  }

  if ((header.number_of_bulletins<0) ||
      (header.number_of_bulletins>MAX_NUM_BULLETS))
  {
    status=2;
    printf ("ERROR:  invalid number of bulletins:  %s\n", datum_);
    return(status);
  }
  fseek( _f, foffset, 0 );
  bullet = BULLET_STRUCT
           calloc (1, header.number_of_bulletins*BULLET_SIZE);

  for (bullet_num=0; bullet_num<header.number_of_bulletins-2; bullet_num++)
  {
    printf("processing bullet #%d\n",bullet_num);

    ROC_IO("choice_character")
    {
      bullet[bullet_num].choice_character = temp_datum_[0];
    }

    ROC_IO("entry_text")
    {
      strcpy( bullet[bullet_num].entry_text_, temp_datum_ );
    }
    
    ROC_IO("access")
    {
      bullet[bullet_num].access = datum_[0];
      /* Hidden Sysop Asstsysop Clerk Extra Favored
       Privil Worthy Normal Limited Disgrace Twit*/
    }
    
    ROC_IO("file")
    {
      strcpy( bullet[bullet_num].file_, temp_datum_ );
      if (bullet[bullet_num].file_[0] == '*')
      {
        if (strcmp(bullet[bullet_num].file_,"*quit") &&
            strcmp(bullet[bullet_num].file_,"*hangup"))
          printf("  *** error:  unknown file \"%s\"\n",bullet[bullet_num].file_);
      }
      else
      {
        _tf = fopen(temp_datum_,"r");
        if (!_tf) printf("  *** warning:  could not open %s\n",temp_datum_);
        else fclose(_tf);
      }
    }
    
    ROC_IO("highlight_mode")
    {
      switch (datum_[1])
      {
        case 'e': bullet[bullet_num].highlight_mode = 0; break;
        case 'l': bullet[bullet_num].highlight_mode = 1; break;
        case 'u': bullet[bullet_num].highlight_mode = 2; break;
        default:  printf("ERROR:  invalid highlight mode:  %s\n",temp_datum_); break;
      }
    }
  }

  /* read in Help Text */
  fseek( _f, foffset2, 0 );
  for( i=0; (i<20)&&(!feof(_f)); i++ )
    fgets( help_text_[i], 80, _f );
  n_help_text = i;

  /* create bullet entries for Credits & Help */
  bullet[bullet_num].choice_character = '=';
  strcpy( bullet[bullet_num].entry_text_, "OBUL credits" );
  bullet[bullet_num].access = 'T';
  strcpy( bullet[bullet_num].file_, "*credits" );
  bullet[bullet_num].highlight_mode = 0;
  ++bullet_num;
  bullet[bullet_num].choice_character = '?';
  strcpy( bullet[bullet_num].entry_text_, "Help" );
  bullet[bullet_num].access = 'T';
  strcpy( bullet[bullet_num].file_, "*help" );
  bullet[bullet_num].highlight_mode = 0;

  fclose (_f);
  return (0);

} /* Read_Obul_Ctl() */




/********************************************************************/
char Translate_Color (color_name_)
char *color_name_;
{
  char color_number,letter;
  color_number = 30;
  if ((color_name_[0] == 'b') && (color_name_[1] == 'r'))
  {
    color_number |= 0x80;
    letter = 6;
  }
  else letter = 0;
  switch (color_name_[letter])
  {
    case 'r': color_number += 1; break;
    case 'g': color_number += 2; break;
    case 'y': color_number += 3; break;
    case 'm': color_number += 5; break;
    case 'c': color_number += 6; break;
    case 'w': color_number += 7; break;
    case 'b': if (color_name_[letter+2] = 'u') color_number += 4; break;
  }
  return (color_number);
}




/********************************************************************/
int Write_Obul_Prm ()
{
  short status;
  short i;
  int len;
  char line[133];
  FILE *_f;

  if ((_f = fopen( prm_file_, "wb" ) ) == 0)
  {
    return (1);
  }
  fwrite (&header, sizeof(header), 1, _f);
  fwrite (bullet, header.number_of_bulletins*sizeof(struct obul_002_bullet), 1, _f);
  fwrite( &n_help_text, sizeof(n_help_text), 1, _f);
  for( i=0; i<n_help_text; i++ )
    fwrite( &(help_text_[i][0]), 80, 1, _f );

  fclose (_f);
  return (0);
}




/********************************************************************/
int Read_Obul_Prm ()
{
  short status;
  short i;
  int len;
  FILE *_f;

  if ((_f = fopen( prm_file_, "rb" ) ) == 0)
  {
    return( 1 );
  }

  fread (&header, sizeof(header), 1, _f);
  bullet = (struct obul_002_bullet *) calloc (1, header.number_of_bulletins*sizeof (struct obul_002_bullet));
  fread (bullet, header.number_of_bulletins*sizeof(struct obul_002_bullet), 1, _f);
  fread( &n_help_text, sizeof(n_help_text), 1, _f);
  for( i=0; i<n_help_text; i++ )
    fread( &(help_text_[i][0]), 80, 1, _f );
  fclose (_f);
  return (0);
}




/********************************************************************/
int Write_Obul_Ctl ()
{
  short status;
  short i;
  int len;
  FILE *_f;

  /*kef - output to console instead of directly into CTL file
  if ((_f = fopen( ctl_file_, "w" ) ) == 0)
  {
    return (1);
  }*/
  _f = stdout;
    
  fprintf(_f,"# OBUL.CTL  Version %03d\n", VERSION );
  fprintf(_f,"#\n");
  fprintf(_f,"# Created with 'obul -d' on %s", ctime(&_now) );
  fprintf(_f,"#\n");
  fprintf(_f,"# Opus Bulletin Utilization Language\n");
  fprintf(_f,"# Copyright 1991  Keith Ford - All Rights Reserved\n");
  fprintf(_f,"# Micro Magic BBS, (205) 830-2362, 1:373/12, umagic.fidonet.org\n");
  fprintf(_f,"# Supports IBM/Apple2, running 3/12/24-8N1\n");
  fprintf(_f,"# SnailMail: 203 Creek Trail, Madison, AL, 35758, USA\n");
  fprintf(_f,"#\n");
  fprintf(_f,"# Data is case sensitive, keywords should be lower case.\n");
  fprintf(_f,"# Lines that begin with the '#' character are ignored, except\n");
  fprintf(_f,"# for HELP TEXT which is a key for file I/O.  Tabs and spaces\n");
  fprintf(_f,"# are considered white space and will be used as delimiter\n");
  fprintf(_f,"\n\n\n");

  fprintf(_f,"# OBUL.CTL VERSION NUMBER\n");
  fprintf(_f,"version %03d\n\n",header.version);

  fprintf(_f,"# FULL PATH FOR LASTUS##.DAT FILE\n");
  fprintf(_f,"lastpath\t\t%s\n\n",header.lastpath_);

  fprintf(_f,"# PATH FOR OUPUT OF THE BULLETIN MENU FILE (NO FILE SUFFIX)\n");
  fprintf(_f,"path\t\t\t%s\n\n",header.path_);

  fprintf(_f,"# GENERATE .BBS OR .OEC FILES\n");
  fprintf(_f,"bbs\t\t\t%s\n",(header.bbs?"YES":"NO"));
  fprintf(_f,"oec\t\t\t%s\n\n",(header.oec?"YES":"NO"));

  fprintf(_f,"# NUMBER OF COLUMNS TO USE FOR BULLETIN MENU ENTRIES\n");
  if (header.columns) fprintf(_f,"columns\t\t\t%d\n\n",header.columns);
  else fprintf(_f,"columns\t\t\tautomatic\n\n");

  fprintf(_f,"# MAKE LEFT-TO-RIGHT (ACROSS) OR TOP-TO-BOTTOM (DOWN) FORMAT\n");
  fprintf(_f,"order\t\t\t%s\n\n",(header.order?"across":"down"));

  fprintf(_f,"# TITLE SPECIFICATIONS\n");
  fprintf(_f,"title_text\t\t%s\n",header.title_text_);
  fprintf(_f,"title_color\t\t%s\n",header.title_color_);
  fprintf(_f,"prompt_color\t\t%s\n\n",header.prompt_color_);

  fprintf(_f,"# GLOBAL BULLETIN SPECIFICATIONS\n" );
  fprintf(_f,"display_privileged\t%s\n",(header.display_privileged?"yes":"no"));
  fprintf(_f,"format\t\t\t%s\n",header.format_);
  fprintf(_f,"lead_character\t\t%c\n",header.lead_character);
  fprintf(_f,"lead_color\t\t%s\n",header.lead_color_);
  fprintf(_f,"choice_color\t\t%s\n",header.choice_color_);
  fprintf(_f,"tail_character\t\t%c\n",header.tail_character);
  fprintf(_f,"tail_color\t\t%s\n",header.tail_color_);
  fprintf(_f,"entry_color\t\t%s\n",header.entry_color_);
  fprintf(_f,"highlight_character\t%c\n",header.highlight_character);
  fprintf(_f,"highlight_color\t\t%s\n",header.highlight_color_);
  fprintf(_f,"highlight_blink\t\t%s\n\n",(header.highlight_blink?"yes":"no"));

  /* get rid of Help & Credits */
  header.number_of_bulletins -= 2;
  for (i=0; i<header.number_of_bulletins; i++)
  {
    fprintf(_f,"# BULLETIN SPECIFICATION #%02d\n",i+1);
    fprintf(_f,"choice_character\t%c\n", bullet[i].choice_character);
    fprintf(_f,"entry_text\t\t%s\n", bullet[i].entry_text_);
    fprintf(_f,"access\t\t\t%c\n", bullet[i].access);
    fprintf(_f,"file\t\t\t%s\n", bullet[i].file_);
    switch( bullet[i].highlight_mode )
    {
      case 0:
        fprintf(_f,"highlight_mode\t\tnever\n\n" );
        break;
      case 1:
        fprintf(_f,"highlight_mode\t\talways\n\n" );
        break;
      case 2:
        fprintf(_f,"highlight_mode\t\tautomatic\n\n" );
        break;
    }
  }

  fprintf(_f,"\n# HELP TEXT\n");
  for (i=0; i<n_help_text; i++)
    fprintf(_f,"%s",help_text_[i]);

  /*kef fclose (_f);*/
  fflush(stdout);
  return (0);
}




/********************************************************************/
int Write_Obul_Menu ()
{
  short status;
  short i,j,k,l,m,n,x;
  short num_rows, extra_space;
  short show_help, space_per_column;
  int len;
  FILE *_fbbs,*_foec;

  
  if (header.oec)
  {
    j = header.columns;
    extra_space = space_per_column = 0;
    for (i=0; i<num_bulletins_available; i++)
      space_per_column = MAX( strlen( bullet[ba[i]].entry_text_ ), space_per_column );
    for( i=0; i<strlen(header.format_); i++ )
      if( header.format_[i] != 'e' )  ++extra_space;
    /* 3 for seraration */
    space_per_column += (3 + extra_space);
    header.columns = (num_columns-3) / space_per_column;
    if(( j ) && ( header.columns > j ))  header.columns = j;
    show_help = num_bulletins_available % header.columns;
    num_rows = ((double)num_bulletins_available / header.columns) + 0.99;

    strcpy (string_, header.path_);
    strcat (string_, ".oec");
    if ((_fbbs = fopen (string_, "w")) != 0)
    {
      fprintf( _fbbs, "[/loop]\n[cls]\n" );
      fprintf( _fbbs, "[%s]%s\n", header.title_color_, header.title_text_);
      fprintf( _fbbs, "[blue]Prepared by OBUL %03d on [date]\n",VERSION);
      fprintf( _fbbs, "[cyan]\n");

      for( k=0; k<num_rows; k++ )
      {
        i = k - num_rows;
        for( j=0; j<header.columns; j++ )
        {
          if (header.order)  /*across*/
          {
            i = (k * header.columns) + j;
          }
          else
          {
            if (num_bulletins_available % header.columns)
            {
              if (j > (num_bulletins_available % header.columns))
                i+= (num_rows-1);
              else if ((j >= (num_bulletins_available % header.columns)) &&
                       (k==num_rows-1))
                i = num_bulletins_available;    /* make next IF fail */
              else
                i+= num_rows;
            }
            else
              i+= num_rows;
          }
          if (i<num_bulletins_available)
          {
            Format_Entry( ba[i], _fbbs, header.oec );
            if (j != header.columns-1)
              for (x=0; x<space_per_column-extra_space-strlen(bullet[ba[i]].entry_text_); x++)
                fprintf( _fbbs, " " );
          }
        }
        fprintf( _fbbs, "\n" );
      }
      fprintf( _fbbs, "[cyan]\n" );

      if (lu.user.times)
      {
        if (any_new)
        {
          if (any_new==1)
            fprintf( _fbbs,"[%s][fname], 1 updated bulletin, marked with ", header.title_color_ );
          else
            fprintf( _fbbs,"[%s][fname], %d updated bulletins, marked with ", header.title_color_, any_new );
          fprintf( _fbbs, "[%s]", header.highlight_color_ );
          if( header.highlight_blink ) fprintf( _fbbs, "[blink]" );
          fprintf( _fbbs,"%c[%s]\n", header.highlight_character, header.title_color_ );
        }
      }
      else
      {
        fprintf( _fbbs,"[%s]This is your first visit [fname], please read [%s]all[%s] bulletins.\n",
          header.title_color_ ,header.highlight_color_, header.title_color_ );
      }
      fprintf( _fbbs, "[cyan]\n" );
      fprintf( _fbbs, "[%s]Enter Selection: [menu][[", header.prompt_color_);
      for (i=0; i<num_bulletins_available; i++)
      {
        fprintf( _fbbs, "%c", bullet[ba[i]].choice_character );
      }
      fprintf( _fbbs, "] \n" );
      for (i=0; i<num_bulletins_available; i++)
      {
        if (!bullet[ba[i]].access)
          fprintf( _fbbs, "[choice]%c[goto][privileged]\n", bullet[ba[i]].choice_character );
        else if( !strncmp( bullet[ba[i]].file_, "*quit", 5))
          fprintf( _fbbs, "[choice]%c[cls][quit]\n", bullet[ba[i]].choice_character );
        else if( !strncmp( bullet[ba[i]].file_, "*hangup", 7))
          fprintf( _fbbs, "[choice]%c[cls]Disconnecting...[hangup]\n", bullet[ba[i]].choice_character );
        else if( bullet[ba[i]].choice_character == '=' )
          fprintf( _fbbs, "[choice]%c[goto][credit]\n", bullet[ba[i]].choice_character );
        else if( bullet[ba[i]].choice_character == '?' )
          fprintf( _fbbs, "[choice]%c[goto][help]\n", bullet[ba[i]].choice_character );
        else
          fprintf( _fbbs, "[choice]%c[display]%s\n", bullet[ba[i]].choice_character, bullet[ba[i]].file_ );
      }
      fprintf( _fbbs, "[goto][loop]\n" );
      fprintf( _fbbs, "[/privileged]\n");
      fprintf( _fbbs, "[%s]", header.prompt_color_ );
      fprintf( _fbbs, "Your privilege level does not grant you access to this item.[bell]\n\n" );
      fprintf( _fbbs, "[enter]\n");
      fprintf( _fbbs, "[goto][loop]\n" );
      fprintf( _fbbs, "[/help]\n" );
      fprintf( _fbbs, "[cls][%s]\n", header.prompt_color_ );
      for( i=0; i<n_help_text; i++ )
        fprintf( _fbbs, "%s", help_text_[i] );
      fprintf( _fbbs, "[enter]\n");
      fprintf( _fbbs, "[goto][loop]\n" );
      fprintf( _fbbs, "[/credit]\n" );
      fprintf( _fbbs, "[cls][%s]\n", header.prompt_color_ );
      for( i=0; i<n_credit_text; i++ )
        fprintf( _fbbs, "%s\n", credit_text_[i] );
      fprintf( _fbbs, "[enter]\n");
      fprintf( _fbbs, "[goto][loop]\n" );
      fclose( _fbbs );
    }
    if (header.bbs)
    {
      sprintf( string2_, "obuloecc %s %s.bbs", string_, header.path_ );
      system( string2_ );
    }
  }
  return (0);
}




/********************************************************************/
int Format_Entry( i, _f, outflag )
short i;
FILE *_f;
char outflag;  /* 0=bbs, 1=oec */
{
#include <time.h>
#ifndef UNIX
# include <sys\types.h>
# include <sys\stat.h>
#else
# include <sys/types.h>
# include <sys/stat.h>
#endif
  FILE *fd;
  int j;
  char star_flag;
  long ftime;
  struct stat buffer;

  if( outflag == 1 )
  {
    for( j=0; j<strlen(header.format_); j++ )
    {
      switch( header.format_[j] )
      {
        case 'l':
          fprintf( _f, "[%s]%c", header.lead_color_, header.lead_character );
          break;
    
        case 'c':
          fprintf( _f, "[%s]%c", header.choice_color_, bullet[i].choice_character );
          break;
    
        case 't':
          fprintf( _f, "[%s]%c", header.tail_color_, header.tail_character );
          break;
    
        case 'h':
          star_flag = (bullet[i].file_[0] == '*');
          if (!star_flag)
          {
            stat( bullet[i].file_, &buffer );
            ftime = buffer.st_mtime;
            fprintf(log_file,"file: %s, %s",bullet[i].file_,ctime(&ftime));
          }
          else
          {
            if (bullet[i].highlight_mode == 2) bullet[i].highlight_mode = 0;
          }
          if ((bullet[i].highlight_mode == 0) ||
               ((bullet[i].highlight_mode == 2) && (ftime < lu.user.ludate)
                && (lu.user.times)))
          {
            fprintf( _f, " " );
          }
          else
          {
            ++any_new;
            fprintf( _f, "[%s]", header.highlight_color_ );
            if( header.highlight_blink ) fprintf( _f, "[blink]" );
            fprintf( _f,"%c", header.highlight_character );
          }
          break;

        case 'e':
          fprintf( _f, "[%s]%s", header.entry_color_, bullet[i].entry_text_ );
          break;

        default:
          fprintf( _f, "%c", header.format_[j] );
          break;
      }
    }
  }
}
