program catqwk;

{ CatQWK 2.2
  Sun Feb  9 12:01:40 EST 1992
  by Patrick Y. Lee
  Program to combine one or more QWK files into one.
}

{$D-,L-,E-,I-,N-,R-,S-,V-}
{$M 8192, 0, 81920}

uses
    crt, dos, strnttt5, qwktpu;

const
    message = 'messages.dat';
    sp = ' ';
    crlf = #13 + #10;
    cfg = 'catqwk.cfg';

type
    wcptr = ^wildcard;
    wildcard = record
        qwkname : dirstr;
        next : wcptr;
    end;

var
    msgoldfh, msgnewfh : file;
    k, tmp : longint;
    workpath, worknew, workold, qwknew, orgdir, compress, decompress : dirstr;
    opt, compopt, decompopt : string [25];
    i, start : byte;
    err : boolean;
    current, first, temp : wcptr;
    f : searchrec;
    e, nummsg : word;
    dir : dirstr;
    name : namestr;
    ext : extstr;
    personal : string [25];

label
    break1, break2;

procedure doswrite (s : string); { output to screen using DOS }
var
    r : registers;
begin
    s := concat (s, crlf, '$');
    with r do
    begin
        ah := 9;
        ds := seg (s [1]);
        dx := ofs (s [1]);
    end; { with }
    msdos (r);
end; { procedure doswrite }

procedure blankline;
begin
    doswrite ('');
end;

procedure errormessage (e : byte);              { display error message }
var
    s : string [80];
begin
    case e of
        1 : s := 'Error creating temporary work directory.';
        2 : s := 'Error: You did not specify enough QWK filenames on the command line.';
        3 : s := 'Error extracting first mail packet, ' + current^.qwkname;
        4 : s := 'Error extracting CONTROL.DAT file from mail packet, ' + current^.qwkname + '.';
        5 : s := 'Error extracting message file from mail packet, ' + current^.qwkname + '.';
        6 : s := 'Error concatenating file ' + current^.qwkname + '.';
        7 : s := 'Error compressing the new combined mail packet, ' + qwknew + '.';
        8 : s := 'Cannot find archive utility, make sure it is somewhere on your PATH.';
    end; { case }
    blankline;
    doswrite (s);
    halt (1);
end; { procedure errormessage }

{ return last x characters from string }
function last (x : byte; temp : string) : string;
begin
    last := copy (temp, length (temp) - x + 1, x);
end; { function last }

procedure addslash (var s : dirstr);
begin
    if last (1, s) <> '\' then s := s + '\';
end;

{ procedure to read the configuration file }
procedure readcfg;
var
    p : byte;
    cfg_fh : text;
    cfg_fn, command, temp, value : string;

    procedure compfiles (var sexe, sopt : string);
    begin
        sopt := extractwords (2, 99, sexe);
        sexe := extractwords (1,  1, sexe);
        if not exist (sexe) then sexe := fsearch (sexe, getenv ('path'));
        if not exist (sexe) then errormessage (8);
    end;

begin

    { default values }
    workpath := '.\';
    compress := 'pkzip.exe -m';
    decompress := 'pkunzip.exe -o';
    personal := '';

    { get location of configuration file }
    if exist (cfg) then
        cfg_fn := cfg
    else
    begin
        cfg_fn := getenv ('catqwk');
        if (cfg_fn = '') then
            cfg_fn := lower (fsearch ('catqwk.cfg', getenv ('path')));
        if pos (cfg, cfg_fn) = 0 then
        begin
            addslash (cfg_fn);
            cfg_fn := cfg_fn + cfg;
        end; { if }
    end; { else }

    { cannot find configuration file }
    if (exist (cfg_fn)) then
    begin

        { open configuration file }
        filemode := 0; { read only }
        assign (cfg_fh, cfg_fn);
        reset (cfg_fh);

        { read configuration file }
        repeat
            readln (cfg_fh, temp);
            temp := lower (strip ('b', sp, temp));
            if temp [1] <> ';' then { if line is not a comment }
            begin
                p := pos ('=', temp) - 1;
                command := strip ('r', sp, copy (temp, 1, p));
                value := strip ('l', sp, last (length (temp) - p - 1, temp));
                if command = 'workpath' then workpath := value;
                if command = 'compress' then compress := value;
                if command = 'decompress' then decompress := value;
                if command = 'personal' then personal := upper (padleft (value, 25, sp));
            end;
        until eof (cfg_fh);

        close (Cfg_FH);

    end; { if }

    { check path name }

    addslash (workpath);
    compfiles (compress, compopt);
    compfiles (decompress, decompopt);

end; { procedure readcfg }

procedure build_ndx_files (var fh : file);      { routine to build NDX }
var                                             { files from MESSAGES.DAT }
    confnum : word;
    buffer : blockformat;
    k, numblock : longint;
    name : string [25];
begin
    blankline;
    doswrite ('Creating index files ...');
    k := 1;
    name [0] := #25;
    seek (fh, k);
    repeat
        blockread (fh, buffer, 1);
        numblock := str_to_int (strip ('B', sp, copy (buffer, 116, 7)));
        if buffer [124] = #32 then
            confnum := ord (buffer [123])
        else
            move (buffer [123], confnum, 2);
        if numblock >= 1 then                   { only write if it is }
        begin                                   { a real message }
            writendx (worknew, confnum, k, false);
            move (buffer [21], name [1], 25);
            if upper (name) = personal then
                writendx (worknew, confnum, k, true);   { personal message }
            k := k + numblock;                  { next message }
            seek (fh, k);
        end;
    until eof (fh) or (numblock < 1);
end; { procedure build_ndx_files }

function decomp (opt : string) : boolean; { true = error, false = good }
begin
    exec (decompress, concat (sp, decompopt, sp, current^.qwkname, sp, opt));
    decomp := (dosexitcode <> 0);
end;

procedure addext (var s : dirstr);
begin
    if pos ('.', s) = 0 then s := s + '.qwk';
end;

procedure newrec;
begin
    temp := current;
    new (current);
    current^.next := nil;
    temp^.next := current;
end;

procedure md (dir : dirstr);
begin
    mkdir (dir);
    if ioresult <> 0 then errormessage (1);
end;

begin

    blankline;
    doswrite ('CatQWK 2.20  9 Feb 1992  Copyright 1991-1992 by Patrick Y. Lee  Freeware');

    if paramcount < 2 then
    begin
        blankline;
        doswrite ('Program to concatenate two or more QWK files into one.');
        blankline;
        doswrite ('Syntax: ' + paramstr (0) + ' [-dworkpath] newqwk oldqwk1 [oldqwk2 ...]');
        halt (1);
    end;

    readcfg;

    for i := 1 to paramcount do
    begin
        opt := paramstr (i);
        if opt [1] <> '-' then goto break1;
        if opt [2] = 'd' then
        begin
            workpath := copy (opt, 3, ord (opt [0]));
            addslash (workpath);
        end; { if }
    end; { for }

break1:
    start := i + 1;
    { create temporary work directories }
    worknew := workpath + '!!!work.new';
    workold := workpath + '!!!work.old';
    md (worknew);
    md (workold);

    qwknew := paramstr (i);
    if pos ('.', qwknew) = 0 then qwknew := qwknew + '.qwk';
    inc (i);

    if (start > paramcount) then { not enough parameters }
    begin
        rmdir (worknew);
        rmdir (workold);
        errormessage (2); 
    end;

    new (current);
    first := current;
    while i <= paramcount do
    begin
        current^.qwkname := paramstr (i);
        current^.next := nil;
        if (pos ('*', current^.qwkname) <> 0) or (pos ('?', current^.qwkname) <> 0) then
        begin
            addext (current^.qwkname);
            current^.qwkname := fexpand (current^.qwkname);
            fsplit (current^.qwkname, dir, name, ext);
            orgdir := dir;
            addslash (orgdir);
            findfirst (current^.qwkname, archive + readonly, f);
            e := doserror;
            while e = 0 do
            begin
                current^.qwkname := orgdir + f.name;
                findnext (f);
                e := doserror;
                if e = 0 then newrec;
            end; { while }
        end { if }
        else
            addext (current^.qwkname);
        inc (i);
        if i <= paramcount then newrec;
    end; { while }
    current := first;

    while current <> nil do
    begin

        { treat first QWK file differently }
        if (current = first) then begin

            if decomp (message + sp + worknew + '\') then errormessage (3);
            assign (msgnewfh, worknew + '\' + message);
            filemode := 2;                  { read/write access }
            reset (msgnewfh, 128);          { open primary QWK }
            findrealeof (msgnewfh, k, nummsg);

        end { if }
        else
        begin

            if decomp ('CONTROL.DAT ' + worknew + '\') then errormessage (4);
            if decomp (message + sp + workold + '\') then errormessage (5);

            assign (msgoldfh, workold + '\' + message);
            filemode := 0;                  { read only }
            reset (msgoldfh, 128);          { open it }
            filemode := 2;                  { read/write }
            findrealeof (msgoldfh, tmp, nummsg);
            seek (msgoldfh, 1);             { position the files }
            seek (msgnewfh, k+1);
            copy_qwk_msg (msgoldfh, msgnewfh, 1, tmp, err);
            close (msgoldfh);
            erase (msgoldfh);
            if (err) then errormessage (6);
            k := k + tmp;

        end; { else }

        temp := current^.next;
        dispose (current);
        current := temp;

    end; { while }

break2:

    rmdir (workold);
    build_ndx_files (msgnewfh);             { create new index files }
    close (msgnewfh);

    exec (compress, sp + compopt + sp + qwknew + sp + worknew + '\*.*');
    if dosexitcode <> 0 then errormessage (7);

    rmdir (worknew);

end. { program catqwk }
