; -*-Emacs-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         misc.el
; RCS:          $Header: f:/flat32/emacs-18.59/lisp/nonstd/RCS/misc.el 1.1 1993/04/18 00:45:49 darrylo Exp $
; Description:  Various and sundry short functions from many different places.
; Author:       Darryl Okahata
; Created:      Sun Jan 28 14:46:19 1990
; Modified:     Sat Feb 23 17:13:24 1991 (Darryl Okahata) darrylo@hpsrdmo
; Language:     Emacs-Lisp
; Package:      N/A
; Status:       Experimental (Do Not Distribute)
;
; (C) Copyright 1990, 1991, Hewlett-Packard, all rights reserved.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; From:   merlyn@intelob.intel.com (Randal L. Schwartz @ Stonehenge)
;; Date:   Mon, 1 May 1989 21:51:11 GMT
;; Subject:   see-chars for GNU
;; 
;; Ever wonder what characters a function key sends out, or one of those
;; other "unknown" keys like "scroll right"?  Well, even if you don't
;; have one of those problems today, tuck this little goody away, 'cause
;; it'll help you figure that out when the time comes.
;; 
;; `see-chars' accepts *any* characters (including a C-g) until a
;; three-second timeout has passed.  It then tosses up a human-readable
;; display of the characters entered.
;; 
;; /=Randal L. Schwartz, Stonehenge Consulting Services (503)777-0095===\
;; { on contract to BiiN, Hillsboro, Oregon, USA, until 30 May 1989     }
;; { <merlyn@intelob.intel.com> ...!uunet!tektronix!biin!merlyn         }
;; { or try <merlyn@agora.hf.intel.com> after 30 May 1989               }
;; \=Cute quote: "Welcome to Oregon... home of the California Raisins!"=/
;; 
;; ================================================== snip snip ==========
;;; original by merlyn -- LastEditDate = "Mon Apr 10 15:45:46 1989"

(defun see-chars ()
  "Displays characters typed, terminated by a 3-second timeout."
  (interactive)
  (let ((chars "")
	(inhibit-quit t))
    (message "Enter characters, terminated by 3-second timeout...")
    (while (not (sit-for 3))
      (setq chars (concat chars (list (read-char)))
	    quit-flag nil))		; quit-flag maybe set by C-g
    (message "Characters entered: %s" (key-description chars))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Date: Mon, 20 Mar 89 19:40:57 EST
;From: bard@theory.lcs.mit.edu
;To: pierson%mist.lcs.mit.edu@CHIPS.BBN.COM
;Cc: unix-emacs@bbn.com
;Subject: Summing Columns
;
;
;Here's a trivially improved version of Dan Pierson's sum-column function.
;The improvements are more as advice about gnumacs-lisp coding than
;significant ones:
;
;  (1) using (interactive "r") instead of (interactive "d\nm")
;      and then figuring out which is the beginning and which the end
;  (2) eta-reducing the '(lambda (x) (string-to-int x)) into
;      (function string-to-int).  (function is like quote, but 
;      possibly better for the compiler.)
;  (3) Only printing the result when it's called interactively, so
;      that other programs can call it without cluttering up the 
;      message-line with random "The sum is 78" messages.  Ever wonder
;      why monkey-mode keeps saying "Done" when it is obviously not done?
;
;There's also a very cheap sum-region command, which adds up all the numbers
;in the region.  It's not very smart; e.g., I got lazy about treating "- 1"
;and "-1" the same.  (The second one is -1; the first is +1.)  Improvements
;are welcome.  
;
;It would be nice to have (e.g.) rational arithmetic commands, so that you
;could type 
;  4/3 + (2*3)/(8+1)
;and run m-x eval-rational-expression-insert, and it would replace that
;expression by 2. (Assuming I've done it right.)  Even adding up lists of
;numbers with decimals would be nice -- "You owe me 4.12+51.00+40.30"
;
;-- Bard the emacs gargoyle


(defun sum-column (start end)
  "Return the sum of the integers in the rectangle delimited
by START and END. Interactively, it prints the sum as well, and uses the
region."
  (interactive "r")
  (let* ((str-nums (extract-rectangle start end))
	 (nums (mapcar (function string-to-int) str-nums))
	 (sum (apply (function +) nums)))
    (if (interactive-p) (message "%d" sum))
    sum))

(defun sum-region (start end)
  "Adds up the numbers in the region START to END.  Primitive as yet.
If called interactively, uses the region and prints the sum in a message.
Ignores things that aren't numbers or signs, so 
  $1 + $4 
will sum to 5, and
  1 -4
will sum to -3.  Of course, it's really dumb, and things like
  2*3 - 5
will sum to 2+3+5 = 10 -- as will 2 + 3.5.  Improvements welcomed."
  (interactive "r")
  (save-excursion
    (goto-char start)
    (let ((sum 0)
          sign number)
      (while (re-search-forward "\\(-?\\)\\([0-9]+\\)" end t)
        ;; maybe allow whitespace between sign and number?
        ;; that's why I'm parsing clumsily.
        (setq sign
                (= (match-beginning 1) (match-end 1))
              number (string-to-int
                      (buffer-substring (match-beginning 2) (match-end 2))))
        (setq sum
              (if sign (+ sum number) (- sum number))))
      (if (interactive-p)
          (message "The sum is %d" sum))
      sum)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File=</net/hpcvca/usr/src/local/gnumacs/lisp/copy-line.el>
; Charles Brown  Date=<Thu Jan 21 10:09:29 1988>

(defun abs (number)
  "Return the absolute value of the number."
  (if (> number 0) number (- number)))

(defun copy-region (start stop &optional repeat)
  "Duplicate the region indicated by start and stop.  If repeat is non-nil,
it indicates how many copys to make.  The duplicates are inserted after stop."
  (let ((old-repeat (or repeat 1))
	(count (or repeat 1))
	(diff (cond ((> (point) start) (abs (- stop start)))
		    (t 0))))
    (save-excursion
      (goto-char stop)
      (while (> count 0)
	(insert-buffer-substring (buffer-name) start stop)
	(setq count (- count 1))
	))
    old-repeat
    ))

(defun copy-line (&optional repeat)
  "Duplicate the current line.  If repeat is non-nil, it indicates how
many copys to make."
  (interactive "p")
  (let ((start)
	(repeat-num (cond ((null repeat) 1)
			  (t (prefix-numeric-value repeat)))))
    (save-excursion
      (setq start (progn
		    (beginning-of-line)
		    (point)))
      (end-of-line)
      (if (eobp)
	  (newline)
	(progn
	  (forward-line)
	  (beginning-of-line)))
      (copy-region start (point) repeat-num))
    (next-line repeat)
    nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File="/net/hpcvca/usr/src/local/gnumacs/s300/lisp/date-code.el"
; Charles Brown  Date="Sun Oct 25 16:43:15 1987"

(if (not (boundp 'datecode))
    (progn
      (defvar datecode 0)
      (make-variable-buffer-local 'datecode)))
(if (not (boundp 'filecode))
    (progn
      (defvar filecode 0)
      (make-variable-buffer-local 'filecode)))

(defun
  date-code ()
  "Update datecode and filecode of the current buffer.
This function is usually bound to write-file-hooks."
  (interactive)
  (let ((work-done nil)
	(answer nil)
	(dates-changed 0))
       (save-excursion
	 (if (/= filecode 0)
	     (formatted-date-code
	      "\\(file=<\\)[^>\C-j]*\\(>\\)"
	      '(concat "\\1" (buffer-file-name) "\\2")
	      (- filecode
		 (formatted-date-code
		  "\\(file=\"\\)[^\"\C-j]*\\(\"\\)"
		  '(concat "\\1" (buffer-file-name) "\\2")
		  filecode 1000))
	      1000))
	 (if (/= datecode 0)
	     (if
		 (= 0
		    (progn
		      (setq dates-changed
			    (formatted-date-code
			     "\\(date=\"\\)[^\C-j\"]*\\(\"\\)"
			     '(concat "\\1" (current-time-string) "\\2")
			     datecode 1000))
		      (+
		       (formatted-date-code
			"\\(date=<\\)[^>\C-j]*\\(>\\)"
			'(concat "\\1" (current-time-string) "\\2")
			(- datecode dates-changed) 1000)
		       dates-changed)))
		 (setq work-done " [No date code]")
	       (setq work-done " [Date code updated]"))
	   (setq work-done "")))
;       (basic-save-buffer)
;       (sit-for 1)
       (message
	(concat "Wrote " (buffer-file-name) work-done))
       nil))

(defun
  formatted-date-code (format-from format-to number limit)
  "Substitute date code string specified by regexp FORMAT-FROM to regexp
FORMAT-TO.  Perform substitution NUMBER times within the first LIMIT
characters of the current buffer.  Return replacement count."
  (save-excursion
    (beginning-of-buffer)
    (let ((count 0))
	 (while (and
		 (< count number)
		 (if (re-search-forward (eval format-from) limit t)
		     (progn
		       (replace-match (eval format-to) t nil)
		       t)))
	   (setq count (+ 1 count)))
	 count)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; File=< pass-to-sh.el >
; Charles Brown  Date=<>

;(defun
;  lessor (first second)
;  "Return the least of two numeric values.  If one is nil, return the other."
;  (let ((newfirst (or first second 0))
;	(newsecond (or second first 0))
;	(either (or first second)))
;    (if either
;	(if (< newfirst newsecond)
;	    newfirst
;	  newsecond)
;      nil)))

(defun
  pass-to-sh ()
  "Pass the line that point is on to shell."
  (interactive)
  (save-excursion
    (let ((stop (progn
		   (end-of-line)
		   (point)))
	  (start (progn (beginning-of-line)
			(point)))
	  (shell (or (getenv "ESHELL")
		     (getenv "SHELL")
		     "/bin/sh")))
      (end-of-line)
      (if (eobp)
	  (newline)
	(next-line 1)
	(beginning-of-line))
      (message "busy...")
      (call-process-region start stop shell nil t t)
      (message "done.")))
  (end-of-line))
