/* lf2crlf.c -- translator for use with Charon
	Copyright (C) 1992 Brad K. Clements, Clarkson University
	       All Rights Reserved.

*/
#define	DEBUG	1

#include <ctype.h> 
#include <time.h>
#include <string.h>
#define	STANDALONE	0
#include "callback.h"
#include "tagvalue.h"

char	*stackinfo="$STACKSIZE:4096";

/* Usage:
	converts LF to CRLF
*/

#define	BUFFSIZE	1024

int
main(int argc, char *argv[])
{
	int 	rc;
	char		ibuffer[BUFFSIZE], obuffer[BUFFSIZE];
	char		*inc, *outc, *inlimit, *outlimit;
	int		incount;
	long		start = time(NULL);
	long		inbytes, outbytes;

	inbytes = outbytes = 0;
	outc = obuffer;
	outlimit = obuffer + BUFFSIZE - 4;
	while(1) {
		incount = read(STDIN, ibuffer, BUFFSIZE);
#ifdef	DEBUGX
	fprintf(STDERR,"Read %d bytes\n",incount);
#endif
		if(incount < 1)
		       	break;		/* we're done */
		inlimit = ibuffer + incount;
	 	inbytes += incount;
	 	for(inc = ibuffer; inc < inlimit; inc++) {
			if( *inc == 10)
			       	*outc++ = 13;
			*outc++ = *inc;
			if(outc >= outlimit) {
#ifdef	DEBUGX
	fprintf(STDERR,"writing %d bytes\n",outc - obuffer);
#endif
			       	outbytes += (outc - obuffer);
			       	write(STDOUT, obuffer, outc - obuffer);
				outc = obuffer;
			}
	       }
	       if(incount < BUFFSIZE)
		      	break;
       }
	if(outc > obuffer) {
	       	write(STDOUT, obuffer, outc - obuffer);
		outbytes += (outc - obuffer);
	}
	start = time(NULL) - start;
	fprintf(STDERR,"Converted %ld inbytes to %ld outbytes in %ld seconds.\n",
	       	inbytes, outbytes, start);
      	return(RT_OK|RT_CHANGED_TEXT); 
}

