
/****************************************************************************
*   Function:    int sockr(int fd, char *ptr, int maxlen)                   *
*   Operation:   to read bytes from socket fd into ptr up to a newline      *
*   Returns:     a 0 for OK, or -1 for error                                *
*   Parameters:  fd, socket file descriptor                                 *
*                ptr, address of character array to read into               *
*                maxlen, the maximum number of characters to read into ptr  *
****************************************************************************/

# include <io.h>
#include <time.h>

int sockr(fd, ptr, maxlen)
  register int fd;
  register char *ptr;
  register int maxlen;
{
  int n, rc;
  long itimer, ctimer;
  char c;

  for (n = 0; n < maxlen; n++) {
    time(&itimer);	/* Reset initial timer */
timingit:
    if ((rc = read(fd, &c, 1)) == 1) {
      ptr[n] = c;
      if (c == '\n')
	break;
    } else if (rc < 0) {	/* No byte read this round */
      time(&ctimer);	/* Reset current timer */
      if (ctimer > itimer + 5) {	/* Too long? */
	if (n == 0) {
	  break;	/* died on first try */
	} else {
	  break;	/* died beyond the first try */
	}
      } else {
	goto timingit;	/* go wait... */
      }
    } else {	/* rc == 0, means socket closed */
      *ptr = 0;
      return (-1);	/* return a -1 for socket error */
    }
  }
  n++;
  ptr[n] = 0;

  if( ptr[strlen(ptr)-1] == '\n' )
      ptr[strlen(ptr)-1] = 0;   /* stripping newline */
  if( ptr[strlen(ptr)-1] == '\r' )
      ptr[strlen(ptr)-1] = 0;   /* stripping carriage return */
  if( ptr[strlen(ptr)-1] == '\n' )
      ptr[strlen(ptr)-1] = 0;   /* stripping newline */
  strcat(ptr, "\n");	/* assure a newline */

  return (0);
}
