/*--------------------------------------------------------------------------*
 * Gregory Stevens                                                   7/1/93 *
 *                                NNSIM1.C                                  *
 *    (Generalized Simulator: Supervised,Feed Forward,Back Propagation)     *
 *                                                                          *
 *   This is a generalized simulator for a supervised feed-forward neural   *
 * with back-propagation.  It uses the nn*.c series.                        *
 * For this file, the following parameters in the following files should be *
 * set to comply with the input file and desired net configuration:         *
 *      NNPARAMS.C : INPUT_LAYER_SIZE                                       *
 *                   OUTPUT_LAYER_SIZE                                      *
 *                   NUM_HIDDEN_LAYERS                                      *
 *                   HL_SIZE_#                                              *
 *                                                                          *
 *      NNINPUTS.C : NUM_PATTERNS                                           *
 *                                                                          *
 *      NNSTRUCT.C : InitNet()   (generally, all nodes should be logistic)  *
 *                                                                          *
 *      NNBKPROP.C : EPSILON 0.25  (recommended...this is what I used)      *
 *                                                                          *
 *   There should be 3 data files: nninputs.dat, nnoutput.dat, nnintest.dat *
 *   These correspond to the training inputs, desired output for training   *
 * inputs, and novel inputs to test for generalization.                     *
 *                                                                          *
 *   NOTE: The last file is only necessary if INTEST is set to 1.           *
 *                                                                          *
 *--------------------------------------------------------------------------*/
#include "nnbkprop.c"                /* to chain it to the nn*.c utilities  */

#define IN_TEST 1                    /* whether generalization tests should */
                                     /* be made (Boolean)                   */
#define NUM_ITS 200                  /* iterations before it stops training */

void main()
{
  int Pattern;                          /* for looping through patterns   */
  int Layer;                            /* for looping through layers     */
  int LCV;                              /* for looping training sets      */
  NNETtype Net;                         /* for the network itself         */
  PATTERNtype InPatterns, OutPattern;   /* for the training patterns      */

  Net = InitNet( NUMNODES );           /* initializes the network        */
  InPatterns = InitInPatterns(0);       /* loads input patterns from file */
  OutPattern = InitOutPatterns();       /* loads output patterns from file*/

  printf("\n\n\n\n\n");                 /* gets screen ready for output   */

  printf( "BEGINNING TRAINING:\n\n" );

  for (LCV=0; (LCV < NUM_ITS); ++LCV)   /* loop through a training set    */
    {
      for (Pattern=0; (Pattern<NUM_PATTERNS); ++Pattern)  /* each pattern */
         {
            /* FORWARD PROPAGATION */
            Net = UpDateInputAct( InPatterns, Pattern, Net );
            for (Layer=1; (Layer<NUMLAYERS); ++Layer)
              {
                 Net = UpDateLayerAct( Net, Layer );
              }

            /* OUTPUT PRINTS */
            /*    NOTE: The last number in DisplayLayer() will need to be */
            /*          adjusted to format different size input layers.   */

            DisplayLayer( Net, 0, 8 );             /* display input layer */
            printf( "   " );
            DisplayLayer( Net, (NUMLAYERS-1), 1);  /* display output layer*/
            printf( "\n" );                        /* new line            */

                                                   /*it is possible to    */
                                                   /*display hidden layers*/

            /* BACKWARD PROPAGATION */
            Net = UpDateWeightandThresh( Net, OutPattern, Pattern );
         }

      printf( "\n\n" );                            /* prepare for next set*/

      if ( LCV > (NUM_ITS-10) )
        {
           getc(stdin);           /* pause inbetween training epochs */
        }
    }

  if (IN_TEST==1)
    {
      InPatterns = InitInPatterns(1);          /* Loads test input patterns */

      printf( "BEGINNING PATTERN TESTING:\n\n" );

      for (Pattern=0; (Pattern<NUM_PATTERNS); ++Pattern)
         {
           Net = UpDateInputAct( InPatterns, Pattern, Net ); /* load inputs */

           for (Layer=1; (Layer<NUMLAYERS); ++Layer)         /* run through */
              {
                 Net = UpDateLayerAct( Net, Layer );
              }

            /* OUTPUT PRINTS */
            DisplayLayer( Net, 0, 8 );             /* display input layer */
            printf( "   " );
            DisplayLayer( Net, (NUMLAYERS-1), 1 ); /* display output layer*/
            printf( "\n" );                        /* new line            */
         }


      getc(stdin);
    }
}
