/*
*
*  rghp.c by Aaron Contorer for NCSA
*
*  Routines for HP-GL plotter output.  Only 1 window output at a time.
*
*/

#include <stdio.h>
#ifdef MEMORY_DEBUG
#include "memdebug.h"
#endif
#include "externs.h"

#define TRUE 1
#define FALSE 0

static char *HPname = "Hewlett-Packard HP-GL plotter";
static char busy; /* is device already in use */
static int winbot,winleft,wintall,winwide;	/* position and size of window into virtual space */
static void (*outfunc)(char *s);	/* the function to call with pointer to strings */
static char HPtext[100];	/* the string containing the HP-GL output text */
static int HPpenx,HPpeny;
static int HPblank;
static int HPcolor;

static void HPbegin(void );
static void signore(char *s);

static void signore(s)
char *s;			/* Ignore the string pointer passed here. */
{
	s=s;
}

void RGHPoutfunc(f)
void (*f)(char *);
/*
	Specify the function that is to be called with pointers to all
	the HP-GL strings.
*/
{
	outfunc=f;
}

static void HPbegin()
/* set up environment for whole new printout */
{
	(*outfunc)("IN;SP1;SC-50,4370,-100,4120;PU0,0;");
	HPpenx=HPpeny=0;
}

int RGHPnewwin()
{
	if(busy) 
		return(-1);
	HPtext[0]='\0';
	HPpenx=HPpeny=0;
	HPblank=TRUE;
	HPcolor=100;
	return(0);
}

void RGHPclrscr(int w)
{
	RGHPpagedone(w);
}

void RGHPclose(int w) 
{
	RGHPclrscr(w);
	busy=FALSE;
}

void RGHPpoint(int w,int x,int y) 
{
	(*outfunc)("PD;PU;");
	w=w;
	x=x;
	y=y;
} 

void RGHPdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
{
	w=w;
	if(HPblank) {
		HPbegin();
		HPblank=FALSE;
	  }
	if(x0!=HPpenx||y0!=HPpeny) {		/* only move pen if not already there */
		sprintf(HPtext,"PU%d,%d;",x0, y0);
		(*outfunc)(HPtext);
	  }
	sprintf(HPtext,"PD%d,%d;",x1, y1);
	(*outfunc)(HPtext);
	HPpenx=x1;
	HPpeny=y1;
}

void RGHPpagedone(int w) 
{
	(*outfunc)("PG;");
	HPblank=TRUE;
	w=w;
}

void RGHPdataline(int w,char *data,int count) {
	
/* Needed for possible future functionality */

	w=w;
	data=data;
	count=count;

	}


void RGHPpencolor(int w,int color) 
{
	color&=7;
	if(color) {
		sprintf(HPtext,"SP%d;",color);
		(*outfunc)(HPtext);
	  }
	w=w;
}

void RGHPcharmode(int w,int rotation,int size) {
	
/* Needed for possible future functionality */

	w=w;
	rotation=rotation;
	size=size;

	}


void RGHPshowcur() {}
void RGHPlockcur() {}
void RGHPhidecur() {}
void RGHPbell(int w) {
	
/* Needed for possible future functionality */
	w=w;

	}

void RGHPuncover(int w) {
	
/* Needed for possible future functionality */
	w=w;

	}


char *RGHPdevname() 
{
	return(HPname);
}

void RGHPinit() 
{
	busy=FALSE;
	outfunc=signore;
}

void RGHPinfo(int w,int a,int b,int c,int d,int v) {
/* Needed for possible future functionality */
	w=w;
	a=a;
	b=b;
	c=c;
	d=d;
	v=v;

	}


void RGHPgmode() {}
void RGHPtmode() {}
