#TurboC 2.0 Makefile

BASEFLAGS= -DMSC -c -DFTP -O -Z -Ic:\TC\include -Iinclude -ml -Etasm.exe -d -DAJT
#debug add -v -y -N
CFLAGS =$(BASEFLAGS) 
AFLAGS = /DTURBOC /DMicrosoft /DAJT /Inet\enet
TCD    = \tc
TLIB   = $(TCD)\LIB 
LIB    = $(TCD)\lib\cl $(TCD)\lib\mathl $(TCD)\lib\emu lib\msmouse
# LIB    = $(TCD)\lib\cl $(TCD)\lib\emu
CC     = tcc 
ASM    = tasm 
LIBP   = tlib 
LNKP   = tlink
#/v adds debug
MAPS   = nul 
ASMLIST=nul 
 
ENTD=net\enet
ENETSRC1=$(ENTD)\net.ene $(ENTD)\ltalk.ene $(ENTD)\ltlisten.ene $(ENTD)\dndll2.ene $(ENTD)\dndll.ene
ENETSRC2=$(ENTD)\packet2.ene $(ENTD)\packet.ene $(ENTD)\netbicc2.ene $(ENTD)\netbicc.ene $(ENTD)\netatt10.ene
ENETSRC3=$(ENTD)\net3com.ene $(ENTD)\net501.ene $(ENTD)\net503.ene $(ENTD)\net505.ene $(ENTD)\net9210.ene
ENETSRC4=$(ENTD)\net523.ene $(ENTD)\netub.ene $(ENTD)\net5210.ene 
ENETSRC5=$(ENTD)\net8003.ene $(ENTD)\net8003a.ene $(ENTD)\netzyp.ene
ENETSRC=$(ENETSRC1) $(ENETSRC2) $(ENETSRC3) $(ENETSRC3) $(ENETSRC4) $(ENETSRC5)
ENETLIB=enet.lib

ENGD=engine
ENGSRC1=$(ENGD)\ip.eng $(ENGD)\bootp.eng $(ENGD)\user.eng $(ENGD)\rspc.eng $(ENGD)\util.eng 
ENGSRC2=$(ENGD)\udp.eng $(ENGD)\arp.eng $(ENGD)\domain.eng $(ENGD)\bkgr.eng
ENGSRC3=$(ENGD)\tcp.eng $(ENGD)\pcutil.eng $(ENGD)\protinit.eng $(ENGD)\mouse.eng
ENGSRC4=$(ENGD)\scrlback.eng $(ENGD)\menu.eng $(ENGD)\new_con.eng $(ENGD)\keymap.eng $(ENGD)\map_out.eng
ENGSRC5=$(ENGD)\ncsaio.eng $(ENGD)\ipasm.eng $(ENGD)\ncsabrk.eng $(ENGD)\tools.eng
ENGSRC=$(ENGSRC1) $(ENGSRC2) $(ENGSRC3) $(ENGSRC4) $(ENGSRC5)
ENGLIB=engine.lib

VSD=vs
VSSRC=$(VSD)\vsinterf.vs $(VSD)\vsintern.vs $(VSD)\vsem.vs 
VSLIB=vs.lib 

RGD=rg
RGSRC1=$(RGD)\rg0.rg $(RGD)\rge.rg $(RGD)\rgh.rg $(RGD)\rgv.rg $(RGD)\rg9.rg
RGSRC2=$(RGD)\rgc.rg $(RGD)\rgp.rg $(RGD)\rgep.rg $(RGD)\rghp.rg
RGSRC3=$(RGD)\egaset.rg $(RGD)\vgaset.rg
RGSRC= $(RGSRC1) $(RGSRC2) $(RGSRC3)
RGLIB=rg.lib

TKD=tek
TEKSRC=$(TKD)\vgtek.tek $(TKD)\tekstor.tek
TEKLIB=tek.lib 

DBD=debug
DEBSRC=$(DBD)\memdebug.deb
DEBLIB=debug.lib
 
# NCSALIBS=$(ENETLIB) $(ENGLIB) $(VSLIB) $(RGLIB) $(TEKLIB) $(DEBLIB)
NCSALIBS=$(ENETLIB) $(ENGLIB) $(VSLIB) $(RGLIB) $(DEBLIB) $(TEKLIB)
# next line is a crock to cover difficient msdos command line length restriction 
# SNCSALIBS=enet engine vs rg tek debug
SNCSALIBS=enet engine vs rg debug tek
 
all:    telbin.exe finger.exe ftpbin.exe setclock.exe rexec.exe minitel.exe lpr.exe

.c.ene: 
        $(CC) $(CFLAGS) $< 
        copy empty.fil $*.ene
        touch $*.ene
        $(LIBP) $(ENETLIB) -+$& 
 
.asm.ene: 
	$(ASM) $<,,$(ASMLIST),nul $(AFLAGS) 
        copy empty.fil $*.ene
        touch $*.ene
        $(LIBP) $(ENETLIB) -+$& 

.c.eng: 
        $(CC) $(CFLAGS) $< 
        copy empty.fil $*.eng
        touch $*.eng
        $(LIBP) $(ENGLIB) -+$& 
 
.asm.eng: 
	$(ASM) $<,,$(ASMLIST),nul $(AFLAGS) 
        copy empty.fil $*.eng
        touch $*.eng
        $(LIBP) $(ENGLIB) -+$& 

.c.vs: 
        $(CC) $(CFLAGS) $< 
        copy empty.fil $*.vs
        touch $*.vs
        $(LIBP) $(VSLIB) -+$& 
 
.asm.vs: 
	$(ASM) $<,,$(ASMLIST),nul $(AFLAGS) 
        copy empty.fil $*.vs
        touch $*.vs
        $(LIBP) $(VSLIB) -+$& 
 
.c.rg: 
        $(CC) $(CFLAGS) $< 
        copy empty.fil $*.rg
        touch $*.rg
        $(LIBP) $(RGLIB) -+$& 
 
.asm.rg: 
	$(ASM) $<,,$(ASMLIST),nul $(AFLAGS) 
        copy empty.fil $*.rg
        touch $*.rg
        $(LIBP) $(RGLIB) -+$& 


.c.tek: 
        $(CC) $(CFLAGS) -Itek $< 
        copy empty.fil $*.tek 
        touch $*.tek 
        $(LIBP) $(TEKLIB) -+$& 
 
.asm.tek: 
	$(ASM) $<,,$(ASMLIST),nul $(AFLAGS) 
        copy empty.fil $*.tek 
        touch $*.tek 
        $(LIBP) $(TEKLIB) -+$& 
 
.c.deb: 
        $(CC) $(CFLAGS) $< 
        copy empty.fil $*.deb
        touch $*.deb
        $(LIBP) $(DEBLIB) -+$& 
 
.asm.deb: 
	$(ASM) $<,,$(ASMLIST),nul $(AFLAGS) 
        copy empty.fil $*.deb
        touch $*.deb
        $(LIBP) $(DEBLIB) -+$& 
 
.c.ext: 
        $(CC) $(CFLAGS) $< 
        copy empty.fil $*.ext
        touch $*.ext

.c.obj: 
	$(CC)  $(CFLAGS) $< 
 
.asm.obj: 
	$(ASM) $<,,$(ASMLIST),nul $(AFLAGS) 


$(ENETLIB) : $(ENETSRC)

$(ENGLIB) : $(ENGSRC)

$(VSLIB) : $(VSSRC)

$(RGLIB) : $(RGSRC)

$(TEKLIB) : $(TEKSRC)

$(DEBLIB) : $(DEBSRC)
 
 
 
telbin.exe :     $(NCSALIBS) engine\look.ext
	$(LNKP) @linktcc.tel
#	tdstrip -s $<

finger.exe :     $(NCSALIBS) finger\finger.ext engine\netutils.ext
	$(LNKP) @linktcc.fin
#	tdstrip -s $<

ftpbin.exe :     $(NCSALIBS) ftp\ftpbin.ext
	$(LNKP) @linktcc.ftp
#	tdstrip -s $<

setclock.exe :    $(NCSALIBS) setclock\setclock.ext engine\netutils.ext
	$(LNKP) @linktcc.scl
#	tdstrip -s $<

rexec.exe :    $(NCSALIBS) rexec\rexec.ext engine\netutils.ext
	$(LNKP) @linktcc.rex
#	tdstrip -s $<

minitel.exe :    $(NCSALIBS) minitel\minitel.ext
	$(LNKP) @linktcc.min
#	tdstrip -s $<

lpr.exe :    $(NCSALIBS) lpr\lp.ext lpr\lpr.ext
	$(LNKP) @linktcc.lpr
#	tdstrip -s $<


clean :
	del $(ENTD)\*.ene
	del $(ENTD)\*.ext
	del $(ENGD)\*.eng
	del $(ENGD)\*.ext
	del $(VSD)\*.vs
	del $(RGD)\*.rg
	del $(TKD)\*.tek
	del $(DBD)\*.deb
	del finger\*.ext
	del ftp\*.ext
	del setclock\*.ext
	del rexec\*.ext
	del minitel\*.ext
	del lpr\*.ext
	del *.lib
	del *.bak
	del *.obj


