//****************************************************************************
//      File:  COOLCOLR.C                                                  
//                                                                         
//   Purpose:  
//                                                                         
// Functions:  
//             
//                                                                         
// Development Team:
//
//       Greg Keyser
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//****************************************************************************

#include <windows.h>
#include <cpl.h>
#include "commdlg.h"
#include "global.h"

LONG FAR PASCAL CPlApplet(HWND, WORD, LONG, LONG);
BOOL FAR PASCAL LibMain(HANDLE, WORD, WORD, LPSTR);

// we put LibMain and CPlApplet functions in the _INIT segment to make
// the LibMain and CPlApplet discardable.

#pragma alloc_text( _INIT, LibMain, CPlApplet )

//****************************************************************************
// Function: SaveToWinIni
//
// Purpose:  To save the new color settings to WIN.INI.  Rather than try to
//           keep track of what's changed and what hasn't, I just get all
//           the current system colors and write them out to WIN.INI.
//           Simplicity prevails in this case.
//
// Parameters: None
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           3/24/92    gak           Created
//****************************************************************************
void FAR PASCAL SaveToWinIni(void)
{
   char  *pszWinStrings[] = {
                         "MenuText",
                         "Menu",
                         "TitleText",
                         "ActiveTitle",
                         "InactiveTitleText",
                         "InactiveTitle",
                         "WindowFrame",
                         "InactiveBorder",
                         "Scrollbar",
                         "WindowText",
                         "Window",
                         "Background",
                         "AppWorkspace",
                         "ActiveBorder",
                         "GrayText",
                         "Hilight",
                         "HilightText",
                         "ButtonHilight",
                         "ButtonShadow",
                         "ButtonText",
                         "ButtonFace"
                        };

   char szColors[]="colors";
   char szBuffer[128];

   BYTE Red, Green, Blue;
   WORD wCtr;

   GetCurrentSysColors();

   for (wCtr=IDC_COLOR_MENUTEXT; wCtr<=IDC_COLOR_BTNFACE; wCtr++)
      {
         Red  =GetRValue(gdwOldSysColors[wCtr]);
         Green=GetGValue(gdwOldSysColors[wCtr]);
         Blue =GetBValue(gdwOldSysColors[wCtr]);
         wsprintf(szBuffer, "%u %u %u", (WORD)(unsigned int)Red,
                  (WORD)(unsigned int)Green, (WORD)(unsigned int)Blue);
         WriteProfileString(szColors, pszWinStrings[wCtr], szBuffer);
      }
   
   return;
}

//****************************************************************************
// Function: GetCurrentSysColors
//
// Purpose:  To initialize a global array that will be used if the user  
//           CANCEL's his changes.
//
// Parameters: None
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           3/23/92    gak           Created
//****************************************************************************
void FAR PASCAL GetCurrentSysColors(void)
{
   WORD wCtr;

   for (wCtr=IDC_COLOR_MENUTEXT; wCtr<=IDC_COLOR_BTNFACE; wCtr++)
      gdwOldSysColors[wCtr]=GetSysColor(giSysColorArea[wCtr]);
     
   return;
}

//****************************************************************************
// Function: InitializeStruct
//
// Purpose:  To initialize a structure for the current common dialog.    
//           This routine is called just before the common dialogs       
//           API is called.                                              
//
// Parameters:
//    wCommDlgType == Indicates the type of common dialog we need to initialize
//    lpStruct     == Long pointer to memory block for the structure
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL InitializeStruct(WORD wCommDlgType, LPSTR lpStruct)
{

   LPCOLORSCHUNK       lpColorsChunk;
   WORD                wCtr;
   HDC                 hDC;
   
   switch (wCommDlgType)
      {
      case IDC_COLORS:

         lpColorsChunk = (LPCOLORSCHUNK)lpStruct;

         hDC = GetDC(ghWnd);
         lpColorsChunk->dwCustClrs[0]=GetBkColor(hDC);
         ReleaseDC(ghWnd, hDC);
 
         for (wCtr=1; wCtr<=15; wCtr++)
            lpColorsChunk->dwCustClrs[wCtr]= lpColorsChunk->dwCustClrs[0];

         lpColorsChunk->chsclr.lStructSize    = sizeof(CHOOSECOLOR);  
         lpColorsChunk->chsclr.hwndOwner      = ghWnd;
         lpColorsChunk->chsclr.hInstance      = ghInst;
//         lpColorsChunk->chsclr.rgbResult      = (DWORD)(lpColorsChunk->dwColor);
         lpColorsChunk->chsclr.rgbResult      = (DWORD)NULL;
         lpColorsChunk->chsclr.lpCustColors   = (LPDWORD)(lpColorsChunk->dwCustClrs);
         lpColorsChunk->chsclr.Flags          = CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN | CC_ENABLETEMPLATE;
         lpColorsChunk->chsclr.lCustData      = 0L;
	      lpColorsChunk->chsclr.lpfnHook       = (FARHOOK)ColorHook;
         lpColorsChunk->chsclr.lpTemplateName = (LPSTR)"ChooseColor";
         break;

      default:

         break;

      }

   return;
}


//****************************************************************************
// Function: AllocAndLockMem
//
// Purpose: To allocate and lock a chunk of memory for the CD structure
//
// Parameters:
//    *hChunk == Pointer to handle of memory that will be allocated
//    wSize   == Size of memory block to allocate
//
// Returns : LPSTR to block of memory allocated
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
LPSTR FAR PASCAL AllocAndLockMem(HANDLE FAR *hChunk, WORD wSize)
{
   LPSTR lpChunk;

   *hChunk = GlobalAlloc(GMEM_FIXED, wSize);

   if (*hChunk)
      {
         lpChunk = GlobalLock(*hChunk);
         if (!lpChunk)
            {
               GlobalFree(*hChunk);
               ReportError(IDC_LOCKFAIL);
               lpChunk=NULL;
            }
      }
   else
      {
         ReportError(IDC_ALLOCFAIL);
         lpChunk=NULL;
      }
   return(lpChunk);
}

//****************************************************************************
// Function: CPlApplet(HWND, WORD, LONG, LONG)
//
// Purpose:  The applets window procedure.  Called by Control Panel.     
//
// Parameters: None
//         hCPlWnd == Handle to Control Panels window
//             Msg == Current message 
//         lParam1 == Varies depending on message 
//         lParam2 == Varies depending on message 
//
// Returns : LONG, dependent on the message being processed.
//
// Comments: This function must be exported so CONTROL.EXE can do a 
//           GetProcAddress() and ultimately send messages to this routine.
//
// History:  Date       Author        Reason
//           3/23/92    gak           Created
//****************************************************************************
LONG FAR PASCAL CPlApplet(HWND hCPlWnd, WORD Msg, LONG lParam1, LONG lParam2)
{

static char *szAppNames[]={"System Color Dropper"};
static char *szDescriptions[]={"Set your system colors the cool way!"};
static int icons[NUM_APPLETS] = { COOLCOLR_ICON };

int          i;
WORD         wSize;
LPNEWCPLINFO lpCPlInfo;

    switch (Msg) {

        case CPL_INIT:

            // first message to CPlApplet(), sent once only -
            // returns a boolean for sucessful initialization

            ghWnd=hCPlWnd;

//Get the current color settings, so we can restore if the user hits Cancel.

            GetCurrentSysColors();

//Now, allocate memory for the CHOOSECOLOR structure

            wSize=sizeof(COLORSCHUNK);

            if (!(glpColorsChunk=(LPCOLORSCHUNK)AllocAndLockMem(&ghColorsChunk, wSize)))
               return (LONG)FALSE;

//And initialize the
            InitializeStruct(IDC_COLORS, (LPSTR)glpColorsChunk);

            return (LONG)TRUE;

        case CPL_GETCOUNT:

            // second message to CPlApplet(), sent once only -
            // return the number of applets supported by this DLL.

            return NUM_APPLETS;
            break;

        case CPL_NEWINQUIRE:

            // third message to CPlApplet() - it is sent as many times
            // as the number of applets returned by CPL_GETCOUNT message

            lpCPlInfo = (LPNEWCPLINFO)lParam2;

            // lParam1 is an index ranging from 0 to (NUM_APPLETS - 1) 

            i = (int)lParam1;

            // your DLL must contain an icon and two string resources -
            // hIcon is the icon handle, szName and szInfo are 
            // strings describing the applets name and description

            lpCPlInfo->dwSize        = (DWORD)sizeof(NEWCPLINFO);
            lpCPlInfo->dwFlags       = (DWORD)NULL;
            lpCPlInfo->dwHelpContext = (DWORD)NULL;
            lpCPlInfo->lData         = NULL;
            lpCPlInfo->hIcon         = LoadIcon(ghInst, MAKEINTRESOURCE(icons[i]));
            lstrcpy(lpCPlInfo->szName, (LPSTR)szAppNames[i]);
            lstrcpy(lpCPlInfo->szInfo, (LPSTR)szDescriptions[i]);
            *(lpCPlInfo->szHelpFile) = NULL;
            
            break;

        case CPL_SELECT:

            // one of your applets has been selected
            // lParam1 is an index from 0 to (NUM_APPLETS - 1)
            // lParam2 is the lData value associated with the applet

            break;

        case CPL_DBLCLK:

            // one of your applets has been double-clicked
            // lParam1 is an index from 0 to (NUM_APPLETS - 1)
            // lParam2 is the lData value associated with the applet

            LaunchApplet();
            break;

        case CPL_STOP:

            // sent once for each applet prior to the CPL_EXIT msg
            // lParam1 is an index from 0 to (NUM_APPLETS - 1)
            // lParam2 is the lData value associated with the applet

            if (glpColorsChunk)  //Clean up memory for colors dialog
               {
                  GlobalUnlock (ghColorsChunk);
                  GlobalFree   (ghColorsChunk);
               }

            break;

        case CPL_EXIT:

            // last message, sent once only, before CONTROL.EXE calls
            // FreeLibrary() on your DLL.

            break;

        default:
            break;
    }

    return 0L;
}

//****************************************************************************
// Function: LibMain(HANDLE, WORD, WORD, LPSTR)
//
// Purpose:  To initialize a global array that will be used if the user  
//           CANCEL's his changes.
//
// Parameters: None
//       hInstance == Handle to this instance
//        wDataSeg == Our data segment
//       wHeapSize == Heap size from the .DEF file
//       lpCmdLine == The command line
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           3/23/92    gak           Created
//****************************************************************************
BOOL FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpCmdLine)
{
    ghInst = hInstance;
    return TRUE;
}

