//****************************************************************************
//      File:  GLOBAL.H                                                    
//                                                                         
//   Purpose:  Define function prototypes, structures and global variables.
//                                                                         
// Development Team:
//
//       Greg Keyser
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//****************************************************************************


/****************************************************************************
*                                                                           *
*                             FUNCTION PROTOTYPES                           *
*                                                                           *
****************************************************************************/

long  FAR PASCAL MainWndProc        (HWND, unsigned, WORD, LONG);
int       PASCAL WinMain            (HANDLE, HANDLE, LPSTR, int);
void  FAR PASCAL ProcessCDError     (DWORD                     );
void  FAR PASCAL ReportError        (WORD                      );
BOOL  FAR PASCAL AboutDlg           (HWND, unsigned, WORD, LONG);
BOOL  FAR PASCAL ColorHook          (HWND, unsigned, WORD, LONG);
int   FAR PASCAL GetUpdateArea      (HWND, BOOL FAR *, LONG, LPSTR, LPSTR,
                                     LONG, HWND);
void  FAR PASCAL LaunchApplet       (void                      );
void  FAR PASCAL SaveToWinIni       (void                      );
void  FAR PASCAL GetCurrentSysColors(void                      );


/****************************************************************************
*                                                                           *
*                             CONSTANTS                                     *
*                                                                           *
****************************************************************************/

#define IDC_COLORS                     1
#define NUM_APPLETS                    1
#define COOLCOLR_ICON                  1
#define IDS_NAME                     100
#define IDS_INFO                     200

#define NUMCOLORSSUPPORTED            21     // Number of different system colors
                                             // this app will let you change.

#define MAXSTRINGDESCLEN              64     // Max length of description string

#define AboutBoxName             "ABOUT"     // Name of About Box in RC file.

//Error constants

#define IDC_ALLOCFAIL                   1
#define IDC_LOCKFAIL                    2
#define IDC_LOADSTRINGFAIL              3

//Color index constants

#define IDC_COLOR_MENUTEXT              0
#define IDC_COLOR_MENU                  1
#define IDC_COLOR_CAPTIONTEXT           2
#define IDC_COLOR_ACTIVECAPTION         3
#define IDC_COLOR_INACTIVECAPTIONTEXT   4
#define IDC_COLOR_INACTIVECAPTION       5
#define IDC_COLOR_WINDOWFRAME           6
#define IDC_COLOR_INACTIVEBORDER        7
#define IDC_COLOR_SCROLLBAR             8
#define IDC_COLOR_WINDOWTEXT            9
#define IDC_COLOR_WINDOW               10
#define IDC_COLOR_BACKGROUND           11
#define IDC_COLOR_APPWORKSPACE         12
#define IDC_COLOR_ACTIVEBORDER         13
#define IDC_COLOR_GRAYTEXT             14
#define IDC_COLOR_HIGHLIGHT            15
#define IDC_COLOR_HIGHLIGHTTEXT        16
#define IDC_COLOR_BTNHIGHLIGHT         17
#define IDC_COLOR_BTNSHADOW            18
#define IDC_COLOR_BTNTEXT              19
#define IDC_COLOR_BTNFACE              20

// String Table Defines

#define IDS_DIALOGFAILURE               1
#define IDS_STRUCTSIZE                  2
#define IDS_INITIALIZATION              3
#define IDS_NOTEMPLATE                  4
#define IDS_NOHINSTANCE                 5
#define IDS_LOADSTRFAILURE              6
#define IDS_FINDRESFAILURE              7
#define IDS_LOADRESFAILURE              8
#define IDS_LOCKRESFAILURE              9
#define IDS_MEMALLOCFAILURE            10
#define IDS_MEMLOCKFAILURE             11
#define IDS_NOHOOK                     12
#define IDS_SETUPFAILURE               13
#define IDS_SUBCLASSFAILURE            14
#define IDS_BUFFERTOOSMALL             16 

#define IDS_COLOR_MENUTEXT             17
#define IDS_COLOR_MENU                 18
#define IDS_COLOR_CAPTIONTEXT          19
#define IDS_COLOR_ACTIVECAPTION        20
#define IDS_COLOR_INACTIVECAPTIONTEXT  21
#define IDS_COLOR_INACTIVECAPTION      22
#define IDS_COLOR_WINDOWFRAME          23
#define IDS_COLOR_INACTIVEBORDER       24
#define IDS_COLOR_SCROLLBAR            25
#define IDS_COLOR_WINDOWTEXT           26
#define IDS_COLOR_WINDOW               27
#define IDS_COLOR_BACKGROUND           28
#define IDS_COLOR_APPWORKSPACE         29
#define IDS_COLOR_ACTIVEBORDER         30
#define IDS_COLOR_GRAYTEXT             31
#define IDS_COLOR_HIGHLIGHT            32
#define IDS_COLOR_HIGHLIGHTTEXT        33
#define IDS_COLOR_BTNHIGHLIGHT         34
#define IDS_COLOR_BTNSHADOW            35
#define IDS_COLOR_BTNTEXT              36
#define IDS_COLOR_BTNFACE              37
#define IDS_NOTHING                    38
#define IDS_SYSTEMCOLORDROPPER         39

#define IDS_PROGTITLE                  40
#define IDS_MAINMENUNAME               41
#define IDS_MAINCLASSNAME              42


/****************************************************************************
*                                                                           *
*                          COLORS STRUCTURE                                 *
*                                                                           *
****************************************************************************/
typedef struct tagCOLORSCHUNK
   {
      CHOOSECOLOR chsclr;
      DWORD dwCustClrs[16];       
   }
COLORSCHUNK;

typedef COLORSCHUNK FAR *LPCOLORSCHUNK; 

typedef WORD (CALLBACK* FARHOOK)(HWND,unsigned,WPARAM,LPARAM);

/****************************************************************************
*                                                                           *
*                          GLOBAL VARIABLES                                 *
*                                                                           *
* Global variables defined in this header.  One .C file (INIT.C) should have*
* IN_INIT #define'd prior to including this header -- it's in that          *
* C module where these variables will reside.                               *
*                                                                           *
****************************************************************************/

#ifdef IN_INIT
#define EXTERN
#define GLOBALCHAR(p1, p2) char p1=p2;
#endif

#ifndef IN_INIT
#define EXTERN extern
#define GLOBALCHAR(p1, p2) char p1; 
#endif

EXTERN HANDLE        ghInst;             // Handle to this instance
EXTERN HWND          ghWnd;              // Handle to main window
EXTERN LPCOLORSCHUNK glpColorsChunk;
EXTERN HANDLE        ghColorsChunk;
EXTERN DWORD         gdwOldSysColors[NUMCOLORSSUPPORTED];
EXTERN BOOL          gbSystemColorHasChanged;

GLOBALCHAR           (gszAppName[],  "Color Dropper");
GLOBALCHAR           (gszMenuName[], "CommonDlgMenu");
GLOBALCHAR           (gszAllocErrorMsg[], "Error Allocating Memory!");
GLOBALCHAR           (gszLockErrorMsg[], "Error Locking Memory!");
GLOBALCHAR           (gszLoadStrFail[], "LoadString failed!");

#ifdef IN_INIT
int giSysColorArea[]={COLOR_MENUTEXT,
                      COLOR_MENU,
                      COLOR_CAPTIONTEXT,
                      COLOR_ACTIVECAPTION,
                      COLOR_INACTIVECAPTIONTEXT,
                      COLOR_INACTIVECAPTION,
                      COLOR_WINDOWFRAME,
                      COLOR_INACTIVEBORDER,
                      COLOR_SCROLLBAR,
                      COLOR_WINDOWTEXT,
                      COLOR_WINDOW,
                      COLOR_BACKGROUND,
                      COLOR_APPWORKSPACE,
                      COLOR_ACTIVEBORDER,
                      COLOR_GRAYTEXT,     
                      COLOR_HIGHLIGHT,    
                      COLOR_HIGHLIGHTTEXT,
                      COLOR_BTNHIGHLIGHT,
                      COLOR_BTNSHADOW,
                      COLOR_BTNTEXT,
                      COLOR_BTNFACE};
#else
int giSysColorArea[];
#endif
              


