'==============================================================================
'=
'= SRCHTST.INC  Copyright (C) 1991-1992 Microsoft Corporation
'=              Portions Copyright 1992, Daniel A. Norton
'=
'==============================================================================

' Search menu items.
Const M_SEARCHMENU = "&Search"
Const M_FIND	   = "&Find..."
Const M_NEXT	   = "&Next"
Const M_PREVIOUS   = "&Previous"
Const M_CHANGE	   = "&Change..."
Const CHANGE_CAPTION = "Change..."

' Items in the Search/Change dialog box.
Const B_CANCEL = "Cancel"
Const B_SKIP   = "&Skip"
Const B_FIND   = "Find"
Const B_CHANGEALL    = "Change &All"  ' B_ buttons.
Const B_CHANGE	     = "&Change"
Const CB_MATCHCASE = "&Match upper/lower case"
Const CB_WHOLEWORD = "&Whole Word"  ' CB_ check boxes.
Const EC_FIND	   = "&Find:"
Const EC_FINDTEXT  = "&Find What:"   ' EC_ edit controls.
Const EC_CHANGETEXT  = "Change &To:"

' Items in the Search/Find dialog box.
Const CB_CASESENSE = "&Case Sensitive"
Const B_NEXT	   = "&Next"
Const B_PREVIOUS   = "&Previous"

' Keys specific to Search.
Const K_SKIP	   = "%s"

Declare Function FindNext(SearchText As String, sMethod As Integer) As Integer
Declare Function FindPrevious(SearchText As String, sMethod As Integer) As Integer
Declare Function SearchChange%(FromText$, ToText$, CaseSense%, WholeWord%, TheButton$)
Declare Function SearchFailed (SearchText$) As Integer
Declare Function SearchFind(Text$, CaseSense%) As Integer

'========================================================================================
'=  Search change invokes the Search..Change menu.
'=     Each parameter corresponds to one of the items in the dialog box.
'=     TheButton should be one of the B_XXX constants above.
'=     If you pass the button B_FIND, this will find the text, but not change
'=     it.  After calling this SUB, the script would have to cause K_ENTER to
'=     be sent for each change that was needed.  To terminate the dialog, send
'=     a K_ESC or call a function to click the Cancel button.
'=
'========================================================================================
Function SearchChange(FromText As String, ToText As String, CaseSense As Integer, WholeWord As Integer, TheButton As String) Static As Integer
   DIM IsChecked As Integer

   WMenu M_SEARCHMENU
   WMenu M_CHANGE       ' Use menus to bring up the dialog box.

   If FromText = "" Then
      DoKeys K_BS        ' Clear the edit field.
   Else
      WEditSetText EC_FINDTEXT, FromText        ' Insert text in the edit field.
   End If

   ' The FromText is in PlayKeys format.  Get the text
   ' as it appears in the edit control.

   DoKeys K_TAB          ' Move on to next field.

   If ToText = "" Then
      DoKeys K_BS        ' Clear the edit field.
   Else
      WEditSetText EC_CHANGETEXT, ToText
   End If

   DoKeys K_TAB

   If WholeWord Then
        WCheckCheck(CB_WHOLEWORD)
   Else
        WCheckUnCheck(CB_WHOLEWORD)
   End If

   IsChecked = WCheckState(CB_MATCHCASE)
   If CaseSense Then	    ' It's not checked and we want it checked.
      WCheckCheck(CB_MATCHCASE)
   Else
      WCheckUnCheck(CB_MATCHCASE)
   End If
   WButtonClick TheButton

   If NOT SearchFailed(FromText) AND (TheButton <> B_CANCEL) Then
     SearchChange = TRUE
   Else
     SearchChange = FALSE
   End If

End Function ' SearchChange()


'========================================================================================
'=
'= SearchFind
'=    If the text is found, SearchFind returns TRUE.
'=    If the text is not found, SearchFind checks for
'=    the resulting dialog box, gets rid of the dialog
'=    box and returns FALSE.
'=
'========================================================================================

Function SearchFind(SearchText As String, CaseSense As Integer) Static As Integer
   DIM SearchTextOut As String

   WMenu M_SEARCHMENU
   WMenu M_FIND       ' Use menus to bring up the dialog box.

   WEditSetText "",SearchText

   IsChecked = WCheckState(CB_CASESENSE)

   If CaseSense Then		  ' Set the case sensitivity.
      WCheckCheck CB_CASESENSE
   Else
      WCheckUnCheck CB_CASESENSE
   End If

   DoKeys K_ENTER  ' Execute the Find.

   ' The SearchText is in PlayKeys format.  Get the text
   ' as it appears in the edit control.

   ' Check for the failure dialog box.
   SearchFind = NOT SearchFailed(SearchText)

End Function


'========================================================================================
'= FindNext
'=   sMethod% is either USE_KEYBOARD or USE_MENU.  Providing  the pattern
'=   is necessary for checking if the pattern was not found.
'=   Returns TRUE if the pattern was found, or FALSE if it failed.
'=
'========================================================================================

Function FindNext(SearchText As String, sMethod As Integer) Static As Integer

    Select Case sMethod
	Case USE_KEYBOARD
            DoKeys K_F3
	Case USE_MENU
            WMenu M_SEARCHMENU
            WMenu M_NEXT
    End Select

   FindNext = NOT SearchFailed(SearchText)

End Function

'========================================================================================
'= FindPrevious
'=   sMethod% is either keyboard or menu.  Providing  the pattern
'=   is necessary for checking if the pattern was not found.
'=   Returns TRUE if the pattern was found, or FALSE if it failed.
'=
'=
'========================================================================================
Function FindPrevious(SearchText As String, sMethod As Integer) Static As Integer
    Select Case sMethod
	Case USE_KEYBOARD
            DoKeys K_F4
	Case USE_MENU
            WMenu M_SEARCHMENU
            WMenu M_PREVIOUS
    End Select

   FindPrevious = NOT SearchFailed(SearchText)

End Function


'========================================================================================
'= SearchFailed
'=     Returns a BOOLEAN indicating if the
'=     SearchFialed dialog box comes up.
'=     It cancels the Search fail dialog if found.
'=     This routine should really only be called by one of the search functions above.
'=
'========================================================================================
Function SearchFailed (SearchText As String) Static As Integer
   ' Check for the failure dialog box.

    hWnd = WFndWndC("Can't find '" + SearchText$ + "'", LABEL_CLASS, FW_NOCASE OR FW_PART)

    If hWnd = 0 Then
	SearchFailed = FALSE
    Else
	SearchFailed = TRUE
	DoKeys K_ESC	   ' Get rid of the dialog box.
    End If

End Function
