'==============================================================================
'=
'= SCRLTST.INC  Copyright (C) 1991-1992 Microsoft Corporation
'=              Portions Copyright 1992, Daniel A. Norton
'=
'=
'=  The scrollbars subs allow scrolling of an Edit window via the windows
'=  scrollbars, instead of the keyboard.  Mouse events are generated on the
'=  appropriate portions of the scrollbars.
'=
'============================================================================

Declare Sub SBInitialize()
Declare Sub SBPageUp(cPages%)
Declare Sub SBPageDown(cPages%)
Declare Sub SBPageLeft(cPages%)
Declare Sub SBPageRight(cPages%)
Declare Sub SBLineUp(cLines%)
Declare Sub SBLineDown(cLines%)
Declare Sub SBCharLeft(cChars%)
Declare Sub SBCharRight(cChars%)
Declare Sub SBThumbUp(inc%)
Declare Sub SBThumbDown(inc%)
Declare Sub SBThumbLeft(inc%)
Declare Sub SBThumbRight(inc%)

Declare Function GetSystemMetrics Lib "User" (index%) As Integer

Const SM_CXHSCROLL = 21
Const SM_CYHSCROLL = 3
Const SM_CXHTHUMB  = 10
Const SM_CXVSCROLL = 2
Const SM_CYVSCROLL = 20
Const SM_CYVTHUMB  = 9

Global cxHorzArrow As Integer
Global cyHorzArrow As Integer
Global cxVertArrow As Integer
Global cyVertArrow As Integer
Global cxHorzThumb As Integer
Global cyVertThumb As Integer
Global lpFeditInfo AS INFO

Sub SBInitialize() Static
    cxHorzArrow = GetSystemMetrics(SM_CXHSCROLL)
    cyHorzArrow = GetSystemMetrics(SM_CYHSCROLL)
    cxVertArrow = GetSystemMetrics(SM_CXVSCROLL)
    cyVertArrow = GetSystemMetrics(SM_CYVSCROLL)
    cxHorzThumb = GetSystemMetrics(SM_CXHTHUMB)
    cyVertThumb = GetSystemMetrics(SM_CYVTHUMB)
End Sub

Sub SBPageUp(cPages%) Static
    WGetInfo 0, lpFeditInfo
    For p = 1 To cPages%
        QueMouseClick 1, lpFeditInfo.wRight - cxVertArrow / 2, lpFeditInfo.wTop + cyVertArrow
    Next p
    QueFlush 1
End Sub

Sub SBPageDown(cPages%) Static
    WGetInfo 0, lpFeditInfo
    For p = 1 To cPages%
        QueMouseClick 1, lpFeditInfo.wRight - cxVertArrow / 2, lpFeditInfo.wBottom - cyHorzArrow - cyVertArrow
    Next p
    QueFlush 1
End Sub

Sub SBPageLeft(cPages%) Static
    WGetInfo 0, lpFeditInfo
    For p = 1 To cPages%
        QueMouseClick 1, lpFeditInfo.wLeft + cxHorzArrow, lpFeditInfo.wBottom - cyHorzArrow / 2
    Next p
    QueFlush 1
End Sub

Sub SBPageRight(cPages%) Static
    WGetInfo 0, lpFeditInfo
    For p = 1 To cPages%
        QueMouseClick 1, lpFeditInfo.wRight - cxVertArrow - cxHorzArrow, lpFeditInfo.wBottom - cyHorzArrow / 2
    Next p
    QueFlush 1
End Sub

Sub SBLineUp(cLines%) Static
    WGetInfo 0, lpFeditInfo
    For l = 1 To cLines%
        QueMouseClick 1, lpFeditInfo.wRight - cxVertArrow / 2, lpFeditInfo.wTop + cyVertArrow / 2
    Next l
    QueFlush 1
End Sub

Sub SBLineDown(cLines%) Static
    WGetInfo 0, lpFeditInfo
    For l= 1 To cLines%
        QueMouseClick 1, lpFeditInfo.wRight - cxVertArrow / 2, lpFeditInfo.wBottom - cyHorzArrow - cyVertArrow / 2
    Next l
    QueFlush 1
End Sub

Sub SBCharLeft(cChars%) Static
    WGetInfo 0, lpFeditInfo
    For c = 1 To cChars%
        QueMouseClick 1, lpFeditInfo.wLeft + cxHorzArrow / 2, lpFeditInfo.wBottom - cyHorzArrow / 2
    Next c
    QueFlush 1
End Sub

Sub SBCharRight(cChars%) Static
    WGetInfo 0, lpFeditInfo
    For c = 1 To cChars%
        QueMouseClick 1, lpFeditInfo.wRight - cxVertArrow - cxHorzArrow / 2, lpFeditInfo.wBottom - cyHorzArrow / 2
    Next c
    QueFlush 1
End Sub

Sub SBThumbUp(inc%) Static
    WGetInfo 0, lpFeditInfo
    x = lpFeditInfo.wRight - cxVertArrow / 2
    y1 = lpFeditInfo.wBottom - cyHorzArrow - cyVertArrow - cyVertThumb / 2
    y2 = lpFeditInfo.wTop + cyVertArrow + cyVertThumb / 2
    QueMouseDn 1, x, y1
    While y1 >= y2
        y1 = y1 - inc
        QueMouseMove x, y1
    WEnd
    QueMouseUp 1, x, y1
    QueFlush 1
End Sub

Sub SBThumbDown(inc%) Static
    WGetInfo 0, lpFeditInfo
    x = lpFeditInfo.wRight - cxVertArrow / 2
    y1 = lpFeditInfo.wTop + cyVertArrow + cyVertThumb / 2
    y2 = lpFeditInfo.wBottom - cyHorzArrow - cyVertArrow - cyVertThumb / 2
    QueMouseDn 1, x, y1
    While y1 <= y2
        y1 = y1 + inc
        QueMouseMove x, y1
    WEnd
    QueMouseUp 1, x, y1
    QueFlush 1
End Sub

Sub SBThumbLeft(inc%) Static
    WGetInfo 0, lpFeditInfo
    x1 = lpFeditInfo.wRight - cxVertArrow - cxHorzArrow - cxHorzThumb / 2
    x2 = lpFeditInfo.wLeft + cxHorzArrow + cxHorzThumb / 2
    y = lpFeditInfo.wBottom - cyHorzArrow / 2
    QueMouseDn 1, x1 , y
    While x1 >= x2
        x1 = x1 - inc
        QueMouseMove x1, y
    WEnd
    QueMouseUp 1, x1, y
    QueFlush 1
End Sub

Sub SBThumbRight(inc%) Static
    WGetInfo 0, lpFeditInfo
    x1 = lpFeditInfo.wLeft + cxHorzArrow + cxHorzThumb / 2
    x2 = lpFeditInfo.wRight - cxVertArrow - cxHorzArrow - cxHorzThumb / 2
    y = lpFeditInfo.wBottom - cyHorzArrow / 2
    QueMouseDn 1, x1, y
    While x1 <= x2
        x1 = x1 + inc
        QueMouseMove x1, y
    WEnd
    QueMouseUp 1, x1, y
    QueFlush 1
End Sub
