'==============================================================================
'=
'= EDITTST.INC  Copyright (C) 1991-1992 Microsoft Corporation
'=              Portions Copyright 1992, Daniel A. Norton
'=
'==============================================================================

' Edit menu items.
Const M_EDITMENU     = "&Edit"
Const M_UNDO	     = "&Undo"
Const M_CUT	     = "Cu&t"
Const M_COPY	     = "&Copy"
Const M_PASTE	     = "&Paste"
Const M_DELETE	     = "&Delete"
Const M_SELECTALL    = "&Select All"
Const M_GOTO	     = "&Go To..."

Declare Sub UndoEdit   (sMethod%)
Declare Sub CutText    (sMethod%)
Declare Sub CopyText   (sMethod%)
Declare Sub PasteText  (sMethod%)
Declare Sub DeleteText (sMethod%)
Declare Sub SelectAll  (sMethod%)
Declare Sub EditGoto   (sMethod%, lineNum&)

Declare Sub ClearWindow()
Declare Sub SelectCurrentLine()
Declare Sub SelectFirstChar()
Declare Sub SelectLastChar()
Declare Sub SelectLines(sLines%)
Declare Sub SelectChars(sChars%)
Declare Sub MoveToLine(sLine%)
Declare Sub MoveToChar(sChar%)

'-----------------------------------------------------------------------
' UndoEdit:
'-----------------------------------------------------------------------
Sub UndoEdit(sMethod%) Static
    MenuCommand sMethod, M_EDITMENU, M_UNDO, K_ALT+K_BS
End Sub

'-----------------------------------------------------------------------
' CutText:
'-----------------------------------------------------------------------
Sub CutText(sMethod%) Static
    MenuCommand sMethod, M_EDITMENU, M_CUT, K_SHIFT+K_DELETE
End Sub

'-----------------------------------------------------------------------
' CopyText:
'-----------------------------------------------------------------------
Sub CopyText(sMethod%) Static
    MenuCommand sMethod, M_EDITMENU, M_COPY, K_CTRL+K_INSERT
End Sub

'-----------------------------------------------------------------------
' PasteText:
'-----------------------------------------------------------------------
Sub PasteText(sMethod%) Static
    MenuCommand sMethod, M_EDITMENU, M_PASTE, K_SHIFT+K_INSERT
End Sub

'-----------------------------------------------------------------------
' DeleteText:
'-----------------------------------------------------------------------
Sub DeleteText(sMethod%)  Static
    MenuCommand sMethod, M_EDITMENU, M_DELETE, K_DELETE
End Sub

'-----------------------------------------------------------------------
' SelectAll:
'-----------------------------------------------------------------------
Sub SelectAll(sMethod%)  Static
    MenuCommand sMethod, M_EDITMENU, M_SELECTALL, K_CTRL+K_HOME+K_CTRL+K_SHIFT+K_END
End Sub

'-----------------------------------------------------------------------
' EditGoto:
'-----------------------------------------------------------------------
Sub EditGoto(sMethod%, lineNum&)  Static
    MenuCommand sMethod, M_EDITMENU, M_GOTO, "%EG"
    DoKeys LTrim$(Str$(lineNum)) + K_ENTER
End Sub

'-----------------------------------------------------------------------
' ClearWindow:
'-----------------------------------------------------------------------
Sub ClearWindow()  Static
    DoKeys K_CTRL + K_HOME + K_CTRL + K_SHIFT + K_END + K_DELETE
End Sub

'-----------------------------------------------------------------------
' SelectCurrentLine:
'-----------------------------------------------------------------------
Sub SelectCurrentLine() Static
    DoKeys K_END + K_HOME + K_HOME + K_SHIFT + K_END
End Sub

'-----------------------------------------------------------------------
' SelectFirstChar:
'-----------------------------------------------------------------------
Sub SelectFirstChar() Static
    DoKeys K_END + K_HOME + K_SHIFT + K_RIGHT
End Sub

'-----------------------------------------------------------------------
' SelectLastChar:
'-----------------------------------------------------------------------
Sub SelectLastChar() Static
    DoKeys K_END + K_SHIFT + K_LEFT
End Sub

'-----------------------------------------------------------------------
' SelectLines:
'-----------------------------------------------------------------------
Sub SelectLines(sLines%) Static
    DoKeys K_SHIFT + "{DOWN" + Str$(sLines) + "}"
End Sub

'-----------------------------------------------------------------------
' SelectChars:
'-----------------------------------------------------------------------
Sub SelectChars(sChars%) Static
    DoKeys K_SHIFT + "{RIGHT" + Str$(sChars) + "}"
End Sub

'-----------------------------------------------------------------------
' MoveToLine:
'-----------------------------------------------------------------------
Sub MoveToLine(sLine%) Static
Dim stDown As String
    stDown = "{DOWN" + Str$(sLine - 1) + "}"
    DoKeys K_CTRL + K_HOME + stDown
End Sub

'-----------------------------------------------------------------------
' MoveToChar:
'-----------------------------------------------------------------------
Sub MoveToChar(sChar%) Static
Dim stRight As String
    stRight = "{RIGHT" + Str$(sChar - 1) + "}"
    DoKeys K_END + K_HOME + K_HOME + stRight
End Sub
