/***************************************************************************
 *  DATASRV.C								   *
 *	This file contains following NetBIOS Datagram Service related	   *
 *	functions							   *
 *									   *
 *	  SendDatagram	 () :- Sends datagram to a specific name	   *
 *	  ReceiveDatagram() :- Receives datagram name sent to specific	   *
 *			       name.
 *									   *
 *  History:	Alok Sinha  October, 1991    Created			   *
 *									   *
 ***********************************************************************/

// Include files
#include <ncb.h>
#include <common.h>
#include <namesrv.h>
#include <memory.h>
#include <string.h>


/*
 * FUNCTION    :: SendDatagram()
 * PARAMETERS  ::
 *	 [in]  pchName	  :- 16 byte unique or global name pointer
 *	 [in]  ucLana	  :- Lan Adaptor number
 *	 [in]  ucNameNum  :- Name Number associated with Name.
 *	 [in]  pchData	  :- pointer to a data buffer to send
 *	 [in]  usDataLen  :- data buffer length.
 *
 * RETURN VALUE:
 *	    NO_ERROR if no errors were encountered, else error returned from
 *	    NetBIOS call in Retcode field.
 */

unsigned char	SendDatagram( char *pchName ,
			      unsigned char ucLana,
			      unsigned char ucNameNum,
			      char far * pchData,
			      unsigned short usDataLen
			   )
{
    NCB Ncb;
    unsigned char ucRc;

    /* First clear out the buffer */
    ClearNcb ( &Ncb);

    /*	Set the Command 	 */
    Ncb.ncb_command = NCBDGSEND;

    /* set the LAN Adaptor number */
    Ncb.ncb_lana_num = ucLana;

    /* set the Name Number */
    Ncb.ncb_num = ucNameNum;

    /* Set  Data buffer pointer and it's length */
    Ncb.ncb_buffer = pchData;
    Ncb.ncb_length = usDataLen;

    /* set the remote name	*/
    memcpy ( Ncb.ncb_callname, pchName,	NCBNAMSZ);

    /* Make the OS dependent NetBIOS call */
    if ((ucRc=NetBiosRequest ( &Ncb))!= NO_ERROR)
	return ucRc ;

    return Ncb.ncb_retcode;

}


/*
 * FUNCTION    :: ReceiveDatagram()
 * PARAMETERS  ::
 *	 [in]  ucLana	  :- Lan Adaptor number
 *	 [in]  ucNameNum  :- Name Number associated with Name.
 *	 [in]  pchData	  :- pointer to a data buffer to send
 *	 [in/out]pusDataLen  :- This is set to data buffer length when
 *			    called by application. And it is set by
 *			    to data buffer size actually received, if call
 *			    completes successfully.
 *
 * RETURN VALUE:
 *	    NO_ERROR if no errors were encountered, else error returned from
 *	    NetBIOS call in Retcode field.
 */

unsigned char	ReceiveDatagram(unsigned char ucLana,
				unsigned char ucNameNum,
				char far * pchData,
				unsigned short *pusDataLen
			      )
{
    NCB Ncb;
    unsigned char ucRc;

    /* First clear out the buffer */
    ClearNcb ( &Ncb);

    /*	Set the Command 	 */
    Ncb.ncb_command = NCBDGRECV;

    /* set the LAN Adaptor number */
    Ncb.ncb_lana_num = ucLana;

    /* set the Name Number */
    Ncb.ncb_num = ucNameNum;

    /* Set  Data buffer pointer and it's length */
    Ncb.ncb_buffer = pchData;
    Ncb.ncb_length = *pusDataLen;

    /* Make the OS dependent NetBIOS call */
    if ((ucRc=NetBiosRequest ( &Ncb))!= NO_ERROR)
	return ucRc ;

    /* return actual size of data buffer if call was successful */
    if (Ncb.ncb_retcode == NO_ERROR)
	*pusDataLen = Ncb.ncb_length;

    return Ncb.ncb_retcode;

}
