//***************************************************************************
// MCURSOR demonstrates the interaction between the mouse graphics cursor
// screen mask and cursor mask in 640 by 480 16-color VGA graphics mode.
//***************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <graph.h>
#include <dos.h>

union REGS inregs, outregs;
struct SREGS segregs;

unsigned int mask[] = {
     0x0000,           // 0000000000000000  Screen Mask
     0x8001,           // 1000000000000001
     0xC003,           // 1100000000000011
     0xE007,           // 1110000000000111
     0xF00F,           // 1111000000001111
     0xF81F,           // 1111100000011111
     0xFC3F,           // 1111110000111111
     0xFE7F,           // 1111111001111111
     0xFC3F,           // 1111110000111111
     0xF81F,           // 1111100000011111
     0xF00F,           // 1111000000001111
     0xE007,           // 1110000000000111
     0xC003,           // 1100000000000011
     0x8001,           // 1000000000000001
     0x0000,           // 0000000000000000
     0xFFFF,           // 1111111111111111

     0x0000,           // 0000000000000000  Cursor Mask
     0x3FFC,           // 0011111111111100
     0x1FF8,           // 0001111111111000
     0x0FF0,           // 0000111111110000
     0x07E0,           // 0000011111100000
     0x03C0,           // 0000001111000000
     0x0180,           // 0000000110000000
     0x0000,           // 0000000000000000
     0x0180,           // 0000000110000000
     0x03C0,           // 0000001111000000
     0x07E0,           // 0000011111100000
     0x0FF0,           // 0000111111110000
     0x1FF8,           // 0001111111111000
     0x3FFC,           // 0011111111111100
     0x0000,           // 0000000000000000
     0x0000            // 0000000000000000
};

char fillmask[] = { 0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F };

void main (void)
{
     // Switch to 640 x 480 16-color graphics
     if (!_setvideomode(_VRES16COLOR)) {
           printf("VGA graphics not supported\n");
           exit;
     }

     // Clear the screen
     _setcolor(3);
     _rectangle(_GFILLINTERIOR, 0, 0, 639, 479);
     _setfillmask(fillmask);
     _setcolor(4);
     _floodfill(0, 0, 7);

     // Define the graphics cursor
     inregs.x.ax = 9;
     inregs.x.bx = 0;
     inregs.x.cx = 0;
     inregs.x.dx = (int) mask;
     segread(&segregs);
     segregs.es = segregs.ds;
     int86x(0x33, &inregs, &outregs, &segregs);

     // Display the graphics cursor
     inregs.x.ax = 1;
     int86x(0x33, &inregs, &outregs, &segregs);

     // Wait for a keypress and exit
     getch();
     _setvideomode(_TEXTC80);
}
