/*
 * WMF Import Filter - MAIN MODULE
 *
 * LANGUAGE      : Microsoft C6.0
 * MODEL         : medium
 * ENVIRONMENT   : Microsoft Windows 3.0 SDK
 * STATUS        : operational
 *
 * This module defines all the import filter entry points, including
 * the one that initializes the library itself.
 *
 *    Eikon Systems, Inc.
 *    989 East Hillsdale Blvd, Suite 260
 *    Foster City, California 94404
 *    415-349-4664
 *
 * 08/01/91 1.00 - David E. West - initial creation.
 * 09/01/91 1.01 - Kevin P. Welch - minor revisions.
 *
 */

#define NOCOMM

#include <windows.h>
#include <stdio.h>
#include <dos.h>
#include "wmf.h"

/* global variables */
HANDLE		hinstWMF;

/**/

/*
 * LibMain( hinst, wDataSegment, wHeapSize, lpszCmdLine ) : BOOL;
 *
 *    hinst          handle to dll instance
 *		wDataSegment   current data segment	
 *		cbHeap         desired heap size
 *		lpszCmdLine    long pointer to command line
 *
 * This function is responsible for initializing the WMF import filter
 * library and saving the DLL instance handle.
 *
 * The function always returns TRUE, since initialization never fails.
 *
 */

BOOL FAR PASCAL LibMain(
	HANDLE			hinst,
	WORD				wDataSegment,
	WORD				cbHeap,
	LPSTR				lpszCmdLine )
{
	extern HANDLE	hinstWMF;

	/* warning level 3 compatibility */
	wDataSegment;
	cbHeap;
	lpszCmdLine;

	/* save library instance handle */
	hinstWMF = hinst;

	/* return final result */
	return TRUE;
}

/**/

/*
 * GetFilterInfo( idVersion, lpszIni, lphPrefMem, lphFileTypes ) : WORD
 *
 *    idVersion      source program version number
 *    lpszIni        pointer to optional part of WIN.INI file entry
 *    lphPrefMem     pointer to preferences memory handle
 *    lphFileTypes   pointer to filetypes handle
 *
 * This function returns information about this filter.  It is called once
 * just before the filter is to be used the first time.  The wVersion
 * parameter enables the filter to modify it's behavior depending on the
 * interface.  The preferences memory block may contain information about
 * how the filter should operate.
 *
 * The return value of this function defines the type of import filter
 * this is.  The following types are defined:
 *
 *    0 = error
 *    1 = text filter
 *    2 = graphics filter
 *
 */

WORD FAR PASCAL GetFilterInfo( 
	WORD				idVersion,
	LPSTR				lpszIni,
	HANDLE FAR *	lphPrefMem,
	HANDLE FAR *	lphFileTypes )
{
	/* warning level 3 compatibility */
	idVersion;
	lpszIni;
	lphPrefMem;
	lphFileTypes;

	/* return graphics filter type */
	return 2;
}

/**/

/*
 * GetFilterPref( hinst, hwndParent, hPrefMem, wFlags ) : VOID;
 *
 *    hinst          handle to source application instance
 *    hwndParent     parent window for any dialog boxes required
 *    hPrefMem       handle to preferences memory block
 *    wFlags         indicators of PageMaker/PowerPoint context
 *
 * This function can be used by the host application to retrieve
 * and define various filter preferences.  In this instance no
 * action will be performed.
 *
 */

VOID FAR PASCAL GetFilterPref( 
	HANDLE			hinst,
	HWND				hwndParent,
	HANDLE			hPrefMem,
	WORD				wFlags )
{
	/* warning level 3 compatibility */
	hinst;
	hwndParent;
	hPrefMem;
	wFlags;
}

/**/

/*
 * ImportGr( hdcPrint, lpfs, lppi, hPrefMem ) : WORD;
 *
 *    hdcPrint       handle to display context
 *    lpfs           FILESPEC structure for graphics file to import
 *    lppi           PICTINFO structure for metafile created by filter
 *    hPrefMem       handle to preferences memory
 *
 * This function peforms the import of a particular graphics file
 * and generates a metafile.  If an error occurs, the appropriate
 * return code is returned.
 *
 */

WORD FAR PASCAL ImportGr(
	HDC         	hdcPrint,
	LPFILESPEC  	lpfsSrc,
	LPPICTINFO    	lppi,
	HANDLE      	hPrefMem )
{
	INT				hfSrc;					/* handle to source file */
	WORD				idErr;					/* error code to return */
	WORD				cbRead;					/* bytes read */
	HANDLE			hwmf;						/* handle to WMF header block */
	HCURSOR			hcsrOld;					/* handle to old cursor */
	LPWMFHEADER		lpwmf;					/* long pointer to WMF header */
	OFSTRUCT			ofSrc;					/* open file structure */

	/* for warning level 3 compatibility */
	hPrefMem;
	hdcPrint;

	/* initialization */
	idErr = SUCCESS;

	/* validate parameters */
	if (lpfsSrc && lppi)
	{
		/* open source WMF file */
		hfSrc = OpenFile( lpfsSrc->fullName, &ofSrc, OF_READ );
		if (hfSrc != -1)
		{
			/* set wait cursor */
			hcsrOld = SetCursor( LoadCursor(NULL,IDC_WAIT) );
			ShowCursor( TRUE );

			/* allocate memory for WMF header */
			hwmf = GlobalAlloc( GHND, (LONG)sizeof(WMFHEADER) );
			lpwmf = hwmf ? (LPWMFHEADER)GlobalLock(hwmf) : NULL;
			if (lpwmf)
			{
				LONG		offEof;				/* end of file */

				/* get end of file */
				offEof = _llseek( hfSrc, 0L, SEEK_END );
				_llseek( hfSrc, 0L, SEEK_SET );

				/* read WMF header */
				cbRead = _lread( hfSrc, (LPSTR)lpwmf, sizeof(WMFHEADER) );
				if (cbRead == sizeof(WMFHEADER))
				{
					/* validate WMF file */
					if (ValidateWMF(lpwmf))
					{
						/* initialize WMF bounding box */
						CopyRect( &(lppi->bbox), &(lpwmf->bbox) );
						lppi->inch = lpwmf->cInch;

						/* append WMF bits */
						idErr = GetWMFBits(
							&(lppi->hmf),
							offEof - sizeof(WMFHEADER),
							hfSrc
						);
					}
					else
						idErr = IE_NOT_MY_FILE;
				}
				else
					idErr = IE_BAD_FILE_DATA;

				/* unlock WMF header */
				GlobalUnlock( hwmf );
			}
			else
				idErr = IE_MEM_FULL;

			/* free memory for WMF header */
			if (hwmf)
				GlobalFree( hwmf );

			/* close file */
			_lclose( hfSrc );

			/* restore previous cursor*/
			ShowCursor( FALSE );
			SetCursor( hcsrOld );
		}
		else
			idErr = FAILURE;
	}
	else
		idErr = FAILURE;

	/* return error code */
	return idErr;
}

/**/

/*
 * WEP( wValue ) : WORD;
 *
 *		wValue		system exit value
 *
 * This function is called when the DLL is unloaded by the system.
 * It enables the library to perform any cleanup necessary.
 *
 */

WORD FAR PASCAL WEP(
	WORD		wValue )
{
	WORD		wResult;

	/* process exit value */
	switch( wValue )
		{
	case WEP_FREE_DLL : /* DLL is being released */
	case WEP_SYSTEM_EXIT : /* system is being shut down */
	default :
		wResult = 1;
		break;
	}

	/* return result */
	return wResult;

}
