/*----------------------------------------------------------------------------
 *
 *  Sample code on how to use the new GetLowTickCount().
 *
 *  To use:  "cl -c -Gs -W4 timer.c"
 *           "masm /D?WIN=0 tick.asm;"
 *           "link timer tick;"
 *
 *--------------------------------------------------------------------------*/

#include <stdio.h>

/*--- Prototype the new tick count function ---*/
unsigned long far pascal GetLowTickCount( void );

unsigned long SyncTime( void );

void main()
{
    unsigned long dwTick;               /*  returned tick count  */
    long lTimesSec;                     /*  counts calls/sec     */
    long loop;                          /*  misc looping var     */

    /*--- How many GetLowTickCount() calls can be made in one second ---*/
    lTimesSec = 0;
    dwTick = SyncTime();
    while (GetLowTickCount()<(dwTick+1000)) {
        ++lTimesSec;
        }
    printf( "Number of GetLowTickCount() calls/sec = %ld\n", lTimesSec );

    /*--- Time 100,000 long multiplies ---*/
    dwTick = SyncTime();
    for (loop=0; loop<100000; ++loop) {
        long l = loop*12345;
        }
    dwTick = GetLowTickCount()-dwTick;
    printf( "100000 long multiplies = %lu\n", dwTick );

} /* main */

unsigned long SyncTime()
{
    unsigned long dw1, dw2;

    /*--- Wait for a millisecond boundary ---*/
    dw1 = GetLowTickCount();
    while (dw1==(dw2=GetLowTickCount()))
        ;
    return (dw2);

} /* SyncTime */
