/* PCX2DIB.C - Displays a PCX file in Windows 3.0 as a Device-Independent
Bitmap.  Usage:     win pcx2dib <filename>                              */
/* Author: C. Albert Mirho */

#include <stdlib.h>
#include <windows.h>
#include "pcx2dib.h"

HANDLE hInst;                      // Handle to instance.
HANDLE GhInst;                     // Global Handle to instance.
HWND MainhWnd;                     // Handle to main window.
HDC hMainDC;                       //Handle to display context of main window
char szScreenFile[_MAX_PATH+1];

/* Registers the window class */
BOOL BLDInitClass(hInstance)
HANDLE hInstance;
{
WNDCLASS WndClass;

/* Fill in the class structure */
    WndClass.style         = 0;
    WndClass.lpfnWndProc   = Pcx2DibWndProc;
    WndClass.cbClsExtra    = 0;
    WndClass.cbWndExtra    = 0;
    WndClass.hInstance     = hInstance;
    WndClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
    WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
    WndClass.hbrBackground = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
    WndClass.lpszMenuName  = NULL;
    WndClass.lpszClassName = "PCX2DIB";

    return RegisterClass(&WndClass);
}

/* Create the main window */
HWND BLDInitMainWindow(hInstance)
HANDLE hInstance;
{
HWND hWnd;                  /* window handle                       */
int coordinate[4];          /* Coordinates of main window          */

    coordinate[0]=CW_USEDEFAULT;
    coordinate[1]=0;
    coordinate[2]=CW_USEDEFAULT;
    coordinate[3]=0;

    hWnd = CreateWindow("PCX2DIB",  /* window class registered earlier  */
           "PCX - DIB Example - Resize the Window!",   /* window caption  */
           WS_OVERLAPPEDWINDOW|WS_THICKFRAME,          /* window style    */
           coordinate[0],          /* x position            */
           coordinate[1],          /* y position            */
           coordinate[2],          /* width                 */
           coordinate[3],          /* height                */
           0,                      /* parent handle         */
           0,                      /* menu or child ID      */
           hInstance,              /* instance              */
           (LPSTR)NULL);           /* additional info       */

    return hWnd;
}


/* Startup code called when application is first run */
int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;                 /* current instance                    */
HANDLE hPrevInstance;             /* previous instance                   */
LPSTR lpCmdLine;                  /* command line                        */
int nCmdShow;                     /* show-window type (open/icon)        */
{
MSG msg;                      /* message                             */

    hInst = GhInst = hInstance;            /* Saves the current instance               */

    if (!hPrevInstance)        /* Is there an other instance of the task   */
        {
        if (!BLDInitClass(hInstance))
            return FALSE;     /* Exits if unable to initialize            */
        }
    /* Check to insure file name was no omitted */
    if (lpCmdLine[0]==0)
    {
        return FALSE;
    } //End if (no file specified)
    lstrcpy ( (LPSTR) szScreenFile, lpCmdLine);

    MainhWnd = BLDInitMainWindow(hInstance);
    if (!MainhWnd)           /* Check if the window is created           */
        return FALSE;

    ShowWindow(MainhWnd, nCmdShow); /* Show the window                     */
    UpdateWindow(MainhWnd);         /* Send WM_PAINT message to window     */

    while (GetMessage(&msg,     /* message structure                        */
        0,                      /* handle of window receiving the message   */
        0,                      /* lowest message to examine                */
        0))                     /* highest message to examine               */
        {
        TranslateMessage(&msg);  /* Translates character keys                */
        DispatchMessage(&msg);   /* Dispatches message to window             */
        }
    return(msg.wParam);          /* Returns the value from PostQuitMessage   */
}

/* This procedure displays the PCX file as a DIB  */
/* It re-displays the PCX file every time the WIndow is resized  */
/* or overlapped by another window, by processing the WM_PAINT message */

long FAR PASCAL Pcx2DibWndProc(hWnd, message, wParam, lParam)
HWND hWnd;                       /* window handle                            */
unsigned message;                /* type of message                          */
WORD wParam;                     /* additional information                   */
LONG lParam;                     /* additional information                   */
{
PAINTSTRUCT psPS;                           //Paint structure
HDC hDC;                                    //Handle to display context
HCURSOR hOldCursor;                         //Handle to default cursor


    switch (message)
    {
    case WM_COMMAND:             /* command from application menu     */
        break;
    case WM_SIZE:
/* Mark the entire client area for erasure, when beginpaint is next called */
        InvalidateRect (hWnd, NULL, TRUE);
        break;
    case WM_PAINT:
/* Re-display the PCX file upon receiving a WM_PAINT message */
        hOldCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
        hMainDC = BeginPaint(hWnd, &psPS);
        iDisplayPCXFile (szScreenFile);
        EndPaint (hWnd, &psPS);
        SetCursor(hOldCursor);
        break;
    case WM_CREATE:          /* window being created                      */
        break;
    case WM_DESTROY:         /* window being destroyed                   */
        PostQuitMessage(0);
        break;
    default:
        /* Pass on message for default processing */
        return(DefWindowProc(hWnd, message, wParam, lParam));
    }  //End switch (on message)
    return FALSE;        /* Returns FALSE if processed by this WndProc*/
}

                                                                