/* Functions for displaying 16 color VGA PCX files in Windows 3.0
as Device Independent Bitmaps                                  */
/* Author: C. Albert Mirho */

#include <string.h>
#include <dos.h>
#include <stdio.h>
#include <io.h>


#include <WINDOWS.H>
#include "file.h"

//If defined, use logical palette to display DIB
#undef  LOGICAL_PALETTE


#define BAD_OPEN                          -1   //Could not open file
#define BAD_IMAGE                         -2   //Not a valid image file
#define NO_MEMORY                         -3   //Not enough memory
#define BAD_CMDFILE                       -4   //Bad command file
#define BAD_WIPE                          -5   //Bad wipe

HANDLE iInitColorDIB();
BYTE huge *pbBigBuf;
extern HWND MainhWnd;                 // Handle to main window.
extern HWND GhInst;                   // Handle to program instance
extern HDC  hMainDC;                  //Handle to main window display context

#define   DIB_WIDTH()     (pcxHead.iX2-pcxHead.iX1 +1)
#define   DIB_HEIGHT()    (pcxHead.iY2-pcxHead.iY1 +1)
#define   DIB_BITPERPIX() (pcxHead.bBitPix*pcxHead.bNplanes)
#define   DIB_BYTESPERSCANLINE() (pcxHead.iBytesPerBitPlane*pcxHead.bNplanes)
#define   DIB_SIZE()      ((DWORD)((DIB_BYTESPERSCANLINE()+3)&0xFFFC) *\
                           (DWORD)DIB_HEIGHT())
#define   DIB_NUMCOLORS() (1<< DIB_BITPERPIX())

/* Intrinsic Windows 3.0 system palette */
static RGBQUAD aRGBSystemPalette[]=
    {
       { 0x00, 0x00, 0x00, 0},
       { 0x80, 0x00, 0x00, 0},
       { 0x00, 0x80, 0x00, 0},
       { 0x80, 0x80, 0x00, 0},
       { 0x00, 0x00, 0x80, 0},
       { 0x80, 0x00, 0x80, 0},
       { 0x00, 0x80, 0x80, 0},
       { 0x80, 0x80, 0x80, 0},
       { 0xC0, 0xC0, 0xC0, 0},
       { 0xFF, 0x00, 0x00, 0},
       { 0x00, 0xFF, 0x00, 0},
       { 0xFF, 0xFF, 0x00, 0},
       { 0x00, 0x00, 0xFF, 0},
       { 0xFF, 0x00, 0xFF, 0},
       { 0x00, 0xFF, 0xFF, 0},
       { 0xFF, 0xFF, 0xFF, 0},
       { 0xFF, 0xFF, 0xFF, 0}
    };

SHORTPCXHEAD pcxHead;            //Holds the PCX header
BITMAPINFO *BitInfo;             //Pointer to DIB descriptor
HANDLE hPalMem;                  //Handle to palette memory block

 HANDLE iInitColorDIB()
 {
 HANDLE hBitInfo;
 BITMAPINFO  *BitInfo;
 int i, k;

// Allocate enough space for BITMAPINFO structure with
// proper sized color table
   hBitInfo = LocalAlloc (GMEM_MOVEABLE, sizeof(BITMAPINFO)+
                 ((DIB_NUMCOLORS()-1)*sizeof(RGBQUAD)));
   BitInfo = (BITMAPINFO *) LocalLock (hBitInfo);

// Size of the header
   BitInfo->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
// DIB width in pixels
   BitInfo->bmiHeader.biWidth = DIB_WIDTH();
// DIB height in scanlines
   BitInfo->bmiHeader.biHeight = DIB_HEIGHT();
// DIB planes (always 1)
   BitInfo->bmiHeader.biPlanes = 1;
// Bits per pixel
   BitInfo->bmiHeader.biBitCount = DIB_BITPERPIX();
// Type of compression used (BI_RGB = no compression)
   BitInfo->bmiHeader.biCompression = BI_RGB;
// DIB size in bytes
   BitInfo->bmiHeader.biSizeImage = DIB_SIZE();
// The next two fields aren't used.
   BitInfo->bmiHeader.biXPelsPerMeter = 0;
   BitInfo->bmiHeader.biYPelsPerMeter = 0;
// Colors in color table used by DIB
   BitInfo->bmiHeader.biClrUsed = 0;
// Number of important colors in color table
   BitInfo->bmiHeader.biClrImportant = 0;

// Now fill in the DIB color table
   for (i=0, k=0; k<DIB_NUMCOLORS();k++, i+=3)
   {
       BitInfo->bmiColors[k].rgbRed =   pcxHead.abPal[i];
       BitInfo->bmiColors[k].rgbGreen = pcxHead.abPal[i+1];
       BitInfo->bmiColors[k].rgbBlue =  pcxHead.abPal[i+2];
       BitInfo->bmiColors[k].rgbReserved =   0;
   }  //End for (each entry in the bitmap color table)

// If this is a version 3 PCX file, then use the intrinsic system colors
// and ignore the meaningless color table
   if (pcxHead.bHver == 3)
   {
       memcpy ((PSTR) &BitInfo->bmiColors[0], (PSTR) &aRGBSystemPalette[0],
                DIB_NUMCOLORS()*sizeof(RGBQUAD));
   }  //End if (PCX file w/o palette information)

#ifdef LOGICAL_PALETTE
   {
   int *piColorIndex;
   LOGPALETTE *pPal;

   hPalMem = LocalAlloc (LMEM_MOVEABLE, sizeof(LOGPALETTE) +
       ( DIB_NUMCOLORS() - 1)*sizeof(PALETTEENTRY));
   pPal = (LOGPALETTE *) LocalLock (hPalMem);

   piColorIndex = (int *) &(BitInfo->bmiColors[0]);
   for (i=0, k=0; k<DIB_NUMCOLORS();k++, i+=3)
   {
       if (pcxHead.bHver != 3)
       {
           pPal->palPalEntry[k].peRed   =  pcxHead.abPal[i];
           pPal->palPalEntry[k].peGreen =  pcxHead.abPal[i+1];
           pPal->palPalEntry[k].peBlue  =  pcxHead.abPal[i+2];
           pPal->palPalEntry[k].peFlags = 0;
       }  //End if (palette info in color table)
       else
       {
           pPal->palPalEntry[k].peRed   =  aRGBSystemPalette[k].rgbRed;
           pPal->palPalEntry[k].peGreen =  aRGBSystemPalette[k].rgbGreen;
           pPal->palPalEntry[k].peBlue  =  aRGBSystemPalette[k].rgbBlue;
           pPal->palPalEntry[k].peFlags = 0;
       }  //End if (no palette info in color table)
       *(piColorIndex + k) = k;
   } //End for (each color in the bitmap color table)

   pPal->palVersion = 0x300;              //Win. 3.0 palette
   pPal->palNumEntries = DIB_NUMCOLORS(); //Number of colors
                                          //in logical palette
   LocalUnlock (hPalMem);
   }
#endif

   LocalUnlock (hBitInfo);
   return (hBitInfo);

 } //End function (initColorDIB)

 int iUncompressWord(BYTE *bValue, BYTE *bRepeatCnt, HANDLE hPCXfile)
 {
 #define READSZ                4000
 int i;
 static int SiReadCnt=0;
 static int SiCnt=0;
 static BYTE abBuffer[READSZ];

         *bRepeatCnt = 1;
     //  Time to do another block read?
         if (SiCnt == SiReadCnt)
         {
         //  Reset block byte counter
             SiCnt = 0;
         //  Read a block of data from the PCX file
             if((SiReadCnt= _lread(hPCXfile, (LPSTR) &abBuffer[0],
                                   READSZ))<= 0)
             {
             //  Reset read counter
                 SiReadCnt=0;
                 return(-1);
             } //End if (end of file)
         } //End if (time to do another block read)
         //  Get next byte
         i = abBuffer[SiCnt];
         //  Bump byte counter
         SiCnt++;
         //  Is it a repeat count byte?
         if(0xc0 == (0xc0&i))
         {
         //  Mask out the repeat count
             *bRepeatCnt = 0x3f&i;
         //  Time to do another block read?
             if (SiCnt == SiReadCnt)
             {
             //  Reset block byte counter
                 SiCnt = 0;
             //  Read a block of data from the PCX file
                 if((SiReadCnt= _lread(hPCXfile, (LPSTR) &abBuffer[0],
                                       READSZ))<= 0)
                 {
                 //  Reset read counter
                     SiReadCnt=0;
                     return(-1);
                 } //End if (end of file)
             } //End if (time to do another block read)
         //  Get next byte
             i = abBuffer[SiCnt];
         //  Bump byte counter
             SiCnt++;
         } //End if (high order byte was a repeat count)
 //  Return the value
     *bValue = i;
     return(0);
 #undef READSZ
 } //End function (iUncompressWord)

 int iConvert4ToDIB(BYTE *x, BYTE huge *bBitmap)
 {
 int i, k;
 int iBytesPerBitPlane = pcxHead.iBytesPerBitPlane;

 //  Take four bytes from each bitplane (8 pixels) and convert to DIB
     for (i=0, k=0;i<iBytesPerBitPlane;i++, k+=pcxHead.bNplanes)
     {
     //  Convert the first pair of pixels to DIB
         bBitmap[k]=
           ((x[i] & 0x80) >>3) | ((x[i+iBytesPerBitPlane] & 0x80) >> 2) |
           ((x[i+2*iBytesPerBitPlane] & 0x80) >> 1) |
           ((x[i+3*iBytesPerBitPlane] & 0x80)) |
           ((x[i] & 0x40) >> 6) | ((x[i+iBytesPerBitPlane] & 0x40) >> 5) |
           ((x[i+2*iBytesPerBitPlane] & 0x40) >> 4) |
           ((x[i+3*iBytesPerBitPlane] & 0x40) >>3);
     //  Convert the second pair of pixels to DIB
         bBitmap[k+1]=
           ((x[i] & 0x20) >> 1) | ((x[i+iBytesPerBitPlane] & 0x20)) |
           ((x[i+2*iBytesPerBitPlane] & 0x20) <<1) |
           ((x[i+3*iBytesPerBitPlane] & 0x20) <<2) |
           ((x[i] & 0x10) >>4 ) | ((x[i+iBytesPerBitPlane] & 0x10) >> 3) |
           ((x[i+2*iBytesPerBitPlane] & 0x10) >> 2) |
           ((x[i+3*iBytesPerBitPlane] & 0x10) >>1);
     //  Convert the third pair of pixels to DIB
         bBitmap[k+2]=
           ((x[i] & 0x08) << 1 ) | ((x[i+iBytesPerBitPlane] & 0x08) << 2) |
           ((x[i+2*iBytesPerBitPlane] & 0x08) << 3) |
           ((x[i+3*iBytesPerBitPlane] & 0x08) << 4) |
           ((x[i] & 0x04)>> 2) | ((x[i+iBytesPerBitPlane] & 0x04)>> 1) |
           ((x[i+2*iBytesPerBitPlane] & 0x04)) |
           ((x[i+3*iBytesPerBitPlane] & 0x04) <<1);
     //  Convert the fourth pair of pixels to DIB
         bBitmap[k+3]=
           ((x[i] & 0x02)<<3) | ((x[i+iBytesPerBitPlane] & 0x02) << 4) |
           ((x[i+2*iBytesPerBitPlane] & 0x02) <<5) |
           ((x[i+3*iBytesPerBitPlane] & 0x02) <<6) |
           ((x[i] & 0x01))| ((x[i+iBytesPerBitPlane] & 0x01) <<1) |
           ((x[i+2*iBytesPerBitPlane] & 0x01) <<2) |
           ((x[i+3*iBytesPerBitPlane] & 0x01) <<3);
     } //End for (each byte of each bitplane)

 }  //End function (iConvert4ToDIB)

 int iBufferCompressedFile(HANDLE hPCXfile)
 {
 BYTE *pbBuffer, bValue, bRepeatCnt;
 int  iBytesPerScanline = pcxHead.iBytesPerBitPlane*pcxHead.bNplanes;
 int iBytesConverted, iScanlineNo;
 HANDLE hMemLine;

 // Allocate a single scanline buffer
    hMemLine = LocalAlloc (LMEM_MOVEABLE, (DWORD)iBytesPerScanline);
    if ((pbBuffer = (BYTE *) LocalLock (hMemLine))==NULL)
    {
        return NO_MEMORY;
    }  //End if (error locking segment)

    iScanlineNo = iBytesConverted = 0;
    while (TRUE)
    {
    //   If the bitmap is run-length encoded....
         if (pcxHead.bEncod == 1)
         {
         //  Uncompress the next word
             if (iUncompressWord(&bValue, &bRepeatCnt, hPCXfile) == -1)
             {
                 break;
             }  //End if (end of file reached)
         }  //End if (the PCX file is Run-length compressed)
         else
         {
         //  Not compressed, simply read the next byte
             if( _lread(hPCXfile, (LPSTR) &bValue,
                   sizeof(BYTE))< sizeof(BYTE))
             {
                 break;
             }  //End if (end of file reached)
             bRepeatCnt = 1;
         } //End if (uncompressed PCX file)
         //  Duplicate the byte bRepeatCnt times into buffer
         while (bRepeatCnt--)
         {
             *(pbBuffer + iBytesConverted++) = bValue;
         //  If we finished a scanline...
             if (iBytesConverted == iBytesPerScanline)
             {
             //  Convert the scanline to DIB format, place in DIB buff.
                 iConvert4ToDIB (pbBuffer,
             //  NOTE:  PCX bitmap is scanned into the DIB buffer from
             //  bottom to top.  PCX bitmaps have their origin at top
             //  left, whereas DIBs have origin at bottom left.  If this
             //  is not done, the DIB may display inverted in Windows
             //  mapping modes where the origin is the upper left corner
             //  of the client area.
                   (BYTE huge *) &pbBigBuf[(DWORD)iBytesPerScanline*
                                 (DWORD)((DIB_HEIGHT()-1)-iScanlineNo)]);
                 iScanlineNo++;
                 iBytesConverted = 0;
             } //End if (completed conversion of a scanline)
         } //End while (more bytes to repeat)
     } //End while (more bytes to convert)

 //  Clean up
     LocalUnlock(hMemLine);
     LocalFree(hMemLine);
     return 0;
 } //End function (iBufferCompressedFile)

 int iDisplayPCXfile (char *szFileName)
 {
 OFSTRUCT OfFileStruct;
 HANDLE   hPCXfile;
 HANDLE hMemBlock;
 HDC hDC;

 BYTE far *pbBigBuf2;
 HANDLE hBitInfo;
 int i;
 RECT         rClient;

//  Get display context for display
    hDC = GetDC(MainhWnd);
//  Open the PCX file to read
    if ((hPCXfile =  OpenFile (szFileName, &OfFileStruct, OF_READ))==-1)
    {
        ReleaseDC(MainhWnd, hDC);
        return BAD_OPEN;
    } //End if (error opening the PCX file)
//  Read in the header
    if( _lread(hPCXfile, (LPSTR) &pcxHead,
               sizeof(SHORTPCXHEAD))< sizeof(SHORTPCXHEAD))
    {
        ReleaseDC(MainhWnd, hDC);
        _lclose (hPCXfile);
        return BAD_IMAGE;
    }  //End if (error reading the PCX file header)

//  Allocate the big DIB buffer
    hMemBlock = GlobalAlloc (GMEM_MOVEABLE, (DWORD) DIB_SIZE());
    if ((pbBigBuf = (BYTE huge *) GlobalLock (hMemBlock))==NULL)
    {
        ReleaseDC(MainhWnd, hDC);
        _lclose (hPCXfile);
        return NO_MEMORY;
    }  //End if (error locking segment)
//  Buffer the PCX file, converting to DIB format in the process
    iBufferCompressedFile (hPCXfile);
//  Set the fields of the BITMAPINFO structure describing DIB
    hBitInfo = iInitColorDIB();
    BitInfo = (BITMAPINFO *) LocalLock (hBitInfo);
//  Get client rectangle
    GetClientRect(MainhWnd, &rClient);
//  Display the DIB, stretching to fit the client area
#ifdef LOGICAL_PALETTE
    {
    HPALETTE hPal;
    LOGPALETTE *pPal;

        pPal = (LOGPALETTE *) LocalLock (hPalMem);
        hPal = CreatePalette (pPal);
        SelectPalette (hMainDC, hPal, FALSE);
        RealizePalette (hMainDC);
        StretchDIBits(hMainDC, 0, 0, rClient.right+1, rClient.bottom+1,
           0,0,DIB_WIDTH(), DIB_HEIGHT(),
           pbBigBuf, (LPBITMAPINFO) BitInfo, DIB_PAL_COLORS, SRCCOPY);
        DeleteObject (hPal);
        LocalFree (hPalMem);
    }
#else
    StretchDIBits(hDC, 0, 0, rClient.right+1, rClient.bottom+1,
       0,0,DIB_WIDTH(), DIB_HEIGHT(),
       pbBigBuf, (LPBITMAPINFO) BitInfo, DIB_RGB_COLORS, SRCCOPY);
#endif
//  Clean up
    GlobalUnlock(hMemBlock);
    GlobalFree(hMemBlock);
    LocalFree(hBitInfo);
    ReleaseDC(MainhWnd, hDC);
   _lclose(hPCXfile);

 } //End function (iDisplayPCXfile)

                                                                  