/*
SIMPLE3.C

Microsoft C, Windows SDK:
cl -c -AS -Gsw -Oais -Zpe simple3.c winio.c wmhandlr.c
link simple3 winio wmhandlr,simple3,nul,/nod slibcew libw,winio.def
rc winio.rc simple3.exe

Borland C++:
bcc -WS -G -O -Z -w-par -Hu simple3.c winio.c wmhandlr.c
copy winio.rc simple3.rc
rc winio.rc simple3.exe
*/

#include "windows.h"
#include "winio.h"

unsigned num_tasks=0;

void show_info(void)
{
    unsigned vers = GetVersion();
    unsigned long flags = GetWinFlags();
    num_tasks = GetNumTasks();
    winio_clear();
    printf("Windows v. %d.%d\n", LOBYTE(vers), HIBYTE(vers));
    printf("%s mode\n", 
        (flags & WF_ENHANCED) ? "Enhanced" :
        (flags & WF_STANDARD) ? "Standard" :
        /* default */           "Real");
    printf("%d tasks running\n", num_tasks);
}

long on_time(HWND hwnd, unsigned message, WORD wParam, LONG lParam)
{
    if (GetNumTasks() != num_tasks)
        show_info();
    return 0;
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    winio_settitle("Introduction to WINIO, with Timer");
    if (! winio_init(hInstance, hPrevInstance, nCmdShow, 0))
        return 1;
    wmhandler_set(WM_TIMER, on_time);
    if (! SetTimer(winio_hwnd(), 1, 1000, NULL)) // once a second
    {
        winio_warn(FALSE, "can't create timer");
        winio_close();
    }
    
    return 0;
}

