/*
SIMPLE2.C

Microsoft C, Windows SDK:
cl -c -AS -Gsw -Oais -Zpe simple2.c winio.c wmhandlr.c
link simple2 winio wmhandlr,simple2,nul,/nod slibcew libw,winio.def
rc winio.rc simple2.exe

WINIO.DEF (generic .DEF file for programs built with WINIO):
NAME        winio_app
EXETYPE     WINDOWS
CODE        PRELOAD MOVEABLE DISCARDABLE
DATA        PRELOAD MOVEABLE MULTIPLE
HEAPSIZE    4096
STACKSIZE   8192
EXPORTS     WndProc

WINIO.RC (generic .RC file for programs built with WINIO):
winio_icon ICON stdio.ico

Borland C++ (no .DEF file needed):
bcc -WS -G -O -Z -w-par -Hu simple2.c winio.c wmhandlr.c
rc winio.rc simple2.exe
*/

#include "windows.h"
#include "winio.h"

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    unsigned vers = GetVersion();
    unsigned long flags = GetWinFlags();
    
    winio_settitle("Introduction to WINIO");
    if (! winio_init(hInstance, hPrevInstance, nCmdShow, 0))
        return 1;
    printf("Windows v. %d.%d\n", LOBYTE(vers), HIBYTE(vers));
    printf("%s mode\n", 
        (flags & WF_ENHANCED) ? "Enhanced" :
        (flags & WF_STANDARD) ? "Standard" :
        /* default */           "Real");
    printf("%d tasks running\n", GetNumTasks());
    return 0;
}

