/* ------------------------------- DEVICE.H --------------------------------
                     Embedded Device Driver Application.

   ------------------------------------------------------------------------- */

/* Error bitflag definitions for GetDevError( ). */
#define DEVERROR_OVERRUN        (1<<0)
#define DEVERROR_INTERNAL       (1<<1)
#define DEVERROR_NOTOWNER       (1<<2)


/* Data structure and type declarations. */
typedef struct RegistersTag
{
    unsigned ax;
    unsigned bx;
    unsigned cx;
    unsigned dx;
    unsigned cs;
    unsigned ds;
    unsigned es;
    unsigned si;
    unsigned di;
    unsigned bp;
    unsigned sp;
    unsigned ip;
    unsigned flags;
}
REGISTERS;
typedef REGISTERS      *  PREGISTERS;
typedef REGISTERS NEAR * NPREGISTERS;
typedef REGISTERS FAR  * LPREGISTERS;

/* Public function prototypes. */
PUBLIC BOOL FAR PASCAL DevOpen( HWND );
PUBLIC BOOL FAR PASCAL DevClose( HWND );
PUBLIC WORD FAR PASCAL DevRead( HWND , LPREGISTERS , WORD );
PUBLIC WORD FAR PASCAL GetDevError( HWND , LPWORD , BOOL );
PUBLIC int  FAR PASCAL GetNumUnreadItems( HWND );

/* EOF */
