#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <windows.h>
#include "stock.h"

#define ENUMFACES  0 
#define ENUMSIZES  1 
 
#define MAXFONT   64

typedef struct tagFontInfo
{
  char szTypeface[64];
  BYTE lfPitchAndFamily;
  BYTE lfCharSet;
} FONTINFO;

FONTINFO FontInfo[MAXFONT];


static int   idxTypeface; 
static BYTE  abFontSizeBitmask[256/8 + sizeof(WORD)];   // room for 256 different sizes


VOID PASCAL GetTypefaces(HWND hWnd);
VOID PASCAL GetFontSizes(HWND hWnd, int idxFont);
int FAR PASCAL EnumFunc(LPLOGFONT lpLogFont, LPTEXTMETRIC lpTextMetric, 
				short FontType, LPSTR lpData);
VOID PASCAL ShowSampleFont(HWND hDlg, BOOL bPermanent);
int BitMaskSet(BYTE *map, WORD c, WORD val);
int BitMaskTest(BYTE *map, WORD c);


BOOL FAR PASCAL FontDlgProc(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
  int  i;
  char szBuf[128];

  switch (message)
  {
    case WM_INITDIALOG :
      if (!hCurrStockInfo)
      {
        EndDialog(hDlg, FALSE);
        return TRUE;
      }

      GetTypefaces(hDlg);
      for (i = 0;  i < idxTypeface;  i++)
      {
        SendDlgItemMessage(hDlg, ID_FACELIST, LB_ADDSTRING, 0,
                           (LONG) (LPSTR) FontInfo[i].szTypeface);
      }
      SendDlgItemMessage(hDlg, ID_FACELIST, LB_SETCURSEL, 0, 0L);

      GetFontSizes(hDlg, 0);
      for (i = 1;  i < 256;  i++)
      {
        if (BitMaskTest(abFontSizeBitmask, i))
        {
          sprintf(szBuf, "%d", i);
          SendDlgItemMessage(hDlg, ID_SIZELIST, LB_ADDSTRING, 0,
                                    (LONG) (LPSTR) szBuf);
        }
      }
      SendDlgItemMessage(hDlg, ID_SIZELIST, LB_SETCURSEL, 0, 0L);
      ShowSampleFont(hDlg, FALSE);
      return TRUE;


    case WM_COMMAND :
      switch (wParam)
      {
        case ID_FACELIST :
          switch (HIWORD(lParam))
          {
            case LBN_SELCHANGE :
              i = (int) SendDlgItemMessage(hDlg,ID_FACELIST,LB_GETCURSEL,0,0L);
              if (i == LB_ERR)
                break;
              SendDlgItemMessage(hDlg, ID_SIZELIST, LB_RESETCONTENT, 0, 0L);

              GetFontSizes(hDlg, i);
              for (i = 1;  i < 256;  i++)
              {
                if (BitMaskTest(abFontSizeBitmask, i))
                {
                  sprintf(szBuf, "%d", i);
                  SendDlgItemMessage(hDlg, ID_SIZELIST, LB_ADDSTRING, 0,
                                            (LONG) (LPSTR) szBuf);
                }
              }
              SendDlgItemMessage(hDlg, ID_SIZELIST, LB_SETCURSEL, 0, 0L);
              ShowSampleFont(hDlg, FALSE);
              break;

            case LBN_DBLCLK:
              goto do_it;
          }
          break;

        case ID_SIZELIST:
          switch (HIWORD(lParam))
          {
            case LBN_SELCHANGE :
              ShowSampleFont(hDlg, FALSE);
              break;

            case LBN_DBLCLK :
              goto do_it;
          }
          break;


        case IDOK :
do_it:
          ShowSampleFont(hDlg, TRUE);
          EndDialog(hDlg, TRUE);
          break;

        case IDCANCEL :
          EndDialog(hDlg, FALSE);
          break;
      }

      return TRUE;

  }

  return FALSE;
}


VOID PASCAL GetTypefaces(HWND hWnd) 
{ 
  FARPROC lpEnumFunc; 
  HDC hDC; 
 
  idxTypeface = 0; 
 
  hDC = GetDC(hWnd); 
  lpEnumFunc = MakeProcInstance(EnumFunc, hThisInstance); 
  EnumFonts(hDC, (LPSTR) NULL, lpEnumFunc, (LPSTR) (LONG) ENUMFACES); 
  FreeProcInstance(lpEnumFunc); 
  ReleaseDC(hWnd, hDC); 
} 
 
 
VOID PASCAL GetFontSizes(HWND hWnd, int idxFont) 
{ 
  HDC hDC; 
  FARPROC lpEnumFunc; 
 
  memset((char *) abFontSizeBitmask, 0, sizeof(abFontSizeBitmask));
  * (WORD *) abFontSizeBitmask = 256;

  hDC = GetDC(hWnd); 
  lpEnumFunc = MakeProcInstance(EnumFunc, hThisInstance); 
  EnumFonts(hDC, FontInfo[idxFont].szTypeface, lpEnumFunc, (LPSTR) (LONG) ENUMSIZES); 
  FreeProcInstance(lpEnumFunc); 
  ReleaseDC(hWnd, hDC); 
} 
 
 
int FAR PASCAL EnumFunc(LPLOGFONT lpLogFont, LPTEXTMETRIC lpTextMetric, 
				short FontType, LPSTR lpData) 
{ 
  switch ((int) lpData) 
  { 
    case ENUMFACES : 
      if (idxTypeface >= MAXFONT) 
        return 0; 
      lstrcpy(FontInfo[idxTypeface].szTypeface, lpLogFont->lfFaceName); 
      FontInfo[idxTypeface].lfPitchAndFamily = lpLogFont->lfPitchAndFamily; 
      FontInfo[idxTypeface].lfCharSet = lpLogFont->lfCharSet; 
      return ++idxTypeface; 
 
    case ENUMSIZES : 
      BitMaskSet(abFontSizeBitmask, lpLogFont->lfHeight, TRUE); 
      return TRUE; 
  } 
} 


VOID PASCAL ShowSampleFont(HWND hDlg, BOOL bPermanent)
{
  HFONT hFont, hOldFont;
  HWND hWnd;
  HDC  hDC;
  RECT r;
  int  iSel, iSize;
  char szBuf[80];


  iSel = (int) SendDlgItemMessage(hDlg,ID_SIZELIST,LB_GETCURSEL,0,0L);
  SendDlgItemMessage(hDlg, ID_SIZELIST, LB_GETTEXT, iSel,
                           (LONG)(LPSTR) szBuf);
  iSize = atoi(szBuf);

  iSel = (int) SendDlgItemMessage(hDlg,ID_FACELIST,LB_GETCURSEL,0,0L);
  SendDlgItemMessage(hDlg, ID_FACELIST, LB_GETTEXT, iSel,
                     (LONG)(LPSTR) szBuf);


  hWnd = GetDlgItem(hDlg, ID_TESTFONT);
  hDC = GetDC(hWnd);
  GetClientRect(hWnd, (LPRECT) &r);
  FillRect(hDC, (LPRECT) &r, (HBRUSH) GetStockObject(WHITE_BRUSH));

  hFont = CreateFont(iSize, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE,
                     FontInfo[iSel].lfCharSet,
                     OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
                     DEFAULT_QUALITY, FontInfo[iSel].lfPitchAndFamily,
                     szBuf);
  if (hFont)
  {
    hOldFont = SelectObject(hDC, hFont);
    TextOut(hDC, 0, 0, "ABCabc", 6);
    SelectObject(hDC, hOldFont);
    if (bPermanent)
    {
      LPSTOCKINFO lpStockInfo;
      if ((lpStockInfo = (LPSTOCKINFO) GlobalLock(hCurrStockInfo)) != NULL)
      {
        if (lpStockInfo->graphAttrs.hFont != 0)
          DeleteObject(lpStockInfo->graphAttrs.hFont);
        lpStockInfo->graphAttrs.hFont = hFont;
        InvalidateRect(lpStockInfo->hWnd, (LPRECT) NULL, FALSE);
        GlobalUnlock(hCurrStockInfo);
      }
    }
    else
      DeleteObject(hFont);
  }

  ReleaseDC(hWnd, hDC);
}


/*****************************************************************************/
/*                                                                           */
/*	              ROUTINES FOR MANIPULATING BITMASKS                     */
/*                                                                           */
/*****************************************************************************/

BitMaskSet(map, c, val)
  BYTE *map;
  WORD c, val;
{
  /* 'c' takes on the values 1..n; since the bitmap numbers
     the bits from 0..n-1, we need to subtract 1 from 'c' before we start.
  */
  if (c >= * (WORD *) map)      /* test if there are c bits in the map */
    return 0;
  map += sizeof(WORD);	    /* get past the size indicator	   */
  if (val)
    map[c >> 3] |=   1 << (c & 0x07);	  /* turn it on  */
  else
    map[c >> 3] &= ~(1 << (c & 0x07));	/* turn it off */
  return 1;
}

BitMaskTest(map, c)
  BYTE *map;
  WORD c;
{
  /* 'c' takes on the values 1..n; since the bitmap numbers
     the bits from 0..n-1, we need to subtract 1 from 'c' before we start.
  */
  if (c >= * (WORD *) map)		 /* make sure we're inbounds */
    return 0;
  map += sizeof(WORD);		       /* get past size indicator  */
  return( map[c >> 3] & (1 << (c & 0x07)) );   /* extract the desired bit  */
}
