//===================================================================
// phone.h header file
//===================================================================

#include <windows.h>
#include <lan.h>
#include <nmpipe.h>
#include <netcons.h>
#include <neterr.h>
#include <mailslot.h>
#include <wksta.h>

#include <string.h>
#include <ctype.h>

#include "pbxpkt.h"
#include "rc.h"

#define NP_WAIT 	    0x0000
#define NP_NOWAIT	    0x8000
#define NP_READMODE_MESSAGE 0x0100
#define NP_READMODE_BYTE    0x0000

#define PROGNAME	    "WinPhone"
#define PHONEMENU	    "PhoneMenu"
#define PHONE_ID	    0xABBA
#define MAX_NAMES	    50

#define CHRMSG_ID   4
#define HANGUP_ID   5

typedef struct _HEADER {    //... This is a phone message header template
    WORD wPktId;	    //... its structure is (and must be) similar
    WORD wPktSize;	    //... to that of a PBX packet.
    WORD wRetCode;
} HEADER;

typedef HEADER _far *PHEADER;

typedef struct _CHRMSG
{
    HEADER header;
    WORD   wParam;
    LONG   lParam;
} CHRMSG;

typedef CHRMSG _far *PCHRMSG;

typedef HEADER HANGUP;

typedef enum _STATE {
    START_STATE,
    IDLE_STATE,
    CALL_STATE,
    WAIT_STATE,
    ANSWER_STATE,
    HANGUP_STATE,
    TALK_STATE
} STATE;

//==================================================================
// External data and function prototypes
//==================================================================

extern char	szClientName[NAMESIZE];
extern char	szCallName[NAMESIZE];
extern int	PipeHandle;

extern FARPROC	lpfnLocalChild;
extern FARPROC	lpfnCallDialogProc;
extern FARPROC	lpfnAboutDialogProc;
extern FARPROC	lpfnConfigDialogProc;

extern HWND	hParent;
extern HWND	hLocalChild;
extern HWND	hRemoteChild;

extern char	format[80];
extern STATE	state;

extern WORD ReadListQuery(void);
extern WORD SubmitListQuery(void);

extern void FAR PASCAL ClearEditWindow(HWND);
extern void FAR PASCAL DisplayMsgBox(HWND hWnd, char *str);
extern long FAR PASCAL LocalProc(HWND, unsigned, WORD, LONG);
extern long FAR PASCAL WndProc(HWND, unsigned, WORD, LONG);
extern BOOL FAR PASCAL ConfigDialogProc(HWND, unsigned, WORD, LONG);
extern BOOL FAR PASCAL CallDialogProc(HWND, unsigned, WORD, LONG);
extern BOOL FAR PASCAL AboutDialogProc(HWND, unsigned, WORD, LONG);
extern BOOL FAR PASCAL HelpDialogProc(HWND, unsigned, WORD, LONG);
