
//===================================================================
//  MODULE: phone.c
//===================================================================

#include "phone.h"

HWND hParent;	    //... handle to parent window

//===================================================================
//  WinMain()
//
//  The main entry point into phone.exe. Among onther things, we
//  save the handle to the parent window in "hParent."
//===================================================================

int PASCAL WinMain(hInstance, hPrevInstance, lpszCmdLine, nCmdShow)
HANDLE	hInstance;
HANDLE	hPrevInstance;
LPSTR	lpszCmdLine;
int	nCmdShow;
{
    static char szAppName[] = "WinPhone";
    MSG 	msg;
    WNDCLASS	wndclass;
    short	xScreen, yScreen;
    short	ulCol, ulRow, Width, Height;

    //===============================================================
    //	Define Parent Window and Children classes
    //===============================================================

    if ( !hPrevInstance )
    {
	wndclass.style		= CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	= WndProc;
	wndclass.cbClsExtra	= 0;
	wndclass.cbWndExtra	= 0;
	wndclass.hInstance	= hInstance;
	wndclass.hIcon		= LoadIcon(hInstance,(LPSTR)"phone");
	wndclass.hCursor	= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= PHONEMENU;
	wndclass.lpszClassName	= szAppName;

	if ( !RegisterClass(&wndclass) )
	{
	    return FALSE;
	}
    }

    //===============================================================
    //	Create Parent and child windows
    //===============================================================

    xScreen = GetSystemMetrics(SM_CXSCREEN);
    yScreen = GetSystemMetrics(SM_CYSCREEN);

    ulCol  = 5 * xScreen / 80;
    ulRow  = yScreen / 25;
    Width  = 7 * xScreen / 8;
    Height = 7 * yScreen / 8;

    hParent = CreateWindow(szAppName,	       // window class
			   PROGNAME,	       // window caption
			   WS_OVERLAPPEDWINDOW,// window style
			   ulCol,	       // initial x pos
			   ulRow,	       // initial y pos
			   Width,	       // initial x size
			   Height,	       // initial y size
			   NULL,	       // parent window
			   NULL,	       // window menu
			   hInstance,	       // program instance
			   NULL);	       // create parameters

    //===============================================================
    //	Show window and update.
    //===============================================================

    ShowWindow(hParent, nCmdShow);
    UpdateWindow(hParent);

    //===============================================================
    //	Enter Message loop
    //===============================================================

    while( GetMessage(&msg, NULL, 0, 0) )
    {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }

    return msg.wParam;
}
