//===================================================================
//  Dialog.c
//===================================================================

#include "phone.h"
#include "runtime.h"

char szCallName[NAMESIZE];
char szTempNumber[NAMESIZE + sizeof(WORD)];

BOOL NumberSelected = FALSE;
HWND hListBox;
HWND hEditBox;
extern BOOL config;

static struct {
    WORD wCount;
    char szName[MAX_NAMES][NAMESIZE];
} ListQueryNames = {0};

//===================================================================
//  ConfigDialogProc()
//===================================================================

BOOL FAR PASCAL ConfigDialogProc(hWnd, iMessage, wParam, lParam)
HWND hWnd;
unsigned iMessage;
WORD wParam;
LONG lParam;
{
    switch(iMessage)
    {
	case WM_INITDIALOG:
	    //======================================
	    // Get name from edit box and place
	    //	in szClientName
	    //======================================

	    SetDlgItemText(hWnd, IDD_NUMBER, szClientName);
	    break;

	case WM_COMMAND:
	    switch(wParam)
	    {
		case IDD_OK:
		    //======================================
		    //	The user has pressed the OK button.
		    //	Checl for valid name and state.
		    //======================================

		    if ( strlen(szClientName) && state != TALK_STATE )
		    {
			state = IDLE_STATE;
		    }
		    EndDialog(hWnd, TRUE);
		    break;

		case IDD_CANCEL:
		    //======================================
		    //	CANCEL button pressed!
		    //======================================

		    EndDialog(hWnd, TRUE);
		    break;

		case IDD_NUMBER:
		    //======================================
		    //	A new name was entered, so update
		    //	szClientName if not already configured
		    //======================================
		    if ( !config )
		    {
			GetDlgItemText(hWnd, IDD_NUMBER,
				       szClientName,
				       NAMESIZE);
		    }
		    break;

		default:
		    return FALSE;
	    }
	    break;

	default: return FALSE;
    }

    return TRUE;
}

//===================================================================
//  CallDialogProc()
//===================================================================

BOOL FAR PASCAL CallDialogProc(hWnd, iMessage, wParam, lParam)
HWND	 hWnd;
unsigned iMessage;
WORD	 wParam;
LONG	 lParam;
{
    WORD   nIndex, i, nLength;
    int    err;

    switch(iMessage)
    {
	case WM_INITDIALOG:
	    hListBox = GetDlgItem(hWnd, IDD_TEXT);
	    hEditBox = GetDlgItem(hWnd, IDD_EDIT);

	    //======================================
	    //	Fill the list box with names from
	    //	the names structure
	    //======================================

	    for(i=0; i < ListQueryNames.wCount; ++i)
	    {
		SendMessage(hListBox, LB_ADDSTRING, 0,
		      (LONG) (LPVOID) ListQueryNames.szName[i]);
	    }

	    //======================================
	    //	Submit another ListQuery request.
	    //======================================

	    if ( state == IDLE_STATE )
		SubmitListQuery();
	    else
		DisplayMsgBox(hParent, "Could not Submit list query");
	    break;

	case WM_COMMAND:
	    switch(wParam)
	    {
		case IDD_DIAL:
		    //======================================
		    //	The user is calling someone.
		    //======================================

		    EndDialog(hWnd, TRUE);

		    //======================================
		    //	Get the remote name and place it
		    //	in szCallName.
		    //======================================

		    if ( GetDlgItemText(hWnd, IDD_EDIT,
					szCallName, NAMESIZE))
		    {
			if (strcmp(szCallName, szClientName) == 0)
			{
			    DisplayMsgBox(hParent,
				      "You may not call yourself.");
			}
			else
			{
			    //======================================
			    //	Enter call state and connect to
			    //	PBX.
			    //======================================

			    state = CALL_STATE;

			    err = PbxConnect(PipeHandle,
					     szCallName,
					     PHONE_ID);

			    if ( err )
			    {
				state = IDLE_STATE;

				wsprintf(format,
					"CALLING %s FAILED: %u",
					szCallName, err);

				DisplayMsgBox(hParent, format);
			    }
			}
		    }
		    else
		    {
			DisplayMsgBox(hParent,
			       "No Selection has been made.");
		    }
		    break;

		case IDD_CANCEL:
		    //======================================
		    //	The user pressed the CANCEL button.
		    //======================================

		    if ( state != TALK_STATE )
		    {
			state = IDLE_STATE;
		    }
		    EndDialog(hWnd, TRUE);
		    break;

		case IDD_TEXT:
		    //======================================
		    //	Get the name from the LISTBOX and
		    //	place it in the selection editbox.
		    //======================================

		    nIndex = (WORD) SendMessage(hListBox,
						LB_GETCURSEL,
						0, 0L);

		    if ( SendMessage(hListBox, LB_GETTEXT, nIndex,
			       (LONG) (LPVOID) szCallName) > 0 )
		    {
			SetDlgItemText(hWnd, IDD_EDIT, szCallName);
		    }

		    if ( HIWORD(lParam) == LBN_DBLCLK )
		    {
			SendMessage(hWnd, WM_COMMAND, IDD_DIAL, 0L);
		    }
		    break;

		default: return FALSE;
	    }
	    break;

	default: return FALSE;
    }

    return TRUE;
}

//===================================================================
//  AboutDialogProc()
//===================================================================

BOOL FAR PASCAL AboutDialogProc(hWnd, iMessage, wParam, lParam)
HWND	 hWnd;
unsigned iMessage;
WORD	 wParam;
LONG	 lParam;
{
    if ( iMessage == WM_COMMAND && wParam == IDD_OK )
    {
	EndDialog(hWnd, FALSE);
	return TRUE;
    }

    return FALSE;
}

//===================================================================
//  SubmitListQuery() --
//
//  This procedure takes as input the handle to the list box and
//  fills it in with names received from the PBX.
//===================================================================

#define Q_LISTSIZE  (MAX_NAMES * PBXMSGSIZE)

static PBXPKT pbxPacket;
static BYTE   buffer[Q_LISTSIZE];

WORD SubmitListQuery(void)
{
    WORD err;

    pbxPacket.usPktID = LISTQUERY;
    pbxPacket.usPktSize = sizeof(PBXPKT);
    pbxPacket.aLQNames.usFirstName = 0;

    err = _lwrite(PipeHandle, (LPSTR) &pbxPacket, sizeof(PBXPKT));

    return ( (int) err <= 0 ? -1 : 0 );
}

//===================================================================
//  ReadListQuery() --
//
//  Reads list query data from the pipe and stores it in an internal
//  structure.
//===================================================================

WORD ReadListQuery(void)
{
    LPSTR  pszName, pBufEnd;
    WORD   err, nBytes, i, nBytesLeft, nNames;

    err = _lread(PipeHandle, (LPSTR) &pbxPacket, sizeof(PBXPKT));

    if ( (int) err <= 0 )	    //... PIPE error?
    {
	return -1;
    }

    if ( pbxPacket.usRetCode )	    //... PBX error?
    {
	wsprintf(format, "PBX failure: %u", pbxPacket.usRetCode);
	DisplayMsgBox(hParent, format);

	return pbxPacket.usRetCode;
    }

    if ( pbxPacket.aLQNames.usNameCnt == 0 )	//... No names?
    {
	DisplayMsgBox(hParent, "PBX: No names to read" );

	return -1;
    }

    _fstrcpy(ListQueryNames.szName[0],	      //.. copy name
	     pbxPacket.aPBXName[0].pszName);

    ListQueryNames.wCount = 1;

    --pbxPacket.aLQNames.usNameCnt; //... one less name in pipe

    nNames = min(MAX_NAMES, pbxPacket.aLQNames.usNameCnt);

    if ( nNames == 0 )
    {
	return 0;
    }

    //====================================================
    //	If we have made it this far then there is more
    //	than 1 name (i.e our own) in the pipe. nNames
    //	is the number of names we can read from the
    //	pipe. 0 < nNames <= MAX_NAMES. It is very
    //	possible that there exists more than MAX_NAMES
    //	names in the pipe but that is all our name table
    //	can hold so the rest must be read from the pipe
    //	and toast into the bit bucket.
    //====================================================

    nBytes = _lread(PipeHandle, buffer, nNames * PBXMSGSIZE);

    if ( (int) nBytes == -1 )	    //... check for read failure
    {
	return -1;
    }

    //====================================================
    //	We have read the names from the pipe!
    //	Now we must put these name in the name table.
    //====================================================

    pBufEnd = (buffer + nBytes);

    for(i = 1, pszName=buffer;
	pszName != pBufEnd; pszName += PBXMSGSIZE, ++i)
    {
	_fstrcpy(ListQueryNames.szName[i], pszName);
    }

    //====================================================
    //	Before we can exit, we must read any names which
    //	are left in the pipe that would not fit in the
    //	name table. nBytes was actual number of bytes
    //	read from the pipe and is a multiple of 16.
    //	Therre might be more names in the pipe that we
    //	cannot hold in the buffer so we toss them into
    //	the bit bucket.
    //====================================================

    nBytesLeft = pbxPacket.aLQNames.usNameCnt * PBXMSGSIZE - nBytes;

    while( nBytesLeft )
    {
	nBytes = min(nBytesLeft, Q_LISTSIZE);

	_lread(PipeHandle, buffer, nBytes);

	nBytesLeft -= nBytes;
    }

    ListQueryNames.wCount = nNames + 1;

    return 0;
}
