/*******************************************************************
    PROGRAM: Front.c

    PURPOSE: Front End for Mixed 16 and 32 bit program under Windows.
********************************************************************/

#include <windows.h>    /* required for all Windows applications */
#include "front.h"      /* specific to this program */

HANDLE hInst;           /* current instance */

/*******************************************************************
    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop
********************************************************************/
int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
MSG msg;

    if (!hPrevInstance)
    if (!InitApplication(hInstance))
        return FALSE;

    if (!InitInstance(hInstance, nCmdShow))
        return FALSE;

    while (GetMessage(&msg,NULL,NULL,NULL)) {

    TranslateMessage(&msg);
    DispatchMessage(&msg);

    }
    return msg.wParam;
}

/********************************************************************
    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class
********************************************************************/
BOOL InitApplication(HANDLE hInstance)  {
WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;

    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "FrontMenu";
    wc.lpszClassName = "FrontWClass";

    /* Register the window class and return success/failure code. */

    return RegisterClass(&wc);

}

/********************************************************************
    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window
********************************************************************/
BOOL InitInstance(HANDLE hInstance,int nCmdShow)    {
HWND    hWnd;

    hInst = hInstance;

    hWnd = CreateWindow(
        "FrontWClass",
        "Front Sample Application",
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL
    );

    if (!hWnd)
        return FALSE;

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return TRUE;
}

/********************************************************************
    FUNTION: DoAboutBox
    PURPOSE: Put up the about box.
********************************************************************/

void    DoAboutBox(HWND hWnd)   {
FARPROC lpProcAbout;

    lpProcAbout = MakeProcInstance(About, hInst);

    DialogBox(hInst,"AboutBox",hWnd,lpProcAbout);

    FreeProcInstance(lpProcAbout);
}

/********************************************************************
    FUNTION: Inform
    PURPOSE: Inform the user of progress.
********************************************************************/
void    Inform(HWND hWnd,LPSTR s)   {
    MessageBox(hWnd,s,"Front",MB_OK);
}

/********************************************************************
    FUNTION: Notify
    PURPOSE: Notify the user of a problem.
********************************************************************/
void    Notify(HWND hWnd,LPSTR s)   {
    MessageBox(hWnd,s,"Front",MB_OK | MB_ICONHAND);
}

/********************************************************************
    FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)
    Processes the following
    MESSAGES:

    WM_COMMAND    - application menu (About dialog box)
    WM_DESTROY    - destroy window
********************************************************************/
long FAR PASCAL MainWndProc(hWnd,message,wParam,lParam)
HWND hWnd;        /* window handle           */
unsigned message;     /* type of message             */
WORD wParam;          /* additional information      */
LONG lParam;          /* additional information      */
{
    switch (message) {

    case WM_COMMAND:
        switch (wParam) {

            case    IDM_ABOUT:
                DoAboutBox(hWnd);
            break;

        case    IDM_LOADENGINE:
            Inform(hWnd,"Now Loading Engine");

            if (LoadEngine(hWnd,"back.exp"))
                Inform(hWnd,"Engine Intialized");
            else
                Notify(hWnd,"Could Not Load Engine");

        break;

            case    IDM_CALLENGINE:
            Inform(hWnd,"Now Calling Engine");

                CallEngine(hWnd);

            Inform(hWnd,"Engine Has Returned");
        break;

        case    IDM_KILLENGINE:
            Inform(hWnd,"Now Purging Engine");

            KillEngine(hWnd);

            Inform(hWnd,"Engine Has Been Purged");

        default:
            return DefWindowProc(hWnd,
                         message,
                                 wParam,
                         lParam);
        }

    break;

    case WM_DESTROY:
        PostQuitMessage(0);
    break;

    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return NULL;
}

/********************************************************************
    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box
********************************************************************/
BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    switch (message) {
    case WM_INITDIALOG:
        return TRUE;

    case WM_COMMAND:
        if (wParam == IDOK || wParam == IDCANCEL) {

        EndDialog(hDlg, TRUE);
        return TRUE;
        }

    break;
    }

    return FALSE;
}
