/**************************** ENGINE.H ****************************/

/* declarations for communication functions */
extern  DWORD FAR PASCAL GetFarDword(WORD hSeg,DWORD dwOffset);
extern  BYTE  FAR PASCAL GetFarByte(WORD hSeg,DWORD dwOffset);
extern  void  FAR PASCAL PutFarByte(WORD hSeg,DWORD dwOffset,
                                    BYTE byVal);
extern  void  FAR PASCAL PutFarWord(WORD hSeg,DWORD dwOffset,
                                    WORD wVal);
extern  void  FAR PASCAL PutFarDWord(WORD hSeg,DWORD dwOffset,
                                     DWORD dwVal);
extern  DWORD FAR PASCAL Call32(WORD hCode,
                                WORD hData,
                                DWORD dwOffset,
                                DWORD dwInitESP,
                                DWORD dwESI,
                                DWORD dwEDI);

/* Header of simple EXP format */
struct  EXPHeader   {

    WORD    signature;  /* MP */
    WORD    sizemod512;
    WORD    sizeinblocks;
    WORD    numrelocitem;
    WORD    headsizepara;
    WORD    mindatapages;
    WORD    maxdatapages;
    DWORD   initESP;
    WORD    checksum;
    DWORD   initEIP;
    WORD    offsetreloc;    /* 0x0000 */
    WORD    overlaynumber;  /* 0x0000 */
    WORD    endmagic;       /* 0x0001 */

};

#define MAXCHUNK  32767  /* load engine in this size chunks */

/*Offsets of important addresses relative to parameter block start*/

#define INIT            0L
#define ACTION          4L
#define BUFFER          8L
#define CBCODESEG       12L
#define CBCODEOFF       14L
#define CBDATASEG       16L
#define CBDATAOFF       18L
#define DOSDATA         20L
#define DOSCODE         22L
#define DOSSTACK        24L


#define GetInit ()      GetFarDword(hDataSeg,ParamBlock + INIT);
#define GetAction()     GetFarDword(hDataSeg,ParamBlock + ACTION);
#define GetBuffer()     GetFarDword(hDataSeg,ParamBlock + BUFFER);
#define GetCbcodeseg()  GetFarWord(hDataSeg,ParamBlock + CBCODESEG);
#define GetCbcodeoff()  GetFarWord(hDataSeg,ParamBlock + CBCODEOFF);
#define GetCbdataseg()  GetFarWord(hDataSeg,ParamBlock + CBDATASEG);
#define GetCbdataoff()  GetFarWord(hDataSeg,ParamBlock + CBDATAOFF);
#define GetDosdata()    GetFarWord(hDataSeg,ParamBlock + DOSDATA);
#define GetDoscode()    GetFarWord(hDataSeg,ParamBlock + DOSCODE);
#define GetDosstack()   GetFarWord(hDataSeg,ParamBlock + DOSSTACK);

#define SetInit(o)      PutFarDword(hDataSeg,ParamBlock + INIT,(o));
#define SetAction(o)    PutFarDword(hDataSeg,ParamBlock + ACTION,(o));
#define SetBuffer(o)    PutFarDword(hDataSeg,ParamBlock + BUFFER,(o));
#define SetCbcodeseg(o) PutFarWord(hDataSeg,ParamBlock +
                                   CBCODESEG,(o));
#define SetCbcodeoff(o) PutFarWord(hDataSeg,ParamBlock +
                                   CBCODEOFF,(o));
#define SetCbdataseg(o) PutFarWord(hDataSeg,ParamBlock +
                                   CBDATASEG,(o));
#define SetCbdataoff(o) PutFarWord(hDataSeg,ParamBlock +
                                   CBDATAOFF,(o));
#define SetDosdata(o)   PutFarWord(hDataSeg,ParamBlock + DOSDATA,(o));
#define SetDoscode(o)   PutFarWord(hDataSeg,ParamBlock + DOSCODE,(o));
#define SetDosstack(o)  PutFarWord(hDataSeg,ParamBlock + DOSSTACK,(o));
