; ------------- CALLENG.ASM - ENGINE CALLING ROUTINES ---------------
   .xlist
   include cmacros.inc
   .list
   .386

sBegin    Data
faraddr   DF     ?
OldESP    DD     ?
OldSS     DW     ?
sEnd

sBegin    Code

assumes   cs,Code
assumes   ds,Data
;extrn    doscall:far


; the following functions are used to transfer data to and from the
; communication buffer.

cProc     GetFarDword,<FAR,PUBLIC>,<bx,cx,di,si>
   parmW  DataSelector  ; Selector for data segment
   parmD  DataOffset    ; offset of value in data segment
cBegin
   push   ds
   mov    ds,DataSelector
   mov    eax,DataOffset
   mov    ecx,dword ptr [eax]

   mov    eax,ecx
   shr    eax,16
   xor    edx,edx
   mov    dx,ax
   mov    ax,cx

   pop    ds
cEnd

cProc     GetFarByte,<FAR,PUBLIC>
   parmW  DataSelector  ; Selector for data segment
   parmD  DataOffset    ; offset of value in data segment
cBegin
   push   ds
   mov    ds,DataSelector
   mov    eax,DataOffset
   mov    al,byte ptr [eax]
   and    ax,00FFh
   pop    ds
cEnd

cProc     PutFarByte,<FAR,PUBLIC>
   parmW  DataSelector  ; Selector for data segment
   parmD  DataOffset    ; offset of value in data segment
   parmB  Value         ; value
cBegin
   push   ds
   mov    ds,DataSelector
   mov    eax,DataOffset
   mov    bl,Value
   mov    byte ptr [eax],bl
   pop    ds
cEnd


cProc     PutFarWord,<FAR,PUBLIC>
   parmW  DataSelector  ; Selector for data segment
   parmD  DataOffset    ; offset of value in data segment
   parmW  Value         ; value
cBegin
   push   ds
   mov    ds,DataSelector
   mov    eax,DataOffset
   mov    bx,Value
   mov    word ptr [eax],bx
   pop    ds
cEnd

cProc     PutFarDWord,<FAR,PUBLIC>
   parmW  DataSelector  ; Selector for data segment
   parmD  DataOffset    ; offset of value in data segment
   parmD  Value         ; value
cBegin
   push   ds
   mov    ds,DataSelector
   mov    eax,DataOffset
   mov    ebx,Value
   mov    dword ptr [eax],ebx
   pop    ds
cEnd

cProc     Call32,<FAR,PUBLIC>,<bx,cx,di,si>
   parmW  CodeSelector  ; Selector for code segment
   parmW  DataSelector  ; Selector for data segment
   parmD  CodeOffset    ; offset of routine in code segment
   parmD  InitESP        ; initial value of ESP
   parmD  ParamESI      ; Value of ESI
   parmD  ParamEDI      ; Value of EDI
cBegin
assumes   ds,Data

;  save segment registers (except stack) on old stack
   push   ds
   push   es
   push   gs

   mov    esi,ParamESI  ; Pass through parameters
   mov    edi,ParamEDI  ; Pass through parameters

;  set up far address
   mov    eax,CodeOffset
   mov    dword ptr [faraddr],eax
   mov    ax,CodeSelector
   mov    word ptr [faraddr + 4],ax

;  put these in registers so we can safely alter ebp
   mov    edx,InitESP
   mov    ax,DataSelector

;  store ds in gs so we can put DataSelector in ds and still get
;  faraddr
   mov    cx,ds
   mov    gs,cx

;  save stack state in registers
   mov    ebx,esp
   mov    cx,ss

;  at this point switch to new stack.

   mov    ss,ax
   mov    esp,edx

   and    esp,0FFFFFFFCh ; align stack on 4 byte boundary for SPEED!

   push   ebx           ; push esp on new stack
   push   cx            ; push ss on new stack
   push   bp            ; save ebp

; set up ds,es to be equal to the DataSelector since our kernel code
; assumes that DS = ES = SS.

   mov    es,ax
   mov    ds,ax

;  address this off of gs so ds can be used for DataSeg

   call   fword ptr gs:[faraddr] ; call kernel

;  The init routine in the kernel is set up to return the address
;  of the parameter block in ECX.

   pop    bp            ; restore ebp register
   pop    ax            ; restore old stack selector from new stack
   pop    ebx           ; get old stack pointer off of new stack

   mov    ss,ax
   mov    esp,ebx        ; restore old stack pointer

   ; ecx contains the address of the parameter block that stores
   ; various important addresses in the 32 bit part of the program,
   ; including the offset of the call-through buffer.
   ; Move this address into DX:AX.

   mov    eax,ecx        ; get return value
   shr    eax,16
   xor    edx,edx
   mov    dx,ax
   mov    ax,cx

;  restore rest of segment registers

   pop    gs
   pop    es
   pop    ds
cEnd

sEnd

end

