/* proj.h     --constants for project manager */

/* Constants for ProjWindow drawing. 
   Others are adjustable based on screenSize, zoom view */

#define PW_MAX_ROWS     20   /* for vert. scrolling */
#define PW_MAX_COLS     40   /* for horz. scrolling */
!!

/* Constants for GanttWindow drawing.
   Others are based on screenSize(). */

#define GW_BARSPACE      4   /* space between bars */
#define GW_STARTX      100   /* start of X axis */
#define GW_STARTY       10   /* start of Y axis */
#define GW_NOTCH         5   /* axis notch size */
#define GW_DMWIDTH       5   /* diamond mid width */
!!

/* keys used to edit an activity */
#define VK_F2           113
#define VK_RETURN       13
/* accelerator keys to issue commands */
#define VK_SLASH        191
#define VK_ESC          27
!!

/* ProjWindow menu constants */

#define PW_MENUS            999

#define PW_FILE_NEW         501
#define PW_FILE_OPEN        502
#define PW_FILE_SAVE        503
#define PW_FILE_SAVEAS      504
#define PW_FILE_PRINT       505
#define PW_ABOUT_ACTOR      506
#define PW_FILE_PRINT_GRAPH 507

#define PW_DEL_ACTIVITY     510
#define PW_DEL_RESOURCE     511

#define PW_NEW_MSTONE       551
#define PW_NEW_TASK         552
#define PW_NEW_PERT         553

#define PW_ZOOM             700
#define PW_DISPLAY          701
#define PW_AUTOCALC         702
#define PW_CALC             703
#define PW_SHOWROOM         704

#define PW_VIEW_SUMMARY     801
#define PW_VIEW_ACTIVITIES  802
#define PW_VIEW_GANTT       803
#define PW_VIEW_RESOURCES   804
#define PW_VIEW_RESOURCE    805

#define PW_HELP             810
#define PW_COMMAND_MODE     811
!!

/* GanttWindow menus */
#define GW_MENUS            998
#define GW_HELP             810
!!

/* Dialog boxes */
#define MSTONE_BOX          801
#define TASK_BOX            802
#define PERT_BOX            803
#define SETTING_BOX         804
#define PROJ_BOX            805
#define PW_HELP_BOX         806
#define GW_HELP_BOX         807
#define RES_BOX             808
#define PW_ABOUT_ACTOR_BOX  809
#define NOMEM               -1    /* runModal fail */
!!

/* Dialog box fields */
#define ES                  901
#define LS                  902
#define EF                  903
#define LF                  904
#define SLACK               905
#define COST                906
#define TIME                907
#define UES                 908
#define ULF                 909
#define FC                  910
#define RES                 911
#define NAME                912
#define DESC                913
#define INPUT               914
#define OUTPUT              915

#define LIKELY_TIME         916  /* for pert only... */
#define BEST_TIME           917
#define WORST_TIME          918
!!

/* display setting dialog push buttons */

#define TTIME               921         /* top settings */
#define TSLACK              922
#define TCOST               923
#define TES                 924
#define TEF                 925
#define TLS                 926
#define TLF                 927

#define BTIME               931         /* bottom settings */
#define BSLACK              932
#define BCOST               933
#define BES                 934
#define BEF                 935
#define BLS                 936
#define BLF                 937

#define PW_CLEAR            940         /* clear settings */
!!

/* for project resources */
#define MAX                 950
#define VC                  951
!!

/* string constants used for resource translation to other langs */

#define PW_APPNAME          501
#define PW_WARNING          502
#define PW_DISCARD          503
#define PW_SAVEPROJ         504
#define PW_ACTIVT1          505
#define PW_ACTIVT2          506
#define PW_ACTIVT3          507
#define PW_REST1            508
#define PW_REST2            509
#define PW_REST3            510
#define PW_PRINTERR1        511
#define PW_PRINTERR2        512
#define PW_NA1              513
#define PW_NA2              514
#define PW_DELRES1          515
#define PW_DELRES2          516
#define PW_DELACT1          517
#define PW_DELACT2          518
#define PW_VIEWRES1         519
#define PW_VIEWRES2         520
#define PW_SHOWROOM1        521
#define PW_SHOWROOM2        522
#define PW_SHOWRES2         524
#define PW_GANTT            525
#define PW_SHOWACT2         527
#define PW_ERROR1           528
#define PW_ERROR2           529
#define PW_RESOURCE         530
#define PW_RESUSE           531
#define PW_DELETE           532
#define PW_PROJECT          533
#define PW_PROJT1           534
#define PW_START            535
#define PW_FINISH           536
#define PW_RESINVAL         537
#define PW_NOTEXIST         539
#define PW_ACTUSE1          540
#define PW_ACTUSE2          541
#define PW_CRITICAL         542
#define PW_NONCRITICAL      543
#define PW_MILESTONE        544
#define PW_TASK             545
#define PW_PERTTASK         546
#define PW_ERRCONNECT1      547
#define PW_ERRCONNECT2      548
#define PW_ERRCONNECT3      549
#define PW_ERRDATE1         551
#define PW_ERRDATE2         552
#define PW_ERRDATE3         553
#define PW_MMDDYY           554
#define PW_DDMMYY           555
#define PW_YYMMDD           556
#define PW_ERRMEM1          558
#define PW_ERRMEM2          559
#define PW_NODEINVAL        560
!!
