/* Display and edit the Task information.
   This class descends from class MStoneDialog and
   inherits all of its data and behavior.
*/!!

inherit(MStoneDialog, #TaskDialog, nil, 2, nil)!!

now(TaskDialogClass)!!

now(TaskDialog)!!

/* Set the values of the activity. */
Def  setValues(self | ues, ulf)
{
  ues := checkDate(getItemText(self, UES));
  ulf := checkDate(getItemText(self, ULF));
  setValues(activity, tuple(
    getItemText(self, NAME),
    getItemText(self, DESC),
    ues,
    ulf,
    asDec(getItemText(self, TIME)),
    asDec(getItemText(self, FC)),
    getItemText(self, RES)));
} !!

/* Return the resource ID that should be used with this
   dialog box. */
Def  res(self)
{
  ^TASK_BOX;
}!!

/* Initialize the dialog so all fields have the correct values. */
Def initDialog(self, wp, lp)
{
  initDialog(self:MStoneDialog, wp, lp);    /* use ancestor init */
  setItemText(self, TIME, asString(getTime(activity)));
  setItemText(self, FC, asString(getFixedCost(activity)));
  setItemText(self, RES, getResourceNames(activity));
  setItemText(self, COST, asString(getCost(activity)));
}
!!

