/* Edit a resource.
   This class descends from class ActivDialog and inherits all
   of its data and behaviors.  The edit item is therefore called
   activity, even though it is really a resource.
*/!!

inherit(ActivDialog, #ResDialog, nil, 2, nil)!!

now(ResDialogClass)!!

now(ResDialog)!!

/* Update the edit item (activity) after Ok was pressed.
   Adjust a zero max value to be nil. */
Def  update(self | max)
{
  max := asDec(getItemText(self,MAX));
  if max == 0
    max := nil;
  endif;
    
  setValues(activity, tuple(
      getItemText(self, NAME),
      max,
      asDec(getItemText(self, FC)),
      asDec(getItemText(self, VC))));
} !!

/* Return the resource ID that should be used with this
   dialog box. */
Def  res(self)
{
  ^RES_BOX;
}!!

/* Initialize the dialog so all fields have the correct values. */
Def initDialog(self, wp, lp)
{
  setText(self, makeCaption(activity));
  setItemText(self, NAME, asString(getName(activity)));
  setItemText(self, MAX, asString(getMaximum(activity)));
  setItemText(self, FC, asString(getFixedCost(activity)));
  setItemText(self, VC, asString(getVariableCost(activity)));
}
!!

