/* Project Window Settings dialog.  Allows the user to
   specify what information will be displayed above and
   below each node on the screen. 
   Note: The parent of this dialog must be a ProjWindow.
*/!!

inherit(Dialog, #PWSetDialog, #(top      /* selected button offset */
bot      /* selected button offset */), 2, nil)!!

now(PWSetDialogClass)!!

now(PWSetDialog)!!

/* A radio button was pressed.  Determine which
   group it belonged to and update the others. 
   Store the newly updated top or bottom offset number.*/
Def  buttonPress(self, aButton)
{
  if between(aButton, TTIME, TLF)
    Call CheckRadioButton(hWnd, TTIME, TLF, aButton);
    top := aButton - TTIME;
  else
    Call CheckRadioButton(hWnd, BTIME, BLF, aButton);
    bot := aButton - BTIME;
  endif;
  
}!!

/* Update the methods of the project window. */
Def  update(self)
{
  setTopMethod(parent, top);
  setBotMethod(parent, bot);
}!!

/* Initialize the dialog so buttons are correct. */
Def initDialog(self, wp, lp)
{
  if top := getTopMethod(parent)
    Call CheckRadioButton(hWnd, TTIME, TLF, top + TTIME);
  endif;
  if bot := getBotMethod(parent)
    Call CheckRadioButton(hWnd, BTIME, BLF, bot + BTIME);
  endif;
}
!!

/* Handle the pressing of buttons.  If Ok was 
   pressed, then update the methods used to
   display information. */
Def command(self, wp, lp)
{
  select
    case wp == IDOK
       update(self);
       end(self, IDOK);
    endCase
    case wp == IDCANCEL            
       end(self, IDCANCEL);
    endCase
    case wp == PW_CLEAR
       top := nil;
       bot := nil;
       update(self);
       end(self, IDOK);
    endCase
    default  /* a radio button was pressed */
       buttonPress(self, wp);
      ^1;  
  endSelect;
  ^0;  
} !!

