/* For editing project information.
   This class descends from class ActivDialog and inherits
   all of its data and operations.  As such, the edit item
   is called activity, even though it is really a project.
*/!!

inherit(ActivDialog, #ProjDialog, nil, 2, nil)!!

now(ProjDialogClass)!!

now(ProjDialog)!!

/* Update the edit item (activity) after Ok was pressed. */
Def  update(self | ues, ulf)
{
  ues := checkDate(getItemText(self, UES));
  ulf := checkDate(getItemText(self, ULF));
  if not(ues)
    ues := date(1,1,1988);
  endif;
  setValues(activity, tuple(
      getItemText(self, NAME),
      getItemText(self, DESC),
      ues,
      ulf));
} !!

/* Return the resource ID that should be used with this
   dialog box. */
Def  res(self)
{
  ^PROJ_BOX;
}!!

/* Initialize the dialog so all fields have the correct values. */
Def initDialog(self, wp, lp)
{
  initDialog(self:ActivDialog, wp, lp);   /* ancestor init */
  setItemText(self, TIME, asString(getTime(activity)));
  setItemText(self, COST, asString(getCost(activity)));
}
!!

