/* PERT Tasks have additional fields that can be edited.
   This class descends from class TaskDialog and inherits
   all of its data and operations.
*/!!

inherit(TaskDialog, #PERTDialog, nil, 2, nil)!!

now(PERTDialogClass)!!

now(PERTDialog)!!

/* Set the values of the activity. */
Def  setValues(self | ues, ulf)
{
  ues := checkDate(getItemText(self, UES));
  ulf := checkDate(getItemText(self, ULF));
  setValues(activity, tuple(
    getItemText(self, NAME),
    getItemText(self, DESC),
    ues,
    ulf,
    asDec(getItemText(self, LIKELY_TIME)),
    asDec(getItemText(self, BEST_TIME)),
    asDec(getItemText(self, WORST_TIME)),
    asDec(getItemText(self, FC)),
    getItemText(self, RES)));
} !!

/* Return the resource ID that should be used with this
   dialog box. */
Def  res(self)
{
  ^PERT_BOX;
}!!

/* Initialize the dialog so all fields have the correct values. */
Def initDialog(self, wp, lp)
{
  initDialog(self:TaskDialog, wp, lp);    /* use ancestor init */

  setItemText(self, LIKELY_TIME, asString(getLikelyTime(activity)));
  setItemText(self, BEST_TIME, asString(getBestTime(activity)));
  setItemText(self, WORST_TIME, asString(getWorstTime(activity)));
}
!!

