/* Display and edit the Milestone settings.
   This class descends from class ActivDialog
   and inherits all of its methods and operations.
*/!!

inherit(ActivDialog, #MStoneDialog, nil, 2, nil)!!

now(MStoneDialogClass)!!

now(MStoneDialog)!!

/* Set the values of the activity. */
Def  setValues(self | ues, ulf)
{
  ues := checkDate(getItemText(self, UES));
  ulf := checkDate(getItemText(self, ULF));
  setValues(activity, tuple(
      getItemText(self, NAME),
      getItemText(self, DESC),
      ues,
      ulf));
}!!

/* Return the resource ID that should be used with this
   dialog box. */
Def  res(self)
{
  ^MSTONE_BOX;
}!!

/* Update the activity after Ok was pressed.
   Descendants should define their own setValues(). */
Def  update(self)
{
  setName(activity, getItemText(self, NAME));
  addNode(getNetwork(activity), activity);
  
  checkConnection(activity,
          getItemText(self, INPUT),
          getItemText(self, OUTPUT));
  
  setValues(self);
} !!

/* Initialize all of the fields in the dialog. */
Def  initDialog(self, wp, lp)
{
  initDialog(self:ActivDialog, wp, lp);  /* use ancestor init */
  setItemText(self, INPUT, getInputNames(activity));
  setItemText(self, OUTPUT, getOutputNames(activity));
}!!


