/* A Milestone marks the completion of significant tasks.
   Milestones do not consume resources or take time. 
   Milestones are used whenever a path must split or
   join.

   Milestones descend from Activity and inherit all of
   their methods and instance variables.
*/!!

inherit(Activity, #Milestone, nil, 2, nil)!!

now(MilestoneClass)!!

now(Milestone)!!

/* Return the class name.  Uses resources for translation. */
Def className(self)
{
  ^loadString(PW_MILESTONE);
}!!

/* Draw a Milestone at a location in a window.
   The window manages the details of what the
   Milestone will look like, since it could be
   a PERT chart or a Gantt chart. */
Def  draw(self, window, x, y, hDC)
{ 
  drawMilestone(window, self, x, y, hDC);
}!!

/* Return the appropriate dialog class to be used
   by editInfo(). */
Def  dialogClass(self)
{
  ^MStoneDialog;
}!!

/* Milestones don't have a cost, but should respond to the message. */
Def  getCost(self)
{ ^0;
}!!

/* Milestones don't have resources, but should respond to the message. */
Def  getResources(self)
{
 errorBox("getResources","Milestone:"+name);
 ^nil;
}!!

/* Milestones don't have a cost, but should respond to the message. */
Def  calcCost(self)
{ ^0;
}!!

/* Milestones don't have a time, but should respond to the message. */
Def  getTime(self)
{ ^0;
}!!

