/* This is a formal class to define common behavior between
   the various dialog boxes in the project application. 
   Descendants should define the res() method to return the
   resource ID to be used, initDialog() to initialize values
   and update() to update values.

   ActivDialog descends from class Dialog and inherits all of its
   methods and instance variables.
*/!!

inherit(Dialog, #ActivDialog, #(activity  /* what is being edited */), 2, nil)!!

now(ActivDialogClass)!!

now(ActivDialog)!!

/* Set the object being edited. */
Def  setEditItem(self, anEditItem)
{
  activity := anEditItem;
}!!

/* Run the dialog with the appropriate resource. 
   Display a warning if the run fails. */
Def  run(self, parent | retValue)
{
  ^checkRunModal(self, res(self), parent);
}!!

/* Initialize all of the fields in the dialog. */
Def  initDialog(self, wp, lp)
{
  setText(self, makeCaption(activity));
  
  setItemText(self, NAME, getName(activity));
  setItemText(self, DESC, getDesc(activity));
  setItemText(self, UES, checkString(getUserEarlyStart(activity)));
  setItemText(self, ULF, checkString(getUserLateFinish(activity)));

  /* these are non-editable */
  setItemText(self, ES, asString(getEarlyStart(activity)));
  setItemText(self, EF, asString(getEarlyFinish(activity)));
  setItemText(self, LS, asString(getLateStart(activity)));
  setItemText(self, LF, asString(getLateFinish(activity)));
  setItemText(self, SLACK, asString(getSlack(activity)));
}!!

/* Handle the Ok and Cancel buttons.  If Ok was 
   pressed, then update the item.  This command
   method is used by descendants.  They will define
   their own update method.  */
Def command(self, wp, lp)
{
  select
    case wp == IDOK
       update(self);
       end(self, IDOK);
    endCase
    case wp == IDCANCEL            
       end(self, IDCANCEL); 
    endCase
    default 
      ^1;
  endSelect;
  ^0;
} !!

