page	58,132
TITLE	RS203	6-23-86	[10-1-91]

;Original disassembly to see exactly what that E1 "enable"
;means (chasing a potential MSKermit bug).

;v2.04, 1 Oct 91
; - Rewrite, tightening up a little.
; - Removed all the fancy BIOS screen displays,
;   with everything now going to STDOUT (for redirection).
;
;David Kirschbaum
;Toad Hall
;kirsch@usasoc.soc.mil

LF	EQU	0AH
CR	EQU	0DH

CSEG	SEGMENT
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	ORG	100H

RS_100	proc	near
	JMP	RS_532

;COM1 port address table
com1tbl_103	DW	03F8H	;[BX]	;UART base
		dw	03F9H	;[BX+2]	;base+1 IER
		dw	03F9H	;[BX+4]	;base+1 IER
		dw	03FBH	;[BX+6]	;base+3, LCR
		DW	03FCH	;[BX+8]	;base+4, MCR
		dw	03FDH	;[BX+0A];base+5, LSR
		dw	03FEH	;[BX+0C];base+6, MSR
;COM2 port address table
com2tbl_111	DW	02F8H,2 DUP(02F9H),02FBH
		DW	02FCH,02FDH,02FEH

bauddiv_11F	DW	0		;baudrate divisor

ier_121		db	0		;Interrupt Enable Register status
lcr_122		db	0		;Line Control Register status
mcr_123		db	0		;Modem Control Register status
lsr_124		db	0		;Line Status Register status
msr_125		db	0		;Modem Status Register status
lcr_126		db	0		;LCR status w/8-bit OR'ed
		db	0

numbuff_12F	DB	'      $'

buff_129 label	byte		;overwrites intro			v2.04
logo$	DB '                RS  Copyright Fred E. Davis 1986    Ver. 2.04'
	db	CR,LF
crlf	db	CR,LF,'$'

usage$	DB	'RS [n] where [n] is 1 for COM1 or 2 for COM2'	;v2.04
	db	CR,LF,'Defaults to COM1$'

com1$176	DB	CR,'COM1:$'
com2$17D	DB	CR,'COM2:$'
msg_184	DB	' not installed!',CR,LF,CR,LF,CR,LF,'$'
msg_194	DB	CR,LF,'A. Protocol:                    B. Handshake Status:'
	db	CR,LF,'  1. Data Bits: $'
msg_1DD	DB				'            1. DTR Out: $'
msg_1F6	DB	CR,LF,'  2. Stop Bits: $'
msg_209	DB				'            2. RTS Out: $'
msg_222	DB	CR,LF,'  3. Parity   : $'
msg_235	DB				'            3. CTS In : $'
msg_24E	DB	CR,LF,'  4. Rate     : $'
msg_261	DB				'            4. DSR In : $'
msg_27A	DB	CR,LF,'  5. Stick    : $'
msg_28D	DB				'            5. CD In  : $'
msg_2A6	DB	CR,LF,'  6. Break    : $'
msg_2B9	DB				'            6. RI In  : $'
msg_2D2	DB	CR,LF,CR,LF
	DB	'C. Line Status:                 D. Error Status:',CR,LF
	DB	'  1. Receive Buffer : $'
msg_31F	DB				'      1. Overrun: $'
msg_332	DB	CR,LF,'  2. Transmit Buffer: $'
msg_34B	DB				'      2. Parity : $'
msg_35E	DB	CR,LF,'  3. Break Status   : $'
msg_377	DB				'      3. Frame  : $'
msg_38A	DB	CR,LF,'  4. Loop Back      : $'
msg_3A3	DB	CR,LF,CR,LF
	DB	'E. Interrupt Status:'
	db	CR,LF,'  1. Output      : $'
msg_3D1	DB	CR,LF,'  2. Data Ready  : $'
msg_3E7	DB	CR,LF,'  3. Xmit Empty  : $'
msg_3FD	DB	CR,LF,'  4. Line Status : $'
msg_413	DB	CR,LF,'  5. Modem Status: $'
msg_42C		DB	'1     $'
msg_433		DB	'2     $'
msg_43A		DB	'5     $'
msg_441		DB	'6     $'
msg_448		DB	'7     $'
msg_44F		DB	'8     $'
odd$		DB	'odd   $'
even$		DB	'even  $'
none$		DB	'none  $'
norm$		DB	'normal$'
set$		DB	'set   $'

baudtbl_479	label	byte
	DB	'50    $'
	dw	0900H		;DB	0,9
	db	'75    $'
	dw	0600H		;DB	0,6
	db	'110   $'
	dw	0417H		;DB	17H,4
	db	'134.5 $'
	dw	0359H		;DB	59H,3
	db	'150   $'
	dw	0300H		;DB	0,3
	db	'300   $'
	dw	0180H		;DB	80H,1
	db	'600   $'
	dw	00C0H		;DB	0C0H,0
	db	'1200  $'
	dw	0060H		;DB	60H,0
	db	'1800  $'
	dw	0040H		;DB	40H,0
	db	'2000  $'
	dw	003AH		;DB	3AH,0
	db	'2400  $'
	dw	0030H		;DB	30H,0
	db	'3600  $'
	dw	0020H		;DB	20H,0
	db	'4800  $'
	dw	0018H		;DB	18H,0
	db	'7200  $'
	dw	0010H		;DB	10H,0
	db	'9600  $'
	dw	000CH		;DB	0CH,0

fast$	DB	'fast!!$'
empty$	DB	'empty $'
full$	DB	'full  $'
low$	DB	'low   $'
high$	DB	'high  $'
enable$	DB	'enable$'
disable$ DB	'disable$'

RS_100	endp

RS_532	proc	near

;v2.04 Use STDOUT for all displays
	mov	dx,offset logo$		;copyright			v2.04
	mov	ah,9			;display msg to stdout		v2.04
	int	21H

	MOV	DI,81H			;PSP cmdline
	MOV	AL,20H	;' '		;gobble leading spaces
	MOV	CX,44H			;max cmdline length
	CLD
	REPZ	SCASB
;v2.04 assume COM1
	mov	bx,offset com1tbl_103	;use COM1's table	v2.04
	mov	dx,offset com1$176	;CR,'COM1:$'		v2.04

	MOV	AL,[DI-1]		;get last pre-space char
	jcxz	Skp594			;zeroed out cmdline, use COM1	v2.04

	CMP	AL,CR			;No cmd parm ...
	jz	Skp594			;.. so use COM1			v2.04
	CMP	AL,31H	;'1'		;COM1?
	jz	Skp594			;.. so use COM1			v2.04

	CMP	AL,32H	;'2'		;COM2?
	JZ	Use_COM2_58E		;yep
	 mov	dx,offset usage$	;tell the dummy how		v2.04
	 jmp	short Msg_Term		;display, terminate		v2.04


Use_COM2_58E:
	MOV	BX,OFFSET com2tbl_111	;use COM2's table
	MOV	DX,OFFSET com2$17D	;CR,'COM2:$'

Skp594:	MOV	AH,9			;display "COMn:"
	INT	21H

	MOV	DX,[BX+6]		;base+3, LCR Line Control Register
	IN	AL,DX
	OR	AL,80H			;turn on 8-bit
	MOV	lcr_126,AL		;save it
	OUT	DX,AL

	MOV	AH,AL			;save LCR status in AH
	MOV	CX,03E8H		;delay value
Lup5A7:	LOOP	Lup5A7			;delay a bit
	IN	AL,DX			;read LCR
	CMP	AH,AL			;match original?
	JNZ	Not_Installed_5CE	;'Not installed', die

	MOV	DX,[BX]			;UART base
	IN	AL,DX			;get baudrate divisor lsb
	MOV	byte ptr bauddiv_11F,AL	;save
	INC	DX			;bump to divisor msb
	IN	AL,DX
	MOV	byte ptr bauddiv_11F+1,AL	;save it

;Toggle LCR back off again so we can read the port normally

	MOV	DX,[BX+6]		;base+3, LCR
	MOV	AL,lcr_126		;saved LCR status w/8-bit OR'ed
	AND	AL,7FH			;mask that bit off again
	OUT	DX,AL			;out the port

	MOV	AH,AL			;save that LCR status
	MOV	CX,03E8H		;delay value
Lup5C7:	LOOP	Lup5C7			;delay a bit
	IN	AL,DX			;read the port
	CMP	AH,AL			;still match?
	JZ	Skp5F3			;yep, continue

Not_Installed_5CE:
	mov	dx,offset msg_184	;' not installed!'		v2.04
Msg_Term:				;v2.04
	MOV	AH,9
	INT	21H
	MOV	AL,1			;ERRORLEVEL 1
	JMP	Term_937		;terminate

Skp5F3:
	MOV	DX,[BX+4]		;base+1, IER Interrupt Enable Register
	mov	di,offset ier_121	;start of saved status		v2.04
	IN	AL,DX
	stosb				;ier_121, save IER status	v2.04
	MOV	DX,[BX+6]		;base+3, LCR
	IN	AL,DX
	stosb				;lcr_122, save LCR status	v2.04
	MOV	DX,[BX+8]		;base+4, MCR Modem Control Register
	IN	AL,DX
	stosb				;mcr_123, save MCR status	v2.04
	MOV	DX,[BX+0AH]		;base+5 LSR Line Status Register
	IN	AL,DX
	stosb				;lsr_124, save LSR status	v2.04
	MOV	DX,[BX+0CH]		;base+6 MSR Modem Status Register
	IN	AL,DX
	stosb				;msr_125, save MSR status	v2.04

	MOV	DX,OFFSET msg_194	;CR,LF,'A. Protocol:
					;B. Handshake Status:'
					;CR,LF,'  1. Data Bits: $'
	MOV	AH,9
	INT	21H

	mov	si,offset lcr_122	;point to saved status bytes	v2.04
	lodsb				;lcr_122			v2.04
	mov	dx,offset msg_43A	;assume '5     $' bit data	v2.04
	AND	AL,3			;mask to data bits
	jz	Pr_641			;0 = 5				v2.04
	mov	dx,offset msg_441	;assume '6     $' bit data	v2.04
	DEC	AL
	jz	Pr_641			;1 = 6				v2.04
	mov	dx,offset msg_448	;assume '7     $' bit data	v2.04
	DEC	AL
	jz	Pr_641			;2 = 7				v2.04
	 MOV	DX,OFFSET msg_44F	;'8     $' bit data

Pr_641:	MOV	AH,9			;display data bit data
	INT	21H

	MOV	DX,OFFSET msg_1DD	;'            1. DTR Out: $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;mcr_123, MCR status		v2.04
	mov	dx,offset high$		;assume 'high  $'		v2.04
	AND	AL,1			;mask for DTR
	jz	Pr_65C			;1 = high			v2.04
	 MOV	DX,OFFSET low$		;'low   $'
Pr_65C:	MOV	AH,9			;display DTR Out status
	INT	21H

	MOV	DX,OFFSET msg_1F6	;CR,LF,'  2. Stop Bits: $'
	MOV	AH,9
	INT	21H
	dec	si			;back up to lcr_122		v2.04
	lodsb				;lcr_122, LCR status		v2.04
	mov	dx,offset msg_433	;assume '2     $' stop bits	v2.04
	AND	AL,4			;mask for stop bits
	jnz	Pr_677			;1 = 2 stop bits		v2.04
	 MOV	DX,OFFSET msg_42C	;'1     $' stop bits
Pr_677:	MOV	AH,9			;display stop bit data
	INT	21H

	MOV	DX,OFFSET msg_209	;'            2. RTS Out: $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;mcr_123, MCR status		v2.04
	mov	dx,offset high$		;assume 'high  $' RTS		v2.04
	AND	AL,2			;mask for RTS
	jnz	Pr_692			;non-0 = high			v2.04
	 MOV	DX,OFFSET low$		;'low   $' RTS
Pr_692:	MOV	AH,9			;display RTS out status
	INT	21H

	MOV	DX,OFFSET msg_222	;CR,LF,'  3. Parity   : $'
	MOV	AH,9
	INT	21H
	dec	si			;back up to lcr_122 again	v2.04
	mov	al,[si]			;lcr_122 status			v2.04
	mov	dx,offset none$		;assume 'none  $'		v2.04
	AND	AL,8			;mask for parity bit
	jz	Pr_6Bx			;display none			v2.04
	mov	al,[si]			;get lcr_122 status again	v2.04
	mov	dx,offset even$		;assume 'even  $'		v2.04
	AND	AL,10H			;mask for parity bit
	jnz	Pr_6Bx			;even				v2.04
	 MOV	DX,OFFSET odd$		;'odd   $'
Pr_6Bx:	MOV	AH,9			;display Parity status
	INT	21H

Skp6C1:	MOV	DX,OFFSET msg_235	;'            3. CTS In : $'
	MOV	AH,9
	INT	21H

	MOV	AL,msr_125		;MSR status
	mov	dx,offset high$		;assume 'high  $' CTS in	v2.04
	AND	AL,10H			;mask to CTS bit
	jnz	Pr_6D8			;non-0 = high			v2.04
	 MOV	DX,OFFSET low$		;'low   $' CTS In
Pr_6D8:	MOV	AH,9			;display CTS In status
	INT	21H

	MOV	DX,OFFSET msg_24E	;CR,LF,'  4. Rate     : $'
	MOV	AH,9
	INT	21H

	MOV	AX,bauddiv_11F		;baudrate divisor
	MOV	DI,7
	MOV	CX,10H			;total 16 records
Lup6EC:	CMP	AX,word ptr [DI+baudtbl_479]
	JZ	GotBaud_6F9
	ADD	DI,9			;next record
	LOOP	Lup6EC
	JCXZ	No_TableBaud_709

GotBaud_6F9:
	MOV	AX,DI			;record end
	SUB	AX,7			;back up to the string
	ADD	AX,OFFSET baudtbl_479	;table start
	MOV	DX,AX
	MOV	AH,9
	INT	21H
	JMP	SHORT	Check_DSR_763	;skip to DSR check

;Baudrate wasn't in our table
No_TableBaud_709:
	CMP	AX,2			;divisor < 2?
	JB	FastBaud_75C		;yep, just say fast!!

;Compute and display the raw baudrate

	MOV	BX,AX			;divisor into BX
	MOV	CL,4
	SHL	BX,CL			;*16
	MOV	DX,1CH			;long division
	MOV	AX,2000H
	DIV	BX

	MOV	DI,OFFSET buff_129	;Asciify the result
	XOR	BX,BX			;buffer base
	MOV	CX,6			;6-byte buffer
Lup728:	MOV	BYTE PTR [BX+DI],0	;initialize buffer
	INC	BX
	LOOP	Lup728

	XCHG	BX,DI			;BX -> buffer start
	DEC	BX			;back up 1
	MOV	DI,0AH			;10 constant for dividing
Lup734:	XOR	DX,DX			;clear overflow
	DIV	DI			;/10
	INC	BX			;bump buffer ptr
	INC	CX			;bump digit counter
	MOV	[BX],DL			;stuff Ascii char in buffer
	OR	AX,AX			;done?
	JNZ	Lup734			;nope

	XOR	DI,DI			;string buffer base offset
Lup742:	MOV	AL,[BX]			;Ascii char
	OR	AL,30H			;mask to uppercase?
	MOV	[DI+numbuff_12F],AL	;stuff in blank string
	DEC	BX
	INC	DI
	DEC	CX
	JNZ	Lup742

	MOV	DX,OFFSET numbuff_12F	;display ASCII number
	MOV	AH,9
	INT	21H

	JMP	SHORT	Check_DSR_763	;skip to DSR check

FastBaud_75C:
	MOV	DX,OFFSET fast$		;'fast!!$'
	MOV	AH,9
	INT	21H

Check_DSR_763:
	MOV	DX,OFFSET msg_261	;'            4. DSR In : $'
	MOV	AH,9
	INT	21H
	mov	si,offset msr_125	;MSR status			v2.04
	mov	al,[si]			;msr_125 MSR status		v2.04
	mov	dx,offset high$		;assume 'high  $'		v2.04
	AND	AL,20H			;mask to MSR bit
	jnz	Pr_77A			;non-0 = high			v2.04
	 MOV	DX,OFFSET low$		;'low   $'
Pr_77A:	MOV	AH,9			;display DSR In status
	INT	21H

	MOV	DX,OFFSET msg_27A	;'CR,LF,'  5. Stick    : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lcr_122		;get LCR status
	mov	dx,offset set$		;assume 'set   $'		v2.04
	AND	AL,20H			;mask to "stick" status
	JNZ	Pr_795			;non-0 means "set"		v2.04
	 MOV	DX,OFFSET norm$		;'normal$'
Pr_795:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_28D	;'            5. CD In  : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;msr_125 MSR status		v2.04
	mov	dx,offset high$		;assume 'high  $'		v2.04
	AND	AL,80H			;mask to Carrier Detect status
	JNZ	Pr_7B0			;non-0 means high		v2.04
	 MOV	DX,OFFSET low$		;'low   $'
Pr_7B0:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_2A6	;CR,LF,'  6. Break    : $'
	MOV	AH,9
	INT	21H
	MOV	AL,lcr_122		;get LCR status
	mov	dx,offset set$		;assume 'set   $'		v2.04
	AND	AL,40H			;mask break bit
	JNZ	Pr_7CB			;non-0 = set			v2.04
	 MOV	DX,OFFSET norm$		;'normal$'
Pr_7CB:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_2B9	;'            6. RI In  : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;msr_125 MSR status		v2.04
	mov	dx,offset high$		;assume 'high  $'		v2.04
	AND	AL,40H			;mask Ring Indicator bit
	jnz	Pr_7E6			;non-0 = high			v2.04
	 MOV	DX,OFFSET low$		;'low   $'
Pr_7E6:	MOV	AH,9			;display RI in status
	INT	21H

;'C. Line Status:                 D. Error Status:',CR,LF
;'  1. Receive Buffer : $'
	MOV	DX,OFFSET msg_2D2
	MOV	AH,9
	INT	21H

	dec	si			;back down to lsr_124		v2.04
	mov	al,[si]			;lsr_124 LSR status		v2.04
	mov	dx,offset full$		;assume 'full  $'		v2.04
	AND	AL,1			;mask Receive Buffer status byte
	jnz	Pr_801			;non-0 = full			v2.04
	 MOV	DX,OFFSET empty$	;'empty $'
Pr_801:	MOV	AH,9			;display Receive Buffer status
	INT	21H

	MOV	DX,OFFSET msg_31F	;'      1. Overrun: $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;lsr_124 LSR status		v2.04
	mov	dx,offset set$		;assume 'set   $'		v2.04
	AND	AL,2			;mask Overrun error bit
	jnz	Pr_81C			;non-0 = set			v2.04
	 MOV	DX,OFFSET none$		;'none  $'
Pr_81C:	MOV	AH,9			;display Overrun error bit
	INT	21H

	MOV	DX,OFFSET msg_332	;CR,LF,'  2. Transmit Buffer: $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;lsr_124 LSR status		v2.04
	mov	dx,offset empty$	;assume 'empty $'		v2.04
	AND	AL,20H			;mask Transmit Buffer status bit
	jnz	Pr_837			;non-0 = empty			v2.04
	 MOV	DX,OFFSET full$		;'full  $'
Pr_837:	MOV	AH,9			;display Transmit Buffer status
	INT	21H

	MOV	DX,OFFSET msg_34B	;'      2. Parity : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;lsr_124 LSR status		v2.04
	mov	dx,offset set$		;assume 'set   $'		v2.04
	AND	AL,4			;mask Parity error bit
	jnz	Pr_852			;non-0 = set			v2.04
	 MOV	DX,OFFSET none$		;'none  $'
Pr_852:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_35E	;'  3. Break Status   : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;lsr_124 LSR status		v2.04
	mov	dx,offset set$		;assume 'set   $'		v2.04
	AND	AL,10H			;mask Break Status bit
	jnz	Pr_86D			;non-0 = set			v2.04
	 MOV	DX,OFFSET none$		;'none  $'
Pr_86D:	MOV	AH,9			;display Break Status bit
	INT	21H

	MOV	DX,OFFSET msg_377	;'      3. Frame  : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;lsr_124			v2.04
	mov	dx,offset set$		;assume 'set   $'		v2.04
	AND	AL,8			;mask Frame error bit
	jnz	Pr_888			;non-0 = set			v2.04
	 MOV	DX,OFFSET none$		;'none  $'
Pr_888:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_38A	;'  4. Loop Back      : $'
	MOV	AH,9
	INT	21H
	dec	si			;back down to mcr_123		v2.04
	mov	al,[si]			;mcr_123 MCR status		v2.04
	mov	dx,offset set$		;assume 'set   $'		v2.04
	AND	AL,10H			;mask Loop Back error bit
	jnz	Pr_8A3			;				v2.04
	 MOV	DX,OFFSET norm$		;'normal$'
Pr_8A3:	MOV	AH,9
	INT	21H

;"E. Interrupt Status:'
	MOV	DX,OFFSET msg_3A3	;CR,LF,'  1. Output      : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;mcr_123 MCR status		v2.04
	mov	dx,offset disable$	;assume 'disable$'		v2.04
	AND	AL,8			;mask Output Int Status bit
	jnz	L08BE			;non-0 = disabled		v2.04
	 MOV	DX,OFFSET enable$	;'enable$'
L08BE:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_3D1	;'  2. Data Ready  : $'
	MOV	AH,9
	INT	21H
	mov	si,offset ier_121	;Interrupt Enable Status	v2.04
	mov	al,[si]			;ier_121 IER status		v2.04
	mov	dx,offset enable$	;assume 'enable$'		v2.04
	AND	AL,1			;mask to Data Ready
	jnz	L08D9			;non-0 = enabled		v2.04
	 MOV	DX,OFFSET disable$	;'disable$'
L08D9:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_3E7	;'  3. Xmit Empty  : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;ier_121 IER status		v2.04
	mov	dx,offset enable$	;assume 'enable$'		v2.04
	AND	AL,2			;mask to Xmit buffer empty
	jnz	L08F4			;non-0 = enabled		v2.04
	 MOV	DX,OFFSET disable$	;'disable$'
L08F4:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_3FD	;'  4. Line Status : $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;ier_121 IER status		v2.04
	mov	dx,offset enable$	;assume 'enable$'		v2.04
	AND	AL,4			;mask Line Status int status
	jnz	L090F			;non-0 = enabled		v2.04
	 MOV	DX,OFFSET disable$	;'disable$'
L090F:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET msg_413	;'  5. Modem Status: $'
	MOV	AH,9
	INT	21H
	mov	al,[si]			;ier_121 IER status		v2.04
	mov	dx,offset enable$	;assume 'enable$'		v2.04
	AND	AL,8			;mask Modem Status int status
	jnz	Pr_92A			;non-0 = enabled		v2.04
	 MOV	DX,OFFSET disable$	;'disable$'
Pr_92A:	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET crlf		;CR,LF,'$'			v2.04
	MOV	AH,9
	INT	21H

	xor	al,al			;ERRORLEVEL 0			v2.04
Term_937:
	MOV	AH,4CH			;terminate, ERRORLEVEL in AL
	INT	21H

RS_532	endp

CSEG	ENDS
	END	RS_100
