;͸
; File:    MESSAGE.RS - Robocomm 4.1 script file                      
; Author:  Dan Parsons                                                
; Version: 1.0                                                        
; Revised: 04/17/92                                                   
;                                                                     
; Notes:   Requires that the PCBoard is using the "default" prompts.  
;;
TITLE "ASCII Upload a message to PCBoard 14.5"
PARAMETER 1 "Text file containing message            "
PARAMETER 2 "Conference         (Empty=Main)"
PARAMETER 3 "To                 (Empty=ALL)"
PARAMETER 4 "Subject            (Required)"
PARAMETER 5 "Security           (R=Private, N=Public)"
PARAMETER 6 "Echo Message       (Y/N)"
PARAMETER 7 "Erase after send   (Y/N)"
ENDPARAMS

; Validate parameters
IF NOT EXIST "%P1%" GOTO NOFILE
IF EMPTY "%P4%" GOTO NOSUBJECT

; Get to correct conference to send message
VENUE MAIN
IF EMPTY "%P2%" JOIN "0"
IF NOT EMPTY "%P2%" JOIN "%P2%"

; Enter the Message
MESSAGE "Sending message file %P1% to %P3%"
MESSAGE "  sec: %P5%  echo: %P6%  re: %P4%"
SEND "E|"
WHEN "TO (ENTER)"       SEND "%P3%|"
WHEN "SUBJECT ("        SEND "%P4%|"
WHEN "MESSAGE SECU"     SEND "%P5%|"
WHEN "(ENTER)=Y?"       SEND "%P6%|"
WHEN "USE FULL SCR"     SEND "N|"
WHEN "(ESC) TO EXIT"    SEND "U|"
WHEN "(ENTER) ALONE"    SEND "|U|"
WAITFOR "UPLOAD MODE"

; Upload the message
UPLOAD "%P1%" USING "ASCII"

; Save it
SEND "||S|"

;Make sure
TIMEOUT 10
WAITFOR "SAVING" FAILURE GOTO ERROR
IF YES "%P7%" GOSUB KILLIT
EXIT 0

:KILLIT
    MESSAGE "Erasing message file %P1%"
    ERASE "%P1%"
RETURN

:ERROR
    MESSAGE "ERROR: Undetermined error uploading the message"
    SEND "A|||||"
EXIT 1

:NOSUBJECT
    MESSAGE "ERROR: Missing message subject"
EXIT 1

:NOFILE
    MESSAGE "ERROR: Unable to open message file: %P1%"
EXIT 1

