TITLE "PCRelay Mail run for Wildcat!"
;-----------------------------------------------------------------------
; To use this script, make sure your defined file download protocol is
; either Robocomm's internal Zmodem or an external Zmodem batch call.
;-----------------------------------------------------------------------
PARAMETER 1 "Enter the PCRelay door #"
PARAMETER 2 "Enter the door password (optional)"
PARAMETER 3 "Enter the path\name of the OUT file"
PARAMETER 4 "Enter the desired location of IN.RLY"
ENDPARAMS

    VENUE MAIN
    SEND "D|"
    WHEN "-PAUSE-" SEND "|"
    WHEN "CONTINUE" SEND "|"
    WAITFOR "ENTER DOOR NUMBER"
    
    ; Send the door number
    SEND "%P1%|"

    ; Send the password if one was eneterd.
    IF NOT EMPTY "%P2%" SEND "%P2%|"

    CLEAR WATCHES

    ; Watch for part of the Zmodem header
    WAITFOR "*"

    ; Set the timeout value on the next line to however many seconds you think
    ; it might take for the BBS to start sending your packet:
    TIMEOUT 360

    ; Send the packet via internal Zmodem
    UPLOAD "%P3%" USING "ZMODEM"

    SEND "|"

    ; Wait for the door to start sending the messages
    WAITFOR "*"

    ; Receive your in.rly
    DOWNLOAD "%4" USING "ZMODEM"

    VENUE MAIN

EXIT 0
