; ----- KERUP: Invoke PCKERMIT to upload.
; ----------------------------------------------------------------
;	Note: This script invokes PCKERMIT using the current comm
;	port settings.
; ----------------------------------------------------------------
;
;	Get the file spec to upload
;
	GOSUB Get_Name		; Read file name into S0
	IF FAILED		; If ESC pressed
	   EXIT 		; Stop here
	   ENDIF
;
;	Invoke PCKERMIT
;
	COMPARMS S1		; read current settings
	S2 =  "PCKERMIT.EXE -l " * S1(11:14) * " -b " * S1(0:3) * " -s " * S0 ; e.g. "... -lcom2 -b1200 -s <file>
	RUN S2			; Load and run
	EXIT
;
; ----- Subroutine: Open a window and ask for a file name
;	SUCCESS/Failed returned to indicate ESCape
;	S0 returns the name
;
Get_Name:
	WOPEN 10 10 13 70 (Default) ESC
	ATSAY 10 ,12 (default)	" KERMIT upload "
	ATSAY 11 ,11 (default)	" Specify the file name:"
	ATSAY 13  30 (default) " Press ESC to exit "
	ATGET 12, 12 (default) 54 S0
	WCLOSE
	;
	;	If null response, return failed
	;
	SET SUCCESS ON		; Default return
	LJ S0			; Left justify
	IF NULL S0
	   SET SUCCESS OFF
	   ENDIF
	RETURN
	;
	;	ESC hit during entry
	;
ESC:
	S0 = ""                 ; Make a null return
	RETURN
